/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FontsColorsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "fontscolors";
    static final String TAG_FONTCOLOR = "fontcolor";
    static final String TAG_ELEMENTCOLOR = "elementcolor";
    static final String TAG_FONT = "font";
    static final String ATTR_NAME = "name";
    static final String ATTR_COLOR = "color";
    static final String ATTR_SYNTAXNAME = "syntaxName";
    static final String ATTR_FORECOLOR = "foreColor";
    static final String ATTR_BGCOLOR = "bgColor";
    static final String ATTR_SIZE = "size";
    static final String ATTR_STYLE = "style";
    static final String FILENAME = "fontsColors";

    public FontsColorsMIMEOptionFile(BaseOptions base, Object proc) {
        super(base, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadSettings(boolean propagate) {
        assert (false) : "FontsColorsMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document doc = this.dom;
            Element rootElement = doc.getDocumentElement();
            if (!TAG_ROOT.equals(rootElement.getTagName())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HashMap<String, Coloring> cm = new HashMap<String, Coloring>(SettingsUtil.getColoringMap(this.base.getKitClass(), false, true));
            cm.put(null, (Coloring)this.base.getKitClass().getName());
            HashMap<String, Coloring> mapa = cm;
            this.properties.clear();
            NodeList fc = rootElement.getElementsByTagName(TAG_FONTCOLOR);
            for (int i = 0; i < fc.getLength(); ++i) {
                Coloring def;
                Font font;
                Node node = fc.item(i);
                Element FCElement = (Element)node;
                if (FCElement == null) continue;
                String foreColor = null;
                String bgColor = null;
                String fontName = null;
                String fontSize = null;
                String fontStyle = null;
                String syntaxName = FCElement.getAttribute(ATTR_SYNTAXNAME);
                foreColor = FCElement.getAttribute(ATTR_FORECOLOR);
                bgColor = FCElement.getAttribute(ATTR_BGCOLOR);
                NodeList fnt = FCElement.getElementsByTagName(TAG_FONT);
                for (int j = 0; j < fnt.getLength(); ++j) {
                    Node nodeFnt = fnt.item(j);
                    Element FNTElement = (Element)nodeFnt;
                    if (FNTElement == null) continue;
                    fontName = FNTElement.getAttribute(ATTR_NAME);
                    if (fontName.length() == 0) {
                        fontName = null;
                    }
                    if ((fontSize = FNTElement.getAttribute(ATTR_SIZE)).length() == 0) {
                        fontSize = null;
                    }
                    if ((fontStyle = FNTElement.getAttribute(ATTR_STYLE)).length() != 0) continue;
                    fontStyle = null;
                }
                Coloring clr = SettingsUtil.getColoring(this.base.getKitClass(), syntaxName, false);
                if (clr == null) {
                    clr = SettingsUtil.getColoring(this.base.getKitClass(), "default", false);
                }
                if ((font = clr.getFont()) == null && (def = SettingsUtil.getColoring(this.base.getKitClass(), "default", false)) != null) {
                    font = def.getFont();
                }
                Font newFont = null;
                if (fontName != null || fontSize != null || fontStyle != null) {
                    int fontSizeInt;
                    if (fontName == null && font != null) {
                        fontName = font.getName();
                    }
                    if (fontSize == null) {
                        fontSizeInt = font != null ? font.getSize() : 12;
                    } else {
                        fontSizeInt = OptionUtilities.string2Int(fontSize);
                        if (fontSizeInt == -1) {
                            int n = fontSizeInt = font != null ? font.getSize() : 12;
                        }
                    }
                    int fontStyleInt = fontStyle == null ? (font != null ? font.getStyle() : 0) : OptionUtilities.getFontStyle(fontStyle);
                    newFont = new Font(fontName, fontStyleInt, fontSizeInt);
                }
                Coloring coloring = new Coloring(newFont, OptionUtilities.string2Color(foreColor), OptionUtilities.string2Color(bgColor));
                if (!mapa.containsKey(syntaxName)) continue;
                mapa.put(syntaxName, coloring);
                this.properties.put(syntaxName, coloring);
            }
            if (propagate && this.properties.size() > 0) {
                this.base.setColoringMap(mapa, false);
            }
            NodeList ec = rootElement.getElementsByTagName(TAG_ELEMENTCOLOR);
            for (int i = 0; i < ec.getLength(); ++i) {
                Node node = ec.item(i);
                Element FCElement = (Element)node;
                if (FCElement == null) continue;
                String elementName = FCElement.getAttribute(ATTR_NAME);
                String elementColorString = FCElement.getAttribute(ATTR_COLOR);
                Color elementColor = OptionUtilities.string2Color(elementColorString);
                if (elementColor == null) continue;
                boolean validProperty = false;
                if ("text-limit-line-color".equalsIgnoreCase(elementName)) {
                    if (propagate) {
                        this.base.setTextLimitLineColor(elementColor, false);
                    }
                    validProperty = true;
                } else if ("caret-color-insert-mode".equalsIgnoreCase(elementName)) {
                    if (propagate) {
                        this.base.setCaretColorInsertMode(elementColor, false);
                    }
                    validProperty = true;
                } else if ("caret-color-overwrite-mode".equalsIgnoreCase(elementName)) {
                    if (propagate) {
                        this.base.setCaretColorOverwriteMode(elementColor, false);
                    }
                    validProperty = true;
                }
                if (!validProperty) continue;
                this.properties.put(elementName, elementColor);
            }
            if (propagate) {
                this.setLoaded(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSettings(Map changedProp) {
        assert (false) : "FontsColorsMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document doc = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            this.properties.putAll(changedProp);
            Element rootElem = doc.getDocumentElement();
            HashMap elementColors = new HashMap();
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key) instanceof Coloring) {
                    Font font;
                    Coloring coloring = (Coloring)this.properties.get(key);
                    Element fontColorElem = doc.createElement(TAG_FONTCOLOR);
                    fontColorElem.setAttribute(ATTR_SYNTAXNAME, key);
                    if (coloring.getForeColor() != null) {
                        fontColorElem.setAttribute(ATTR_FORECOLOR, OptionUtilities.color2String(coloring.getForeColor()));
                    }
                    if (coloring.getBackColor() != null) {
                        fontColorElem.setAttribute(ATTR_BGCOLOR, OptionUtilities.color2String(coloring.getBackColor()));
                    }
                    if ((font = coloring.getFont()) != null) {
                        Element fontElement = doc.createElement(TAG_FONT);
                        if (font.getName() != null) {
                            fontElement.setAttribute(ATTR_NAME, font.getName());
                        }
                        fontElement.setAttribute(ATTR_SIZE, Integer.toString(font.getSize()));
                        fontElement.setAttribute(ATTR_STYLE, OptionUtilities.style2String(font.getStyle()));
                        fontColorElem.appendChild(fontElement);
                    }
                    rootElem.appendChild(fontColorElem);
                    continue;
                }
                if (!(this.properties.get(key) instanceof Color)) continue;
                elementColors.put(key, this.properties.get(key));
            }
            for (String key : elementColors.keySet()) {
                Element elementColor = doc.createElement(TAG_ELEMENTCOLOR);
                elementColor.setAttribute(ATTR_NAME, key);
                elementColor.setAttribute(ATTR_COLOR, OptionUtilities.color2String((Color)elementColors.get(key)));
                rootElem.appendChild(elementColor);
            }
            doc.getDocumentElement().normalize();
            this.saveSettings(doc);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

