/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddDomainWizardIterator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.DomainListEntry;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Profile;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class AddInstanceVisualPlatformPanel
extends JPanel {
    private Object type;
    private static Profile[] SHORT_PROFILES_LIST = new Profile[]{Profile.DEFAULT};
    private static Profile[] LONG_PROFILES_LIST = new Profile[]{Profile.DEFAULT, Profile.DEVELOPER, Profile.CLUSTER, Profile.ENTERPRISE};
    private final Set listenrs = new HashSet();
    transient RequestProcessor.Task changeEvent = null;
    private JRadioButton createPersonal;
    private JLabel description;
    private JComboBox instanceSelector;
    private JLabel instanceSelectorLabel;
    private ButtonGroup instanceTypeButtonGroup;
    private JButton openDirectoryCooser;
    private JTextField platformField;
    private JLabel platformFieldLabel;
    private JComboBox profileSelector;
    private JLabel profileSelectorLabel;
    private JRadioButton registerDefault;
    private JRadioButton registerLocal;
    private JRadioButton registerRemote;

    AddInstanceVisualPlatformPanel(File file) {
        this.initComponents();
        this.platformField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
                AddInstanceVisualPlatformPanel.this.updateDomainList();
                AddInstanceVisualPlatformPanel.this.updateProfileList();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
                AddInstanceVisualPlatformPanel.this.updateDomainList();
                AddInstanceVisualPlatformPanel.this.updateProfileList();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualPlatformPanel.this.fireChangeEvent();
                AddInstanceVisualPlatformPanel.this.updateDomainList();
                AddInstanceVisualPlatformPanel.this.updateProfileList();
            }
        });
        this.platformField.setText(file.getAbsolutePath());
        this.instanceSelector.setModel(new ComboBoxModel(){

            @Override
            public void addListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public Object getElementAt(int n) {
                return null;
            }

            @Override
            public Object getSelectedItem() {
                return null;
            }

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public void removeListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public void setSelectedItem(Object object) {
            }
        });
        this.instanceSelector.setPrototypeDisplayValue("WWWWWWWWWWWWWWWW");
        this.updateDomainList();
        this.updateProfileList();
    }

    Object getSelectedType() {
        return this.type;
    }

    String getInstallLocation() {
        return this.platformField.getText();
    }

    String getProfileConstant() {
        return "";
    }

    void setDomainsList(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            this.instanceSelector.setModel(new DefaultComboBoxModel<Object>(objectArray));
            boolean bl2 = objectArray.length >= 1;
            this.registerDefault.setEnabled(bl2);
            this.instanceSelector.setEnabled(bl2);
            this.instanceSelectorLabel.setEnabled(bl2);
            if (bl && !this.registerLocal.isSelected() && !this.registerRemote.isSelected()) {
                if (!bl2) {
                    this.createPersonal.setSelected(true);
                } else {
                    this.registerDefault.setSelected(true);
                }
            }
        } else {
            this.instanceSelector.setModel(new DefaultComboBoxModel());
        }
    }

    void setProfilesList(Profile[] profileArray, boolean bl) {
        this.profileSelector.setModel(new DefaultComboBoxModel<Profile>(profileArray));
    }

    File getDomainDir() {
        Object var1_1 = null;
        boolean bl = true;
        DomainListEntry domainListEntry = (DomainListEntry)this.instanceSelector.getSelectedItem();
        if (null != domainListEntry) {
            return domainListEntry.getDomainDir();
        }
        return null;
    }

    Profile getProfile() {
        return (Profile)((Object)this.profileSelector.getSelectedItem());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"StepName_EnterPlatformDirectory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener changeListener) {
        Set set = this.listenrs;
        synchronized (set) {
            this.listenrs.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listenrs;
        synchronized (set) {
            this.listenrs.remove(changeListener);
        }
    }

    private void fireChangeEvent() {
        if (this.changeEvent == null) {
            this.changeEvent = RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Iterator iterator;
                            Object object = AddInstanceVisualPlatformPanel.this.listenrs;
                            synchronized (object) {
                                iterator = new HashSet(AddInstanceVisualPlatformPanel.this.listenrs).iterator();
                            }
                            object = new ChangeEvent(this);
                            while (iterator.hasNext()) {
                                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
                            }
                        }
                    });
                }
            }, 100);
        } else {
            this.changeEvent.schedule(100);
        }
    }

    void setSelectedType(Object object, ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.type = object;
            this.fireChangeEvent();
        }
    }

    private String browseInstallLocation() {
        String string = null;
        PlatformInstChooser platformInstChooser = new PlatformInstChooser();
        String string2 = this.platformField.getText();
        Util.decorateChooser(platformInstChooser, string2, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_Choose_Install"));
        int n = platformInstChooser.showDialog(this, NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_Choose_Button"));
        if (n == 0) {
            string = platformInstChooser.getSelectedFile().getAbsolutePath();
        }
        return string;
    }

    private void initComponents() {
        this.instanceTypeButtonGroup = new ButtonGroup();
        this.description = new JLabel();
        this.platformFieldLabel = new JLabel();
        this.platformField = new JTextField();
        this.openDirectoryCooser = new JButton();
        this.registerDefault = new JRadioButton();
        this.instanceSelector = new JComboBox();
        this.registerLocal = new JRadioButton();
        this.registerRemote = new JRadioButton();
        this.createPersonal = new JRadioButton();
        this.instanceSelectorLabel = new JLabel();
        this.profileSelectorLabel = new JLabel();
        this.profileSelector = new JComboBox();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle");
        this.description.setText(resourceBundle.getString("TXT_platformPanelDescription"));
        this.description.setVerticalAlignment(1);
        this.description.setFocusable(false);
        this.platformFieldLabel.setHorizontalAlignment(11);
        this.platformFieldLabel.setLabelFor(this.platformField);
        Mnemonics.setLocalizedText((JLabel)this.platformFieldLabel, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"platformFieldLabel"));
        this.platformField.setAlignmentX(0.3f);
        Mnemonics.setLocalizedText((AbstractButton)this.openDirectoryCooser, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_openDirectoryChooser"));
        this.openDirectoryCooser.setAlignmentX(0.9f);
        this.openDirectoryCooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddInstanceVisualPlatformPanel.this.openDirectoryCooserActionPerformed(actionEvent);
            }
        });
        this.instanceTypeButtonGroup.add(this.registerDefault);
        Mnemonics.setLocalizedText((AbstractButton)this.registerDefault, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerDeafult"));
        this.registerDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerDefault.setMargin(new Insets(0, 0, 0, 0));
        this.registerDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AddInstanceVisualPlatformPanel.this.registerDefaultItemStateChanged(itemEvent);
            }
        });
        this.instanceSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.instanceSelector.setAlignmentX(0.3f);
        this.instanceSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddInstanceVisualPlatformPanel.this.instanceSelectorActionPerformed(actionEvent);
            }
        });
        this.instanceTypeButtonGroup.add(this.registerLocal);
        Mnemonics.setLocalizedText((AbstractButton)this.registerLocal, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerLocal"));
        this.registerLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerLocal.setMargin(new Insets(0, 0, 0, 0));
        this.registerLocal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AddInstanceVisualPlatformPanel.this.registerLocalItemStateChanged(itemEvent);
            }
        });
        this.instanceTypeButtonGroup.add(this.registerRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.registerRemote, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_registerRemote"));
        this.registerRemote.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.registerRemote.setMargin(new Insets(0, 0, 0, 0));
        this.registerRemote.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AddInstanceVisualPlatformPanel.this.registerRemoteItemStateChanged(itemEvent);
            }
        });
        this.instanceTypeButtonGroup.add(this.createPersonal);
        Mnemonics.setLocalizedText((AbstractButton)this.createPersonal, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_createPersonal"));
        this.createPersonal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createPersonal.setMargin(new Insets(0, 0, 0, 0));
        this.createPersonal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                AddInstanceVisualPlatformPanel.this.createPersonalItemStateChanged(itemEvent);
            }
        });
        this.instanceSelectorLabel.setHorizontalAlignment(11);
        this.instanceSelectorLabel.setLabelFor(this.instanceSelector);
        Mnemonics.setLocalizedText((JLabel)this.instanceSelectorLabel, (String)resourceBundle.getString("LBL_instanceSelectorLabel2"));
        this.profileSelectorLabel.setHorizontalAlignment(11);
        this.profileSelectorLabel.setLabelFor(this.profileSelector);
        Mnemonics.setLocalizedText((JLabel)this.profileSelectorLabel, (String)NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"LBL_PROFILE"));
        this.profileSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.profileSelector.setAlignmentX(0.3f);
        this.profileSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddInstanceVisualPlatformPanel.this.profileSelectorActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.platformFieldLabel, -1, 96, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.platformField, -1, 224, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.openDirectoryCooser, -1, 79, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.instanceSelectorLabel, -1, 100, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.instanceSelector, 0, 305, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.registerLocal, -1, 170, Short.MAX_VALUE).add(247, 247, 247)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.registerRemote, -1, 170, Short.MAX_VALUE).add(247, 247, 247)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.createPersonal, -1, 170, Short.MAX_VALUE).add(247, 247, 247)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(1, 1, 1).add((Component)this.registerDefault, -1, 170, Short.MAX_VALUE).add(246, 246, 246)).add((Component)this.description, -1, 417, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.profileSelectorLabel, -1, 100, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.profileSelector, 0, 305, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.description).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.platformFieldLabel, -2, 26, -2).add((Component)this.platformField, -2, 26, -2)).add(11, 11, 11).add((Component)this.registerDefault).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.instanceSelectorLabel, -2, 25, -2).add((Component)this.instanceSelector, -2, -1, -2)).add(11, 11, 11).add((Component)this.registerLocal).add(11, 11, 11).add((Component)this.registerRemote).add(11, 11, 11).add((Component)this.createPersonal).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.profileSelectorLabel, -2, 25, -2).add((Component)this.profileSelector, -2, -1, -2))).add((Component)this.openDirectoryCooser)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.openDirectoryCooser, this.platformField}, 2);
        this.platformFieldLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"ACSD_InstallRoot"));
        this.platformField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_platformField"));
        this.openDirectoryCooser.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_openDirectoryChooser"));
        this.registerDefault.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_registerDefault"));
        this.instanceSelector.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"Domain_A11Y_DESC"));
        this.registerLocal.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_registerLocal"));
        this.registerRemote.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_registerRemote"));
        this.createPersonal.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_createPersonal"));
        this.instanceSelectorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"Domain_A11Y_DESC"));
        this.profileSelectorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualPlatformPanel.class, (String)"ACSD_LBL_Profile"));
    }

    private void profileSelectorActionPerformed(ActionEvent actionEvent) {
        this.fireChangeEvent();
    }

    private void instanceSelectorActionPerformed(ActionEvent actionEvent) {
        this.fireChangeEvent();
    }

    private void createPersonalItemStateChanged(ItemEvent itemEvent) {
        this.setSelectedType(AddDomainWizardIterator.PERSONAL, itemEvent);
    }

    private void registerRemoteItemStateChanged(ItemEvent itemEvent) {
        this.setSelectedType(AddDomainWizardIterator.REMOTE, itemEvent);
    }

    private void registerLocalItemStateChanged(ItemEvent itemEvent) {
        this.setSelectedType(AddDomainWizardIterator.LOCAL, itemEvent);
    }

    private void registerDefaultItemStateChanged(ItemEvent itemEvent) {
        this.setSelectedType(AddDomainWizardIterator.DEFAULT, itemEvent);
    }

    private void openDirectoryCooserActionPerformed(ActionEvent actionEvent) {
        String string = this.browseInstallLocation();
        if (null != string && string.length() >= 1) {
            this.platformField.setText(string);
        }
    }

    ComboBoxModel getDomainsListModel() {
        return this.instanceSelector.getModel();
    }

    ComboBoxModel getProfilesListModel() {
        return this.profileSelector.getModel();
    }

    private void updateDomainList() {
        File file = new File(this.platformField.getText());
        Object[] objectArray = AddInstanceVisualPlatformPanel.getDomainList(Util.getRegisterableDefaultDomains(file), file);
        this.setDomainsList(objectArray, true);
    }

    private void updateProfileList() {
        File file = new File(this.platformField.getText());
        if (ServerLocationManager.getAppServerPlatformVersion((File)file) < 910) {
            this.setProfilesList(SHORT_PROFILES_LIST, true);
        } else {
            this.setProfilesList(LONG_PROFILES_LIST, true);
        }
    }

    private static Object[] getDomainList(File[] fileArray, File file) {
        return AddInstanceVisualPlatformPanel.getServerList(fileArray, file);
    }

    private static Object[] getServerList(File[] fileArray, File file) {
        ArrayList<DomainListEntry> arrayList = new ArrayList<DomainListEntry>();
        for (int i = 0; file != null && i < fileArray.length; ++i) {
            String string = Util.getHostPort(fileArray[i], file);
            if (string == null) continue;
            arrayList.add(new DomainListEntry(string, fileArray[i], file));
        }
        Object[] objectArray = arrayList.toArray();
        return objectArray;
    }

    private static class PlatformInstChooser
    extends JFileChooser {
        private PlatformInstChooser() {
        }

        @Override
        public void approveSelection() {
            File file = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (ServerLocationManager.isGoodAppServerLocation((File)file)) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(file);
            }
        }
    }
}

