/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class WebSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean dirty;
    private volatile Map<String, SourceGroup[]> cachedGroups = new HashMap<String, SourceGroup[]>();
    private long eventId;
    SourceGroupModifierImplementation sgmi;

    WebSources(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testRoots) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = testRoots;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String type) {
        SourceGroup[] _cachedGroups = this.cachedGroups.get(type);
        if (_cachedGroups != null) {
            return _cachedGroups;
        }
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                long myEventId;
                Sources _delegate;
                WebSources webSources = WebSources.this;
                synchronized (webSources) {
                    if (WebSources.this.dirty) {
                        WebSources.this.delegate.removeChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.delegate = WebSources.this.initSources();
                        WebSources.this.delegate.addChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.dirty = false;
                    }
                    _delegate = WebSources.this.delegate;
                    myEventId = ++WebSources.this.eventId;
                }
                SourceGroup[] groups = _delegate.getSourceGroups(type);
                WebSources webSources2 = WebSources.this;
                synchronized (webSources2) {
                    if (myEventId == WebSources.this.eventId) {
                        WebSources.this.cachedGroups.put(type, groups);
                    }
                }
                return groups;
            }
        });
    }

    SourceGroupModifierImplementation getSourceGroupModifierImplementation() {
        return this.sgmi;
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots, "main");
        this.register(sourcesHelper, this.testRoots, "test");
        String webModuleLabel = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebModule");
        String webPagesLabel = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_DocBase");
        String webInfLabel = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebInf");
        String includes = "${includes}";
        String excludes = "${excludes}";
        sourcesHelper.sourceRoot("${source.root}").displayName(webModuleLabel).add();
        sourcesHelper.sourceRoot("${web.docbase.dir}").includes(includes).excludes(excludes).displayName(webPagesLabel).add().type("doc_root").add();
        sourcesHelper.sourceRoot("${webinf.dir}").type("web_inf").displayName(webInfLabel).add();
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0, false);
        this.sgmi = sourcesHelper.createSourceGroupModifierImplementation();
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots roots, String hint) {
        String[] propNames = roots.getRootProperties();
        String[] rootNames = roots.getRootNames();
        for (int i = 0; i < propNames.length; ++i) {
            String prop = propNames[i];
            String displayName = roots.getRootDisplayName(rootNames[i], prop);
            String loc = "${" + prop + "}";
            String includes = "${includes}";
            String excludes = "${excludes}";
            sourcesHelper.sourceRoot(loc).includes(includes).excludes(excludes).hint(hint).displayName(displayName).add().type("java").add();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        WebSources webSources = this;
        synchronized (webSources) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        this.changeSupport.fireChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(propName) || "build.dir".equals(propName) || "dist.dir".equals(propName)) {
            this.fireChange();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireChange();
    }
}

