/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.util.Exceptions;

public final class RepositoryQueries {
    public static Set<String> getGroups(RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.getGroups(rps));
        }
        return toRet;
    }

    public static Set<String> filterGroupIds(String prefix, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.filterGroupIds(prefix, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> getRecords(String groupId, String artifactId, String version, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.getRecords(groupId, artifactId, version, rps));
        }
        return toRet;
    }

    public static Set<String> getArtifacts(String groupId, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.getArtifacts(groupId, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> getVersions(String groupId, String artifactId, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.getVersions(groupId, artifactId, rps));
        }
        return toRet;
    }

    public static List<NBGroupInfo> findDependencyUsage(String groupId, String artifactId, String version, RepositoryInfo ... repos) {
        HashMap<String, NBGroupInfo> groupMap = new HashMap<String, NBGroupInfo>();
        HashMap<String, NBArtifactInfo> artifactMap = new HashMap<String, NBArtifactInfo>();
        ArrayList<NBGroupInfo> groupInfos = new ArrayList<NBGroupInfo>();
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        for (List<RepositoryInfo> rps : all) {
            DependencyInfoQueries dq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (dq = (DependencyInfoQueries)impl.getCapabilityLookup().lookup(DependencyInfoQueries.class)) == null) continue;
            RepositoryQueries.convertToNBGroupInfo(dq.findDependencyUsage(groupId, artifactId, version, rps), groupMap, artifactMap, groupInfos);
        }
        return groupInfos;
    }

    private static void convertToNBGroupInfo(Collection<NBVersionInfo> artifactInfos, Map<String, NBGroupInfo> groupMap, Map<String, NBArtifactInfo> artifactMap, List<NBGroupInfo> groupInfos) {
        for (NBVersionInfo ai : artifactInfos) {
            NBArtifactInfo ua;
            String groupId = ai.getGroupId();
            String artId = ai.getArtifactId();
            NBGroupInfo ug = groupMap.get(groupId);
            if (ug == null) {
                ug = new NBGroupInfo(groupId);
                groupInfos.add(ug);
                groupMap.put(groupId, ug);
            }
            if ((ua = artifactMap.get(artId)) == null) {
                ua = new NBArtifactInfo(artId);
                ug.addArtifactInfo(ua);
                artifactMap.put(artId, ua);
            }
            ua.addVersionInfo(ai);
        }
    }

    public static List<NBVersionInfo> findByMD5(File file, RepositoryInfo ... repos) {
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        try {
            String calculateChecksum = RepositoryUtil.calculateMD5Checksum(file);
            return RepositoryQueries.findByMD5(calculateChecksum, repos);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return toRet;
        }
    }

    public static List<NBVersionInfo> findByMD5(String md5, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            ChecksumQueries chq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (chq = (ChecksumQueries)impl.getCapabilityLookup().lookup(ChecksumQueries.class)) == null) continue;
            toRet.addAll(chq.findByMD5(md5, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> findBySHA1(File file, RepositoryInfo ... repos) {
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        try {
            String calculateChecksum = RepositoryUtil.calculateSHA1Checksum(file);
            return RepositoryQueries.findBySHA1(calculateChecksum, repos);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return toRet;
        }
    }

    public static List<NBVersionInfo> findBySHA1(String sha1, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            ChecksumQueries chq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (chq = (ChecksumQueries)impl.getCapabilityLookup().lookup(ChecksumQueries.class)) == null) continue;
            toRet.addAll(chq.findBySHA1(sha1, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> findVersionsByClass(String className, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            ClassesQuery chq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (chq = (ClassesQuery)impl.getCapabilityLookup().lookup(ClassesQuery.class)) == null) continue;
            toRet.addAll(chq.findVersionsByClass(className, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> findArchetypes(RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            ArchetypeQueries aq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (aq = (ArchetypeQueries)impl.getCapabilityLookup().lookup(ArchetypeQueries.class)) == null) continue;
            toRet.addAll(aq.findArchetypes(rps));
        }
        return toRet;
    }

    public static Set<String> filterPluginArtifactIds(String groupId, String prefix, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.filterPluginArtifactIds(groupId, prefix, rps));
        }
        return toRet;
    }

    public static Set<String> filterPluginGroupIds(String prefix, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.filterPluginGroupIds(prefix, rps));
        }
        return toRet;
    }

    public static List<NBVersionInfo> find(List<QueryField> fields, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> rps : all) {
            GenericFindQuery gfq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (gfq = (GenericFindQuery)impl.getCapabilityLookup().lookup(GenericFindQuery.class)) == null) continue;
            toRet.addAll(gfq.find(fields, rps));
        }
        return toRet;
    }

    public static List<RepositoryInfo> getLoadedContexts() {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(null);
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        for (List<RepositoryInfo> rps : all) {
            ContextLoadedQuery clq;
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null || (clq = (ContextLoadedQuery)impl.getCapabilityLookup().lookup(ContextLoadedQuery.class)) == null) continue;
            toRet.addAll(clq.getLoaded(rps));
        }
        return toRet;
    }

    public static Set<String> filterArtifactIdForGroupId(String groupId, String prefix, RepositoryInfo ... repos) {
        Collection<List<RepositoryInfo>> all = RepositoryQueries.splitReposByType(repos);
        TreeSet<String> toRet = new TreeSet<String>();
        for (List<RepositoryInfo> rps : all) {
            RepositoryIndexerImplementation impl = RepositoryIndexer.findImplementation(rps.get(0));
            if (impl == null) continue;
            BaseQueries bq = (BaseQueries)impl.getCapabilityLookup().lookup(BaseQueries.class);
            assert (bq != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + impl.getType() + " : " + impl.getClass();
            toRet.addAll(bq.filterArtifactIdForGroupId(groupId, prefix, rps));
        }
        return toRet;
    }

    private static Collection<List<RepositoryInfo>> splitReposByType(RepositoryInfo[] repos) {
        if (repos == null || repos.length == 0) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos().toArray(new RepositoryInfo[0]);
        }
        HashMap<String, ArrayList<RepositoryInfo>> toRet = new HashMap<String, ArrayList<RepositoryInfo>>();
        for (RepositoryInfo info : repos) {
            String type = info.getType();
            ArrayList<RepositoryInfo> list = (ArrayList<RepositoryInfo>)toRet.get(type);
            if (list == null) {
                list = new ArrayList<RepositoryInfo>();
                toRet.put(type, list);
            }
            list.add(info);
        }
        return toRet.values();
    }
}

