/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class Deploy
extends Task
implements Deployment.Logger {
    private boolean debugmode = false;
    private boolean forceRedeploy = false;
    private String clientModuleUri;
    private String clientUrlPart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader originalLoader = null;
        try {
            ClassLoader current = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (current == null) {
                current = ClassLoader.getSystemClassLoader();
            }
            if (current != null) {
                originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(current);
            }
            J2eeModuleProvider jmp = null;
            try {
                FileObject fob = FileUtil.toFileObject((File)this.getProject().getBaseDir());
                fob.refresh();
                jmp = (J2eeModuleProvider)FileOwnerQuery.getOwner((FileObject)fob).getLookup().lookup(J2eeModuleProvider.class);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            try {
                ServerDebugInfo sdi;
                String clientUrl = Deployment.getDefault().deploy(jmp, this.debugmode ? Deployment.Mode.DEBUG : Deployment.Mode.RUN, this.clientModuleUri, this.clientUrlPart, this.forceRedeploy, (Deployment.Logger)this);
                if (clientUrl != null) {
                    this.getProject().setProperty("client.url", clientUrl);
                }
                if ((sdi = jmp.getServerDebugInfo()) != null) {
                    String h = sdi.getHost();
                    String transport = sdi.getTransport();
                    String address = "";
                    address = transport.equals("dt_shmem") ? sdi.getShmemName() : Integer.toString(sdi.getPort());
                    this.getProject().setProperty("name", jmp.getDeploymentName());
                    this.getProject().setProperty("jpda.transport", transport);
                    this.getProject().setProperty("jpda.host", h);
                    this.getProject().setProperty("jpda.address", address);
                }
            }
            catch (Deployment.DeploymentException ex) {
                if (null != ex.getCause()) {
                    throw new BuildException(ex.getMessage(), (Throwable)ex);
                }
                throw new BuildException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
        catch (Throwable throwable) {
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
            throw throwable;
        }
    }

    public boolean getDebugmode() {
        return this.debugmode;
    }

    public void setDebugmode(boolean debugmode) {
        this.debugmode = debugmode;
    }

    public boolean getForceRedeploy() {
        return this.forceRedeploy;
    }

    public void setForceRedeploy(boolean forceRedeploy) {
        this.forceRedeploy = forceRedeploy;
    }

    public String getClientUrlPart() {
        return this.clientUrlPart;
    }

    public void setClientUrlPart(String clientUrlPart) {
        this.clientUrlPart = clientUrlPart;
    }

    public String getClientModuleUri() {
        return this.clientModuleUri;
    }

    public void setClientModuleUri(String clientModuleUri) {
        this.clientModuleUri = clientModuleUri;
    }
}

