/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FileEntryNode;
import org.netbeans.modules.properties.LangRenameAction;
import org.netbeans.modules.properties.LocaleNodeCustomizer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.NewAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public final class PropertiesLocaleNode
extends FileEntryNode
implements CookieSet.Factory,
Node.Cookie {
    private static final String LOCALE_ICON_BASE = "org/netbeans/modules/properties/propertiesLocale.gif";
    private FileStatusListener fsStatusListener;

    public PropertiesLocaleNode(PropertiesFileEntry fe) {
        super(fe, fe.getChildren());
        this.setDisplayName(Util.getLocaleLabel((MultiDataObject.Entry)fe));
        this.setIconBaseWithExtension(LOCALE_ICON_BASE);
        this.setShortDescription(this.messageToolTip());
        CookieSet cookieSet = fe.getCookieSet();
        cookieSet.add(PropertiesOpen.class, (CookieSet.Factory)this);
        cookieSet.add((Node.Cookie)fe);
        cookieSet.add((Node.Cookie)fe.getDataObject());
        cookieSet.add((Node.Cookie)this);
        this.fsStatusListener = new FSListener();
        try {
            FileSystem fs = fe.getFile().getFileSystem();
            fs.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fs));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)((PropertiesDataObject)this.getFileEntry().getDataObject()).getOpenSupport());
        }
        return null;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(EditAction.class), SystemAction.get(OpenAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(LangRenameAction.class), null, SystemAction.get(NewAction.class), SystemAction.get(SaveAsTemplateAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    @Override
    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    public String getName() {
        String localeName = "invalid";
        if (this.getFileEntry().getFile().isValid() && !this.getFileEntry().getFile().isVirtual() && (localeName = Util.getLocaleSuffix((MultiDataObject.Entry)this.getFileEntry())).length() > 0 && localeName.charAt(0) == '_') {
            localeName = localeName.substring(1);
        }
        return localeName;
    }

    @Override
    public void setName(String name) {
        if (!name.startsWith(this.getFileEntry().getDataObject().getPrimaryFile().getName())) {
            name = Util.assembleName(this.getFileEntry().getDataObject().getPrimaryFile().getName(), name);
        }
        if (name.equals(super.getName())) {
            return;
        }
        super.setName(name);
        this.setDisplayName(Util.getLocaleLabel((MultiDataObject.Entry)this.getFileEntry()));
        this.setShortDescription(this.messageToolTip());
    }

    private String messageToolTip() {
        FileObject fo = this.getFileEntry().getFile();
        return FileUtil.getFileDisplayName((FileObject)fo);
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status stat = this.getFileEntry().getFile().getFileSystem().getStatus();
            if (stat instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus hstat = (FileSystem.HtmlStatus)stat;
                String result = hstat.annotateNameHtml(super.getDisplayName(), Collections.singleton(this.getFileEntry().getFile()));
                if (!super.getDisplayName().equals(result)) {
                    return result;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return super.getHtmlDisplayName();
    }

    public boolean canRename() {
        return this.getFileEntry().isDeleteAllowed();
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewPropertyType((PropertiesFileEntry)this.getFileEntry())};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new LocaleNodeCustomizer((PropertiesFileEntry)this.getFileEntry());
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        Node n = NodeTransfer.node((Transferable)t, (int)6);
        if (n != null && n.canDestroy()) {
            Element.ItemElem item = (Element.ItemElem)n.getCookie(Element.ItemElem.class);
            if (item != null) {
                Node n2 = this.getChildren().findChild(item.getKey());
                if (n == n2) {
                    return;
                }
                s.add(new KeyPasteType(item, n, 1));
                s.add(new KeyPasteType(item, n, 2));
                return;
            }
        } else {
            Element.ItemElem item = (Element.ItemElem)NodeTransfer.cookie((Transferable)t, (int)1, Element.ItemElem.class);
            if (item != null) {
                s.add(new KeyPasteType(item, null, 1));
                s.add(new KeyPasteType(item, null, 2));
                return;
            }
        }
    }

    private class KeyPasteType
    extends PasteType {
        private Element.ItemElem item;
        private Node node;
        int mode;
        public static final int MODE_PASTE_WITH_VALUE = 1;
        public static final int MODE_PASTE_WITHOUT_VALUE = 2;

        public KeyPasteType(Element.ItemElem item, Node node, int mode) {
            this.item = item;
            this.node = node;
            this.mode = mode;
        }

        public String getName() {
            String pasteKey = this.mode == 1 ? "CTL_PasteKeyValue" : "CTL_PasteKeyNoValue";
            return NbBundle.getBundle(PropertiesLocaleNode.class).getString(pasteKey);
        }

        public Transferable paste() throws IOException {
            PropertiesStructure ps = ((PropertiesFileEntry)PropertiesLocaleNode.this.getFileEntry()).getHandler().getStructure();
            String value = this.mode == 1 ? this.item.getValue() : "";
            if (ps != null) {
                Element.ItemElem newItem = ps.getItem(this.item.getKey());
                if (newItem == null) {
                    ps.addItem(this.item.getKey(), value, this.item.getComment());
                } else {
                    newItem.setValue(value);
                    newItem.setComment(this.item.getComment());
                }
                if (this.node != null) {
                    this.node.destroy();
                }
            }
            return null;
        }
    }

    static class NewPropertyType
    extends NewType {
        private PropertiesFileEntry pfEntry;

        NewPropertyType(PropertiesFileEntry pfe) {
            this.pfEntry = pfe;
        }

        public String getName() {
            return NbBundle.getBundle(PropertiesLocaleNode.class).getString("LAB_NewPropertyAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.adding");
        }

        public void create() throws IOException {
            PropertyPanel panel = new PropertyPanel();
            Object selectedOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, NbBundle.getMessage(BundleEditPanel.class, (String)"CTL_NewPropertyTitle")));
            if (selectedOption != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String key = panel.getKey();
            String value = panel.getValue();
            String comment = panel.getComment();
            if (!this.pfEntry.getHandler().getStructure().addItem(key, value, comment)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PropertiesLocaleNode.class, (String)"MSG_KeyExists", (Object)key, (Object)Util.getLocaleLabel((MultiDataObject.Entry)this.pfEntry)), 0));
            }
        }
    }

    private class FSListener
    implements FileStatusListener,
    Runnable {
        private FSListener() {
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (ev.isNameChange() && ev.hasChanged(PropertiesLocaleNode.this.getFileEntry().getFile())) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            PropertiesLocaleNode.this.fireDisplayNameChange(null, null);
        }
    }
}

