/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

abstract class AbstractCreateAnnotationHint
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;
    private ElementHandle<Element> elemHandle;
    private String annotationClass;

    public AbstractCreateAnnotationHint(FileObject fileObject, ElementHandle<TypeElement> elementHandle, ElementHandle<Element> elementHandle2, String string) {
        this.classHandle = elementHandle;
        this.fileObject = fileObject;
        this.annotationClass = string;
        this.elemHandle = elementHandle2;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)AbstractCreateAnnotationHint.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (typeElement != null) {
                    GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    AnnotationTree annotationTree = generationUtils.createAnnotation(AbstractCreateAnnotationHint.this.annotationClass);
                    Tree tree = workingCopy.getTrees().getTree(AbstractCreateAnnotationHint.this.elemHandle.resolve((CompilationInfo)workingCopy));
                    Tree tree2 = null;
                    switch (tree.getKind()) {
                        case CLASS: {
                            tree2 = generationUtils.addAnnotation((ClassTree)tree, annotationTree);
                            break;
                        }
                        case METHOD: {
                            tree2 = generationUtils.addAnnotation((MethodTree)tree, annotationTree);
                            break;
                        }
                        case VARIABLE: {
                            tree2 = generationUtils.addAnnotation((VariableTree)tree, annotationTree);
                        }
                    }
                    if (tree2 != null) {
                        workingCopy.rewrite(tree, tree2);
                    } else {
                        throw new IllegalStateException("Unsupported element type");
                    }
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }
}

