/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc10;

import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import jmunit.framework.cldc10.GuiListener;
import jmunit.framework.cldc10.JMUnit;

public class ExceptionList
extends List {
    private GuiListener listener;
    Vector errors;
    Vector failures;

    public ExceptionList(GuiListener guiListener) {
        super(JMUnit.getVersion(), 3);
        this.listener = guiListener;
        this.errors = new Vector();
        this.failures = new Vector();
    }

    public void clearAll() {
        while (this.size() != 0) {
            this.delete(0);
        }
        this.errors.removeAllElements();
        this.failures.removeAllElements();
    }

    private void append(String string) {
        super.append(string, null);
    }

    private void displayExceptions(String string, Vector vector) {
        if (vector.size() == 0) {
            return;
        }
        String string2 = "There was 1" + string + ":";
        if (vector.size() != 1) {
            string2 = "There were " + vector.size() + string + "s:";
        }
        this.append(string2);
        for (int i = 1; i <= vector.size(); ++i) {
            this.append("" + i + ")");
            String[] stringArray = (String[])vector.elementAt(i - 1);
            this.append(stringArray[0]);
            this.append(stringArray[1]);
        }
    }

    public void displayResults(MIDlet mIDlet) {
        this.append("Test Results:");
        this.append("Passed: " + this.listener.getNumberSuccessful());
        this.append("Failures: " + this.listener.getNumberFailures());
        this.append("Errors: " + this.listener.getNumberErrors());
        this.displayExceptions(" error", this.errors);
        this.displayExceptions(" failure", this.failures);
        this.append("");
        this.append("Display based on J2MEUnit.");
        Display.getDisplay((MIDlet)mIDlet).setCurrent((Displayable)this);
    }

    private void addFailureError(String string, Throwable throwable, Vector vector) {
        String string2 = throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            string2 = throwable.getMessage();
        }
        vector.addElement(new String[]{string, string2});
    }

    public void addError(String string, Throwable throwable) {
        this.addFailureError(string, throwable, this.errors);
    }

    public void addFailure(String string, Throwable throwable) {
        this.addFailureError(string, throwable, this.failures);
    }
}

