/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.TldLibrary;

public abstract class FaceletsLibrary {
    protected FaceletsLibrarySupport support;
    private String namespace;

    public FaceletsLibrary(FaceletsLibrarySupport faceletsLibrarySupport, String string) {
        this.namespace = string;
        this.support = faceletsLibrarySupport;
    }

    public abstract Collection<NamedComponent> getComponents();

    public abstract LibraryDescriptor getLibraryDescriptor();

    public LibraryDescriptor.Tag getTag(String string) {
        FaceletsLibraryDescriptor faceletsLibraryDescriptor = this.support.getJsfSupport().getFaceletsLibraryDescriptor(this.getNamespace());
        LibraryDescriptor.Tag tag = this.getTag(faceletsLibraryDescriptor, string);
        TldLibrary tldLibrary = this.support.getJsfSupport().getTldLibrary(this.getNamespace());
        LibraryDescriptor.Tag tag2 = this.getTag(tldLibrary, string);
        LibraryDescriptor.Tag tag3 = this.getTag(this.getLibraryDescriptor(), string);
        if (tag == null) {
            return tag2 != null ? new ProxyTag(tag2, tag3) : tag3;
        }
        return new ProxyTag(new ProxyTag(tag, tag2), tag3);
    }

    private LibraryDescriptor.Tag getTag(LibraryDescriptor libraryDescriptor, String string) {
        if (libraryDescriptor == null) {
            return null;
        }
        return libraryDescriptor.getTags().get(string);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public NamedComponent getComponent(String string) {
        for (NamedComponent namedComponent : this.getComponents()) {
            if (!namedComponent.getName().equals(string)) continue;
            return namedComponent;
        }
        return null;
    }

    public String getDefaultPrefix() {
        String string;
        String string2 = string = this.getLibraryDescriptor() != null ? this.getLibraryDescriptor().getDefaultPrefix() : null;
        if (string == null && this.namespace != null) {
            TldLibrary tldLibrary = this.support.getJsfSupport().getTldLibrary(this.namespace);
            return tldLibrary != null ? tldLibrary.getDefaultPrefix() : null;
        }
        return string;
    }

    public String getDisplayName() {
        return this.getLibraryDescriptor() != null ? this.getLibraryDescriptor().getDisplayName() : this.getNamespace();
    }

    public String toString() {
        return "FaceletsLibrary(namespace=" + this.getNamespace() + ", default prefix= " + this.getDefaultPrefix() + ", tld library= " + this.getLibraryDescriptor();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FaceletsLibrary)) {
            return false;
        }
        FaceletsLibrary faceletsLibrary = (FaceletsLibrary)object;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return !(this.getNamespace() == null ? faceletsLibrary.getNamespace() != null : !this.getNamespace().equals(faceletsLibrary.getNamespace()));
    }

    public int hashCode() {
        int n = 7;
        n = 79 * n + (this.namespace != null ? this.namespace.hashCode() : 0);
        return n;
    }

    private static final class ProxyTag
    implements LibraryDescriptor.Tag {
        private LibraryDescriptor.Tag tag1;
        private LibraryDescriptor.Tag tag2;

        public ProxyTag(LibraryDescriptor.Tag tag, LibraryDescriptor.Tag tag2) {
            this.tag1 = tag;
            this.tag2 = tag2;
            assert (tag != null);
        }

        @Override
        public String getName() {
            return this.tag1.getName() == null && this.tag2 != null ? this.tag2.getName() : this.tag1.getName();
        }

        @Override
        public String getDescription() {
            return this.tag1.getDescription() == null && this.tag2 != null ? this.tag2.getDescription() : this.tag1.getDescription();
        }

        @Override
        public boolean hasNonGenenericAttributes() {
            return !this.tag1.hasNonGenenericAttributes() && this.tag2 != null ? this.tag2.hasNonGenenericAttributes() : this.tag1.hasNonGenenericAttributes();
        }

        @Override
        public Collection<LibraryDescriptor.Attribute> getAttributes() {
            return !this.tag1.hasNonGenenericAttributes() && this.tag2 != null ? this.tag2.getAttributes() : this.tag1.getAttributes();
        }

        @Override
        public LibraryDescriptor.Attribute getAttribute(String string) {
            return this.tag1.getAttribute(string) == null && this.tag2 != null ? this.tag2.getAttribute(string) : this.tag1.getAttribute(string);
        }
    }

    public class Function
    extends NamedComponent {
        protected Method function;

        protected Function(String string, Method method) {
            super(string);
            this.function = method;
        }

        public Method getFunction() {
            return this.function;
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "function"}, {"function name", this.getFunction() == null ? "N/A" : this.getFunction().toGenericString()}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class UserTag
    extends NamedComponent {
        protected URL source;

        protected UserTag(String string, URL uRL) {
            super(string);
            this.source = uRL;
        }

        public URL getUrl() {
            return this.source;
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "user tag"}, {"URL", this.getUrl() == null ? "N/A" : this.getUrl().toExternalForm()}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class Component
    extends NamedComponent {
        protected String componentType;
        protected String rendererType;
        protected Class handlerClass;

        protected Component(String string, String string2, String string3, Class clazz) {
            super(string);
            this.componentType = string2;
            this.rendererType = string3;
            this.handlerClass = clazz;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public Class getHandlerClass() {
            return this.handlerClass;
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "component"}, {"component type", this.getComponentType() == null ? "N/A" : this.getComponentType()}, {"renderer type", this.getRendererType() == null ? "N/A" : this.getRendererType()}, {"handler class", this.getHandlerClass() == null ? "N/A" : this.getHandlerClass().getName()}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class TagHandler
    extends NamedComponent {
        protected Class type;

        protected TagHandler(String string, Class clazz) {
            super(string);
            this.type = clazz;
        }

        public Class getType() {
            return this.type;
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "tag handler"}, {"class type", this.getType() == null ? "N/A" : this.getType().getName()}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class Behavior
    extends BaseComponent {
        protected Behavior(String string, String string2, Class clazz) {
            super(string, string2, clazz);
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "behavior"}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class Validator
    extends BaseComponent {
        protected Validator(String string, String string2, Class clazz) {
            super(string, string2, clazz);
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "validator"}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class Converter
    extends BaseComponent {
        protected Converter(String string, String string2, Class clazz) {
            super(string, string2, clazz);
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"type", "converter"}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class BaseComponent
    extends NamedComponent {
        protected String id;
        protected Class handlerClass;

        private BaseComponent(String string, String string2, Class clazz) {
            super(string);
            this.id = string2;
            this.handlerClass = clazz;
        }

        public Class getHandlerClass() {
            return this.handlerClass;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String[][] getDescription() {
            String[][] stringArray = new String[][]{{"id", this.getId()}, {"handler class", this.getHandlerClass() == null ? "N/A" : this.getHandlerClass().getName()}};
            return this.merge(super.getDescription(), stringArray);
        }
    }

    public class NamedComponent {
        protected String name;

        protected NamedComponent(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public LibraryDescriptor.Tag getTag() {
            return FaceletsLibrary.this.getTag(this.getName());
        }

        public FaceletsLibrary getLibrary() {
            return FaceletsLibrary.this;
        }

        public String[][] getDescription() {
            return new String[][]{{"name", this.getName()}};
        }

        protected String[][] merge(String[][] stringArray, String[][] stringArray2) {
            String[][] stringArray3 = new String[stringArray.length + stringArray2.length][];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }
    }
}

