/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.JrePicker;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class VmCustomizer
extends JPanel {
    GlassfishModule gm;
    JrePicker picker = null;
    private JTextField addressValue;
    private ButtonGroup buttonGroup1;
    private JPanel debugSettingsPanel;
    private JTextField javaExecutableField;
    private JLabel javaInstallLabel;
    private JButton openDirectoryBrowser;
    private JPanel pickerPanel;
    private JCheckBox useIDEProxyInfo;
    private JRadioButton useSharedMemRB;
    private JRadioButton useSocketRB;
    private JCheckBox useUserDefinedAddress;

    public VmCustomizer(GlassfishModule commonSupport) {
        this.gm = commonSupport;
        this.initComponents();
    }

    private void initFields() {
        if (null != this.picker) {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.javaExecutableField.setText(this.gm.getInstanceProperties().get("java.platform"));
        String address = this.gm.getInstanceProperties().get("debugPort");
        if (null == address || "".equals(address)) {
            this.useUserDefinedAddress.setSelected(false);
            this.addressValue.setEditable(false);
        } else {
            this.useUserDefinedAddress.setSelected(true);
            this.addressValue.setEditable(true);
            this.addressValue.setText(address);
        }
        if (!"/".equals(File.separator)) {
            this.useSharedMemRB.setSelected("true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
            this.useSocketRB.setSelected(!"true".equals(this.gm.getInstanceProperties().get("use.shared.mem")));
        } else {
            this.useSharedMemRB.setEnabled(false);
            this.useSharedMemRB.setSelected(false);
            this.useSocketRB.setSelected(true);
        }
        this.useIDEProxyInfo.setSelected("true".equals(this.gm.getInstanceProperties().get("useIDEProxyOn")));
        boolean isLocalDomain = this.gm.getInstanceProperties().get("domainsfolder") != null;
        this.javaExecutableField.setEnabled(isLocalDomain);
        this.useIDEProxyInfo.setEnabled(isLocalDomain);
        this.useSharedMemRB.setEnabled(isLocalDomain);
    }

    private void persistFields() {
        if (null == this.picker) {
            File dir;
            File dbdir;
            File f;
            this.gm.setEnvironmentProperty("java.platform", this.javaExecutableField.getText(), true);
            RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
            if (null != db && (f = new File(this.javaExecutableField.getText().trim())).exists() && f.canRead() && (dbdir = new File(dir = f.getParentFile().getParentFile(), "db")).exists() && dbdir.isDirectory() && dbdir.canRead()) {
                db.initialize(dbdir.getAbsolutePath());
            }
        } else {
            throw new UnsupportedOperationException("not implemented yet");
        }
        this.gm.setEnvironmentProperty("use.shared.mem", Boolean.toString(this.useSharedMemRB.isSelected()), true);
        this.gm.setEnvironmentProperty("useIDEProxyOn", Boolean.toString(this.useIDEProxyInfo.isSelected()), true);
        this.gm.setEnvironmentProperty("debugPort", this.addressValue.getText().trim(), true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.debugSettingsPanel = new JPanel();
        this.useSocketRB = new JRadioButton();
        this.useSharedMemRB = new JRadioButton();
        this.useUserDefinedAddress = new JCheckBox();
        this.addressValue = new JTextField();
        this.pickerPanel = new JPanel();
        this.javaInstallLabel = new JLabel();
        this.openDirectoryBrowser = new JButton();
        this.javaExecutableField = new JTextField();
        this.useIDEProxyInfo = new JCheckBox();
        this.setName(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.name"));
        this.debugSettingsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.debugSettingsPanel.border.title.text")));
        this.buttonGroup1.add(this.useSocketRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSocketRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSocketRB.text"));
        this.buttonGroup1.add(this.useSharedMemRB);
        Mnemonics.setLocalizedText((AbstractButton)this.useSharedMemRB, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useSharedMemRB.text"));
        this.useUserDefinedAddress.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useUserDefinedAddress.text", (Object[])new Object[0]));
        this.useUserDefinedAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VmCustomizer.this.toggleAddressUsage(evt);
            }
        });
        this.addressValue.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.addressValue.text", (Object[])new Object[0]));
        GroupLayout debugSettingsPanelLayout = new GroupLayout((Container)this.debugSettingsPanel);
        this.debugSettingsPanel.setLayout((LayoutManager)debugSettingsPanelLayout);
        debugSettingsPanelLayout.setHorizontalGroup((GroupLayout.Group)debugSettingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)debugSettingsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)debugSettingsPanelLayout.createParallelGroup(1).add((Component)this.useSharedMemRB).add((Component)this.useSocketRB).add((GroupLayout.Group)debugSettingsPanelLayout.createSequentialGroup().add((Component)this.useUserDefinedAddress).addPreferredGap(0).add((Component)this.addressValue, -1, 404, Short.MAX_VALUE))).addContainerGap()));
        debugSettingsPanelLayout.setVerticalGroup((GroupLayout.Group)debugSettingsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)debugSettingsPanelLayout.createSequentialGroup().add((Component)this.useSharedMemRB).addPreferredGap(0).add((Component)this.useSocketRB).add(8, 8, 8).add((GroupLayout.Group)debugSettingsPanelLayout.createParallelGroup(3).add((Component)this.useUserDefinedAddress).add((Component)this.addressValue, -2, -1, -2)).addContainerGap()));
        this.javaInstallLabel.setLabelFor(this.javaExecutableField);
        Mnemonics.setLocalizedText((JLabel)this.javaInstallLabel, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaInstallLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.openDirectoryBrowser, (String)NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.openDirectoryBrowser.text"));
        this.openDirectoryBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VmCustomizer.this.openInstallChooser(evt);
            }
        });
        this.javaExecutableField.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.javaExecutableField.text"));
        GroupLayout pickerPanelLayout = new GroupLayout((Container)this.pickerPanel);
        this.pickerPanel.setLayout((LayoutManager)pickerPanelLayout);
        pickerPanelLayout.setHorizontalGroup((GroupLayout.Group)pickerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)pickerPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.javaInstallLabel).addPreferredGap(0).add((Component)this.javaExecutableField, -2, 308, -2).addPreferredGap(0).add((Component)this.openDirectoryBrowser).addContainerGap()));
        pickerPanelLayout.setVerticalGroup((GroupLayout.Group)pickerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)pickerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pickerPanelLayout.createParallelGroup(3).add((Component)this.javaInstallLabel).add((Component)this.javaExecutableField, -2, -1, -2).add((Component)this.openDirectoryBrowser)).addContainerGap()));
        this.useIDEProxyInfo.setText(NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.useIDEProxyInfo.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pickerPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.useIDEProxyInfo)).add((Component)this.debugSettingsPanel, -2, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pickerPanel, -2, -1, -2).add(9, 9, 9).add((Component)this.debugSettingsPanel, -1, 113, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.useIDEProxyInfo).addContainerGap()));
    }

    private void openInstallChooser(ActionEvent evt) {
        JFileChooser f = new JFileChooser();
        f.setSelectedFile(new File(this.javaExecutableField.getText()));
        f.setFileSelectionMode(0);
        f.setMultiSelectionEnabled(false);
        final String TESTNAME = File.separatorChar == '/' ? "java" : "java.exe";
        f.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                if (arg0.isDirectory()) {
                    return true;
                }
                if (arg0.getName().equalsIgnoreCase(TESTNAME)) {
                    if (VmCustomizer.this.gm.getInstanceProvider().equals(GlassfishInstanceProvider.getEe6())) {
                        return Util.appearsToBeJdk6OrBetter(arg0);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(VmCustomizer.class, (String)"VmCustomizer.filechooser.description");
            }
        });
        int retVal = f.showOpenDialog(this);
        if (retVal == 0) {
            this.javaExecutableField.setText(f.getSelectedFile().getAbsolutePath());
        }
    }

    private void toggleAddressUsage(ActionEvent evt) {
        if (this.useUserDefinedAddress.isSelected()) {
            this.addressValue.setEnabled(true);
            int debugPort = 9009;
            try {
                ServerSocket t = new ServerSocket(0);
                debugPort = t.getLocalPort();
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.addressValue.setText(Integer.toString(debugPort));
            this.addressValue.setEditable(true);
        } else {
            this.addressValue.setEditable(false);
            this.addressValue.setText("");
            this.addressValue.setEnabled(false);
        }
    }
}

