/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewServerLogAction
extends NodeAction {
    private static final String SHOW_SERVER_LOG_ICONBASE = "org/netbeans/modules/glassfish/common/resources/serverlog.gif";

    protected void performAction(Node[] nodes) {
        Lookup lookup = nodes[0].getLookup();
        GlassfishModule commonSupport = (GlassfishModule)lookup.lookup(GlassfishModule.class);
        if (commonSupport != null) {
            Map<String, String> properties = commonSupport.getInstanceProperties();
            String uri = properties.get("url");
            LogViewMgr mgr = LogViewMgr.getInstance(uri);
            List<Recognizer> recognizers = this.getRecognizers(lookup.lookupAll(RecognizerCookie.class));
            mgr.ensureActiveReader(recognizers, this.getServerLog(properties));
            mgr.selectIO();
        }
    }

    private List<Recognizer> getRecognizers(Collection<? extends RecognizerCookie> cookies) {
        List<Recognizer> recognizers;
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie recognizerCookie : cookies) {
                recognizers.addAll(recognizerCookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    private File getServerLog(Map<String, String> ip) {
        String domainName;
        File result = null;
        String domainsFolder = ip.get("domainsfolder");
        File domainFolder = new File(domainsFolder, domainName = ip.get("domainname"));
        if (domainFolder.exists()) {
            result = new File(domainFolder, "logs" + File.separatorChar + "server.log");
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, NbBundle.getMessage(ViewServerLogAction.class, (String)"MSG_DomainFolderNotFound", (Object)domainFolder.getAbsolutePath()));
        }
        return result;
    }

    protected boolean enable(Node[] nodes) {
        GlassfishModule commonSupport;
        if (nodes != null && nodes.length == 1 && nodes[0] != null && (commonSupport = (GlassfishModule)nodes[0].getLookup().lookup(GlassfishModule.class)) != null) {
            String uri = commonSupport.getInstanceProperties().get("url");
            return uri != null && uri.length() > 0 && null != commonSupport.getInstanceProperties().get("domainsfolder");
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ViewServerLogAction.class, (String)"CTL_ViewServerLogAction");
    }

    protected String iconResource() {
        return SHOW_SERVER_LOG_ICONBASE;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

