/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.spi;

import java.awt.Component;
import java.awt.Graphics;
import java.net.PasswordAuthentication;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class KenaiUserUI {
    KenaiUser user;
    private static ImageIcon ONLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/user_online.png"));
    private static ImageIcon OFFLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/user_offline.png"));
    private Icon icon;
    private String chatMessage;

    public KenaiUserUI(String userName) {
        this.user = KenaiUser.forName((String)userName);
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    if (KenaiUserUI.this.user.isOnline()) {
                        ONLINE.paintIcon(c, g, x, y);
                    } else {
                        OFFLINE.paintIcon(c, g, x, y);
                    }
                }

                @Override
                public int getIconWidth() {
                    if (KenaiUserUI.this.user.isOnline()) {
                        return ONLINE.getIconWidth();
                    }
                    return ONLINE.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    if (KenaiUserUI.this.user.isOnline()) {
                        return ONLINE.getIconHeight();
                    }
                    return ONLINE.getIconHeight();
                }
            };
        }
        return this.icon;
    }

    public JLabel createUserWidget() {
        return UIUtils.createUserWidget(this);
    }

    public String getUserName() {
        return this.user.getUserName();
    }

    public void setMessage(String message) {
        this.chatMessage = message;
    }

    public void startChat() {
        this.startChat(this.chatMessage);
    }

    public void startChat(final String message) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                final Kenai kenai = KenaiUserUI.this.user.getKenai();
                if (!Utilities.isChatSupported(kenai)) {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Utilities.class, (String)"MSG_CHAT_NOT_SUPPORTED", (Object)kenai.getName()));
                    return;
                }
                if (kenai.getStatus() != Kenai.Status.ONLINE) {
                    if (JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Utilities.class, (String)"MSG_GO_ONLINE"), NbBundle.getMessage(Utilities.class, (String)"MSG_GO_ONLINE_TITLE"), 0) == 0) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                PasswordAuthentication pass = kenai.getPasswordAuthentication();
                                if (pass != null) {
                                    try {
                                        kenai.login(pass.getUserName(), pass.getPassword(), true);
                                        KenaiUserUI.this.startChat();
                                    }
                                    catch (KenaiException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                } else if (UIUtils.tryLogin(KenaiUserUI.this.user.getKenai(), true)) {
                                    KenaiUserUI.this.startChat();
                                } else {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (UIUtils.showLogin()) {
                                                KenaiUserUI.this.startChat();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return;
                    }
                    return;
                }
                ChatTopComponent tc = ChatTopComponent.findInstance();
                tc.open();
                tc.requestActive();
                tc.setActivePrivate(KenaiUserUI.this.user.getFQN());
                tc.insertToActiveChat(message);
                tc.requestFocus();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public KenaiUser getKenaiUser() {
        return this.user;
    }
}

