/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.DelayExtensionProvider;
import org.netbeans.modules.kenai.collab.chat.NotificationExtension;
import org.netbeans.modules.kenai.collab.chat.NotificationExtensionProvider;
import org.netbeans.modules.kenai.collab.chat.PresenceIndicator;
import org.netbeans.modules.kenai.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class KenaiConnection
implements PropertyChangeListener {
    public static final String PROP_XMPP_STARTED = "xmpp_started";
    public static final String PROP_XMPP_FINISHED = "xmpp_finished";
    private HashMap<String, PacketListener> groupListeners = new HashMap();
    private HashMap<String, PacketListener> privateListeners = new HashMap();
    private XMPPConnection connection;
    private final Map<String, MultiUserChat> groupChats = new HashMap<String, MultiUserChat>();
    private final Map<String, Chat> privateChats = new HashMap<String, Chat>();
    private static WeakHashMap<Kenai, KenaiConnection> instances = new WeakHashMap();
    private static Logger XMPPLOG = Logger.getLogger(KenaiConnection.class.getName());
    private HashMap<String, LinkedList<Message>> groupMessageQueue = new HashMap();
    private HashMap<String, LinkedList<Message>> privateMessageQueue = new HashMap();
    private static ChatNotifications chatNotifications = ChatNotifications.getDefault();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Kenai kenai;
    private RequestProcessor xmppProcessor = new RequestProcessor("XMPP Processor");
    private boolean isConnectionFailed;
    private String USER;

    static synchronized Iterable<KenaiConnection> getAllInstances() {
        return new ArrayList<KenaiConnection>(instances.values());
    }

    public static synchronized KenaiConnection getDefault(Kenai k) {
        KenaiConnection kc = instances.get(k);
        if (kc == null) {
            kc = new KenaiConnection(k);
            k.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)kc, (Object)k));
            instances.put(k, kc);
        }
        return kc;
    }

    public Kenai getKenai() {
        return this.kenai;
    }

    public static KenaiProject getKenaiProject(String room) {
        assert (!room.contains("/")) : "room name cannot contain '/'";
        String kenaiUrl = "https://" + room.substring(room.indexOf("@muc.") + "@muc.".length());
        Kenai kenai = KenaiManager.getDefault().getKenai(kenaiUrl);
        try {
            return kenai.getProject(room.substring(0, room.indexOf("@muc.")));
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static KenaiProject getKenaiProject(MultiUserChat muc) {
        return KenaiConnection.getKenaiProject(muc.getRoom());
    }

    public static Kenai getKenai(String jid) {
        Utilities.assertJid(jid);
        int index = jid.indexOf("@muc.");
        index = index < 0 ? jid.indexOf("@") + 1 : (index += 5);
        String kenaiUrl = "https://" + jid.substring(index);
        return KenaiManager.getDefault().getKenai(kenaiUrl);
    }

    private KenaiConnection(Kenai kenai) {
        this.kenai = kenai;
    }

    synchronized void leaveGroup(String name) {
        assert (!name.contains("@")) : "FQN cannot be used";
        this.groupListeners.remove(name);
    }

    synchronized void leavePrivate(String name) {
        Utilities.assertJid(name);
        this.privateListeners.remove(name);
    }

    synchronized void tryJoinChat(MultiUserChat chat) throws XMPPException {
        chat.join(this.getUserName());
    }

    private synchronized MultiUserChat createChat(KenaiFeature prj) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection, this.getChatroomName(prj));
        this.groupChats.put(prj.getName(), multiUserChat);
        this.groupMessageQueue.put(prj.getName(), new LinkedList());
        multiUserChat.addMessageListener((PacketListener)new MessageL());
        this.join(multiUserChat);
        return multiUserChat;
    }

    private void join(MultiUserChat chat) {
        try {
            assert (this.connection.isConnected());
            assert (this.connection.isAuthenticated());
            chat.addParticipantListener((PacketListener)new PresenceIndicator.PresenceListener());
            chat.addParticipantListener((PacketListener)new PresenceListener());
            chat.join(this.getUserName());
        }
        catch (XMPPException ex) {
            XMPPLOG.log(Level.INFO, "Cannot join " + chat.getRoom(), ex);
        }
    }

    public synchronized Chat joinPrivate(String jid, PacketListener lsn) {
        Utilities.assertJid(jid);
        Chat result = this.privateChats.get(jid);
        if (result == null) {
            result = KenaiConnection.getKenai(jid).getXMPPConnection().getChatManager().createChat(jid, null);
            this.privateChats.put(jid, result);
        }
        if (this.privateMessageQueue.get(jid) == null) {
            this.privateMessageQueue.put(jid, new LinkedList());
        }
        PacketListener put = this.privateListeners.put(jid, lsn);
        for (Message m : this.privateMessageQueue.get(jid)) {
            lsn.processPacket((Packet)m);
        }
        assert (put == null) : "User " + jid + " already joined";
        return result;
    }

    public synchronized void join(MultiUserChat muc, PacketListener lsn) {
        String name = StringUtils.parseName((String)muc.getRoom());
        PacketListener put = this.groupListeners.put(name, lsn);
        for (Message m : this.groupMessageQueue.get(name)) {
            lsn.processPacket((Packet)m);
        }
        assert (put == null) : "Chat room " + muc.getRoom() + " already joined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tryConnect() {
        try {
            this.propertyChangeSupport.firePropertyChange(PROP_XMPP_STARTED, null, null);
            this.connect();
            this.initChats();
            this.isConnectionFailed = false;
        }
        catch (XMPPException ex) {
            this.isConnectionFailed = true;
        }
        finally {
            this.propertyChangeSupport.firePropertyChange(PROP_XMPP_FINISHED, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected() && this.connection.isAuthenticated();
    }

    private void connect() throws XMPPException {
        this.connection = this.kenai.getXMPPConnection();
        this.connection.addPacketListener((PacketListener)new PacketL(), (PacketFilter)new MessageTypeFilter(Message.Type.chat));
    }

    public synchronized void reconnect(MultiUserChat muc) throws XMPPException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        if (muc == null) {
            for (MultiUserChat m : this.getChats()) {
                if (m.isJoined()) continue;
                this.tryJoinChat(m);
            }
        } else if (!muc.isJoined()) {
            this.tryJoinChat(muc);
        }
        this.isConnectionFailed = false;
    }

    public Collection<String> getMembers(String id) {
        MultiUserChat muc = this.getChat(id);
        if (muc != null) {
            Iterator i = muc.getOccupants();
            ArrayList<String> result = new ArrayList<String>();
            while (i.hasNext()) {
                result.add(StringUtils.parseResource((String)((String)i.next())));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void initChats() {
        if (!this.connection.isConnected()) {
            return;
        }
        for (KenaiFeature prj : this.getMyChats()) {
            try {
                this.createChat(prj);
            }
            catch (IllegalStateException ise) {
                XMPPLOG.log(Level.INFO, "https://netbeans.org/bugzilla/show_bug.cgi?id=176882", ise);
            }
        }
    }

    public synchronized List<MultiUserChat> getChats() {
        ArrayList<MultiUserChat> copy = new ArrayList<MultiUserChat>(this.groupChats.values());
        return copy;
    }

    public synchronized MultiUserChat getChat(KenaiFeature prj) {
        MultiUserChat multiUserChat = this.groupChats.get(prj.getName());
        if (multiUserChat == null) {
            multiUserChat = this.createChat(prj);
        }
        return multiUserChat;
    }

    public synchronized MultiUserChat getChat(String name) {
        assert (!name.contains("@")) : "getChat does not accept FQNs";
        return this.groupChats.get(name);
    }

    public synchronized Chat getPrivateChat(String jid) {
        Utilities.assertJid(jid);
        return this.privateChats.get(jid);
    }

    public RequestProcessor.Task post(Runnable run) {
        return this.xmppProcessor.post(run);
    }

    public boolean isConnectionFailed() {
        return this.isConnectionFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("xmpp_login".equals(e.getPropertyName())) {
            if (e.getNewValue() != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        KenaiConnection kenaiConnection = KenaiConnection.this;
                        synchronized (kenaiConnection) {
                            block5: {
                                PasswordAuthentication pa = KenaiConnection.this.kenai.getPasswordAuthentication();
                                KenaiConnection.this.USER = pa.getUserName();
                                try {
                                    KenaiConnection.this.tryConnect();
                                }
                                catch (IllegalStateException ise) {
                                    if (KenaiConnection.this.kenai.getXMPPConnection() == null) break block5;
                                    Exceptions.printStackTrace((Throwable)ise);
                                }
                            }
                        }
                    }
                });
            } else {
                try {
                    KenaiConnection kenaiConnection = this;
                    synchronized (kenaiConnection) {
                        for (MultiUserChat muc : this.getChats()) {
                            try {
                                muc.leave();
                            }
                            catch (IllegalStateException ise) {
                                XMPPLOG.log(Level.FINE, null, ise);
                            }
                        }
                        this.groupChats.clear();
                        this.groupMessageQueue.clear();
                        this.groupListeners.clear();
                        this.privateListeners.clear();
                        this.privateMessageQueue.clear();
                        this.privateChats.clear();
                    }
                    ChatNotifications.getDefault().clearAll(this.kenai);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private String getUserName() {
        return this.USER;
    }

    private String getChatroomName(KenaiFeature prj) {
        return prj.getName() + "@muc." + this.kenai.getUrl().getHost();
    }

    public Collection<KenaiFeature> getMyChats() {
        ArrayList<KenaiFeature> myChats = new ArrayList<KenaiFeature>();
        try {
            for (KenaiProject prj : this.kenai.getMyProjects()) {
                myChats.addAll(Arrays.asList(prj.getFeatures(KenaiService.Type.CHAT)));
            }
            return myChats;
        }
        catch (KenaiException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addExtensionProvider("delay", "urn:xmpp:delay", (Object)new DelayExtensionProvider());
        providerManager.addExtensionProvider("notification", "http://kenai.com/schema/XMPPNotification", (Object)new NotificationExtensionProvider());
    }

    public class PresenceListener
    implements PacketListener {
        public void processPacket(Packet packet) {
            KenaiConnection.this.xmppProcessor.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ChatTopComponent.refreshContactList();
                        }
                    });
                }
            }, 100);
        }
    }

    private class MessageL
    implements PacketListener {
        private MessageL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            KenaiConnection kenaiConnection = KenaiConnection.this;
            synchronized (kenaiConnection) {
                final Message msg = (Message)packet;
                String n = StringUtils.parseName((String)msg.getFrom());
                if (n.contains("@")) {
                    n = StringUtils.parseName((String)n);
                }
                final String name = n;
                final NotificationExtension ne = (NotificationExtension)msg.getExtension("notification", "http://kenai.com/schema/XMPPNotification");
                if (ne != null && msg.getExtension("x", "jabber:x:delay") == null) {
                    KenaiConnection.this.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                KenaiConnection.this.kenai.getProject(name).firePropertyChange("project_notification", null, (Object)ne.getNotification());
                            }
                            catch (KenaiException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
                if (ne != null && !Boolean.parseBoolean(System.getProperty("kenai.show.notifications.in.chat", "true"))) {
                    return;
                }
                LinkedList thisQ = (LinkedList)KenaiConnection.this.groupMessageQueue.get(name);
                thisQ.add(msg);
                final PacketListener listener = (PacketListener)KenaiConnection.this.groupListeners.get(name);
                if (listener != null) {
                    listener.processPacket((Packet)msg);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (chatNotifications.isEnabled(StringUtils.parseBareAddress((String)msg.getFrom())) && (listener == null || !ChatTopComponent.isGroupInitedAndVisible(StringUtils.parseBareAddress((String)msg.getFrom())))) {
                            chatNotifications.addGroupMessage(msg);
                        } else {
                            try {
                                chatNotifications.getMessagingHandle(KenaiConnection.this.kenai.getProject(name)).notifyMessageReceived(msg);
                                chatNotifications.getMessagingHandle(KenaiConnection.this.kenai.getProject(name)).notifyMessagesRead();
                            }
                            catch (KenaiException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
    }

    private class PacketL
    implements PacketListener {
        private PacketL() {
        }

        public void processPacket(Packet packet) {
            final Message msg = (Message)packet;
            final String name = StringUtils.parseBareAddress((String)msg.getFrom());
            LinkedList<Message> thisQ = (LinkedList<Message>)KenaiConnection.this.privateMessageQueue.get(name);
            if (thisQ == null) {
                thisQ = new LinkedList<Message>();
                KenaiConnection.this.privateMessageQueue.put(name, thisQ);
            }
            thisQ.add(msg);
            PacketListener listener = (PacketListener)KenaiConnection.this.privateListeners.get(name);
            if (listener != null) {
                listener.processPacket((Packet)msg);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (chatNotifications.isEnabled(name) && !ChatTopComponent.isPrivateInitedAndVisible(name)) {
                        chatNotifications.addPrivateMessage(msg);
                    }
                }
            });
        }
    }
}

