/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.msa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.collector.procfs.ProcFSDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.visualizers.api.ThreadMapVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.openide.util.NbBundle;

public class ThreadMapToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final Logger log = DLightLogger.getLogger(ThreadMapToolConfigurationProvider.class);
    public static final int INDICATOR_POSITION = 10;
    private static final String ID = "dlight.tool.threadmap";
    private static final String TOOL_NAME = ThreadMapToolConfigurationProvider.loc("ThreadMapTool.ToolName", new String[0]);
    private static final String DETAILED_TOOL_NAME = ThreadMapToolConfigurationProvider.loc("ThreadMapTool.DetailedToolName", new String[0]);

    public DLightToolConfiguration create() {
        DLightToolConfiguration toolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        toolConfiguration.setLongName(DETAILED_TOOL_NAME);
        toolConfiguration.setIcon("org/netbeans/modules/dlight/msa/resources/thread_microstates_16.png");
        toolConfiguration.setDescription(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Description", new String[0]));
        List<DataTableMetadata.Column> indicatorDataColumns = Arrays.asList(MSASQLTables.prstat.P_SLEEP, MSASQLTables.prstat.P_WAIT, MSASQLTables.prstat.P_BLOCKED, MSASQLTables.prstat.P_RUNNING);
        TimeSeriesIndicatorConfiguration indicatorConfig = new TimeSeriesIndicatorConfiguration(new IndicatorMetadata(indicatorDataColumns), 10);
        indicatorConfig.setPersistencePrefix("dlight_msa");
        indicatorConfig.setTitle(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Title", new String[0]));
        indicatorConfig.setGraphScale(1);
        indicatorConfig.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor("sleeping", ThreadStateResources.THREAD_SLEEPING.name, ThreadStateResources.THREAD_SLEEPING.color, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor("waiting", ThreadStateResources.THREAD_WAITING.name, ThreadStateResources.THREAD_WAITING.color, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor("blocked", ThreadStateResources.THREAD_BLOCKED.name, ThreadStateResources.THREAD_BLOCKED.color, TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor("running", ThreadStateResources.THREAD_RUNNING.name, ThreadStateResources.THREAD_RUNNING.color, TimeSeriesDescriptor.Kind.REL_SURFACE)});
        indicatorConfig.setDataRowHandler((DataRowToTimeSeries)new IndicatorDataHandler(indicatorDataColumns));
        indicatorConfig.setActionDisplayName(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Action", new String[0]));
        indicatorConfig.setActionTooltip(ThreadMapToolConfigurationProvider.loc("ThreadMapTool.Indicator.Action.Tooltip", new String[0]));
        ThreadMapVisualizerConfiguration visualizerConfig = new ThreadMapVisualizerConfiguration();
        indicatorConfig.addVisualizerConfiguration((VisualizerConfiguration)visualizerConfig);
        toolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)indicatorConfig);
        ProcFSDCConfiguration procFSDCConfig = new ProcFSDCConfiguration();
        procFSDCConfig.collectProcInfo(1000);
        procFSDCConfig.collectMSA(1000);
        toolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)procFSDCConfig);
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)procFSDCConfig);
        toolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)DTDCConfiguration.createCpuSamplingConfiguration());
        return toolConfiguration;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ThreadMapToolConfigurationProvider.class, (String)key, (Object[])params);
    }

    private static class IndicatorDataHandler
    implements DataRowToTimeSeries {
        private static final Object lock = IndicatorDataHandler.class.getName() + "Lock";
        private final List<String> colNames = new ArrayList<String>();

        private IndicatorDataHandler(List<DataTableMetadata.Column> indicatorDataColumns) {
            for (DataTableMetadata.Column c : indicatorDataColumns) {
                this.colNames.add(c.getColumnName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] getData(DataRow row) {
            int idx = 0;
            float[] result = null;
            Object object = lock;
            synchronized (object) {
                for (String cn : this.colNames) {
                    block7: {
                        try {
                            float f = row.getFloatValue(cn).floatValue();
                            if (result == null) {
                                result = new float[this.colNames.size()];
                            }
                            result[idx] = f;
                        }
                        catch (RuntimeException ex) {
                            if (!log.isLoggable(Level.FINE)) break block7;
                            log.log(Level.FINE, "Will not add this entry", ex);
                        }
                    }
                    ++idx;
                }
            }
            return result;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }
}

