/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.AbstractAnimate;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.MotionRefValues;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.platform.MathSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGElement;

public class AnimateMotion
extends AbstractAnimate {
    static final int ROTATE_ANGLE = 1;
    static final int ROTATE_AUTO = 2;
    static final int ROTATE_AUTO_REVERSE = 3;
    String path;
    float[] keyPoints;
    float rotate;
    float cosRotate = 1.0f;
    float sinRotate;
    int rotateType = 1;
    RefValues pathRefValues;
    RefValues mpathRefValues;

    public AnimateMotion(DocumentNode ownerDocument) {
        super(ownerDocument, "animateMotion");
        this.calcMode = 3;
        this.traitName = "#motion";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new AnimateMotion(doc);
    }

    boolean supportsTrait(String traitName) {
        if ("path" == traitName || "keyPoints" == traitName || "rotate" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("path" == name) {
            return this.path;
        }
        if ("keyPoints" == name) {
            return this.toStringTrait(this.keyPoints);
        }
        if ("rotate" == name) {
            switch (this.rotateType) {
                case 1: {
                    return Float.toString(this.rotate);
                }
                case 2: {
                    return "auto";
                }
            }
            return "auto-reverse";
        }
        return super.getTraitImpl(name);
    }

    protected void mapToSegmentProgress(int si, float sp, float[] sisp) {
        if (this.keyPoints == null || this.actualCalcMode == 3) {
            super.mapToSegmentProgress(si, sp, sisp);
            return;
        }
        float startDist = this.keyPoints[si];
        float endDist = this.keyPoints[si + 1];
        float dist = sp * endDist + (1.0f - sp) * startDist;
        ((MotionRefValues)this.refValues).getSegmentAtDist(sisp, dist);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("path" == name) {
            this.checkWriteLoading(name);
            this.path = value;
        } else if ("keyPoints" == name) {
            this.checkWriteLoading(name);
            this.keyPoints = this.parseFloatArrayTrait(name, value, ';');
        } else if ("rotate" == name) {
            this.checkWriteLoading(name);
            if ("auto".equals(value)) {
                this.rotate = 0.0f;
                this.rotateType = 2;
            } else if ("auto-reverse".equals(value)) {
                this.rotate = 0.0f;
                this.rotateType = 3;
            } else {
                this.rotate = this.parseFloatTrait(name, value);
                this.cosRotate = MathSupport.cos(MathSupport.toRadians(this.rotate));
                this.sinRotate = MathSupport.sin(MathSupport.toRadians(this.rotate));
                this.rotateType = 1;
            }
        } else {
            super.setTraitImpl(name, value);
        }
    }

    protected void computeRefTimes() throws DOMException {
        if (this.keyPoints == null || this.actualCalcMode == 3) {
            super.computeRefTimes();
            return;
        }
        if (this.keyTimes == null || this.keyTimes.length < 1 || this.keyTimes[0] != 0.0f || this.actualCalcMode != 2 && this.keyTimes[this.keyTimes.length - 1] != 1.0f || this.keyTimes.length != this.keyPoints.length) {
            throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage("error.invalid.animation.key.times", new Object[]{this.getTrait("keyTimes")}));
        }
        if (this.actualCalcMode != 2) {
            this.refTimes = new float[this.keyTimes.length - 1];
            System.arraycopy(this.keyTimes, 0, this.refTimes, 0, this.refTimes.length);
        } else {
            this.refTimes = this.keyTimes;
        }
    }

    final void validateValuesExtra() throws DOMException {
        this.pathRefValues = null;
        if (this.path != null) {
            this.pathRefValues = this.traitAnim.toRefValues(this, new String[]{this.path}, null, "path");
        }
        this.mpathRefValues = null;
        SVGElement mpath = null;
        for (SVGElement c = (SVGElement)this.getFirstElementChild(); c != null; c = (SVGElement)c.getNextElementSibling()) {
            if (!"mpath".equals(c.getLocalName()) || !"http://www.w3.org/2000/svg".equals(c.getNamespaceURI())) continue;
            mpath = c;
            break;
        }
        if (mpath != null) {
            String pathHref = ((ElementNode)mpath).getTraitNSImpl("http://www.w3.org/1999/xlink", "href");
            if (pathHref != null) {
                boolean pathHrefError = false;
                if (pathHref.startsWith("#")) {
                    String pathId = pathHref.substring(1);
                    ElementNode path = (ElementNode)this.ownerDocument.getElementById(pathId);
                    if (path != null) {
                        this.mpathRefValues = this.traitAnim.toRefValues(this, new String[]{path.getTraitImpl("d")}, null, "d");
                    } else {
                        pathHrefError = true;
                    }
                } else {
                    pathHrefError = true;
                }
                if (pathHrefError) {
                    throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage(Messages.ERROR_INVALID_MPATH_HREF, new Object[]{pathHref}));
                }
            } else {
                throw this.animationError(this.idRef, this.traitNamespace, this.traitName, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.getId(), this.getNamespaceURI(), this.getLocalName(), Messages.formatMessage(Messages.ERROR_MISSING_MPATH_HREF, null));
            }
        }
    }

    final void selectRefValuesExtra() throws DOMException {
        if (this.mpathRefValues != null) {
            this.refValues = this.mpathRefValues;
        } else if (this.pathRefValues != null) {
            this.refValues = this.pathRefValues;
        }
    }
}

