/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RenderGraphics;
import java.awt.Color;
import org.w3c.dom.svg.SVGRGBColor;

public class RGB
implements SVGRGBColor,
PaintDef,
PaintServer {
    int rgb = -16777216;
    Color color;
    boolean hasAlpha = false;
    public static final RGB black = new RGB(0, 0, 0);
    public static final RGB white = new RGB(255, 255, 255);
    public static final RGB blue = new RGB(0, 0, 255);
    public static final RGB orange = new RGB(255, 200, 0);
    public static final RGB red = new RGB(255, 0, 0);
    public static final RGB green = new RGB(0, 255, 0);
    public static final RGB yellow = new RGB(255, 255, 0);
    public static final RGB gray = new RGB(192, 192, 192);

    public RGB(int r, int g, int b) {
        this(255, r, g, b);
    }

    public RGB(int a, int r, int g, int b) {
        this.rgb = a << 24 | r << 16 | g << 8 | b;
        this.hasAlpha = a < 255;
    }

    public void applyPaint(RenderGraphics rg) {
        rg.g.setColor(this.getColor());
    }

    public final Color getColor() {
        if (this.color == null) {
            this.color = new Color(this.rgb, this.hasAlpha);
        }
        return this.color;
    }

    public int getAlpha() {
        return 0xFF & this.rgb >> 24;
    }

    public int getRed() {
        return 0xFF & this.rgb >> 16;
    }

    public int getGreen() {
        return 0xFF & this.rgb >> 8;
    }

    public int getBlue() {
        return 0xFF & this.rgb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("rgb(");
        sb.append(this.getRed());
        sb.append(",");
        sb.append(this.getGreen());
        sb.append(",");
        sb.append(this.getBlue());
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object cmp) {
        if (cmp == null || !(cmp instanceof RGB)) {
            return false;
        }
        RGB c = (RGB)cmp;
        return c.rgb == this.rgb;
    }

    public PaintDef getPaintDef() {
        return this;
    }

    public void setPaintTarget(String paintType, PaintTarget paintTarget) {
    }

    public void dispose() {
        this.color = null;
    }
}

