/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.text;

import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.text.GoAndBackKey;
import org.netbeans.jemmy.drivers.text.NavigationKey;
import org.netbeans.jemmy.drivers.text.OffsetKey;
import org.netbeans.jemmy.operators.ComponentOperator;

public abstract class TextKeyboardDriver
extends LightSupportiveDriver
implements TextDriver {
    public TextKeyboardDriver(String[] supported) {
        super(supported);
    }

    public void changeCaretPosition(ComponentOperator oper, int position) {
        DriverManager.getFocusDriver(oper).giveFocus(oper);
        this.checkSupported(oper);
        this.changeCaretPosition(oper, position, 0);
    }

    public void selectText(ComponentOperator oper, int startPosition, int finalPosition) {
        this.changeCaretPosition(oper, startPosition);
        DriverManager.getKeyDriver(oper).pressKey(oper, 16, 0);
        this.changeCaretPosition(oper, finalPosition, 1);
        DriverManager.getKeyDriver(oper).releaseKey(oper, 16, 0);
    }

    public void clearText(ComponentOperator oper) {
        DriverManager.getFocusDriver(oper).giveFocus(oper);
        this.checkSupported(oper);
        KeyDriver kdriver = DriverManager.getKeyDriver(oper);
        Timeout pushTime = oper.getTimeouts().create("ComponentOperator.PushKeyTimeout");
        Timeout betweenTime = this.getBetweenTimeout(oper);
        while (this.getCaretPosition(oper) > 0) {
            kdriver.typeKey(oper, 8, '\b', 0, pushTime);
            betweenTime.sleep();
        }
        while (this.getText(oper).length() > 0) {
            kdriver.pushKey(oper, 127, 0, pushTime);
            betweenTime.sleep();
        }
    }

    public void typeText(ComponentOperator oper, String text, int caretPosition) {
        this.changeCaretPosition(oper, caretPosition);
        KeyDriver kDriver = DriverManager.getKeyDriver(oper);
        CharBindingMap map = oper.getCharBindingMap();
        Timeout pushTime = oper.getTimeouts().create("ComponentOperator.PushKeyTimeout");
        Timeout betweenTime = this.getBetweenTimeout(oper);
        char[] crs = text.toCharArray();
        for (int i = 0; i < crs.length; ++i) {
            kDriver.typeKey(oper, map.getCharKey(crs[i]), crs[i], map.getCharModifiers(crs[i]), pushTime);
            betweenTime.sleep();
        }
    }

    public void changeText(ComponentOperator oper, String text) {
        this.clearText(oper);
        this.typeText(oper, text, 0);
    }

    public void enterText(ComponentOperator oper, String text) {
        this.changeText(oper, text);
        DriverManager.getKeyDriver(oper).pushKey(oper, 10, 0, new Timeout("", 0L));
    }

    public abstract String getText(ComponentOperator var1);

    public abstract int getCaretPosition(ComponentOperator var1);

    public abstract int getSelectionStart(ComponentOperator var1);

    public abstract int getSelectionEnd(ComponentOperator var1);

    public abstract NavigationKey[] getKeys(ComponentOperator var1);

    public abstract Timeout getBetweenTimeout(ComponentOperator var1);

    protected void changeCaretPosition(ComponentOperator oper, int position, int preModifiers) {
        NavigationKey[] keys = this.getKeys(oper);
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] instanceof OffsetKey) {
                this.moveCaret(oper, (OffsetKey)keys[i], position, preModifiers);
                continue;
            }
            this.moveCaret(oper, (GoAndBackKey)keys[i], position, preModifiers);
        }
    }

    private int difference(int one, int two) {
        if (one >= two) {
            return one - two;
        }
        return two - one;
    }

    private void push(ComponentOperator oper, NavigationKey key, int preModifiers) {
        DriverManager.getKeyDriver(oper).pushKey(oper, key.getKeyCode(), key.getModifiers() | preModifiers, oper.getTimeouts().create("ComponentOperator.PushKeyTimeout"));
        this.getBetweenTimeout(oper).sleep();
    }

    private final void moveCaret(ComponentOperator oper, GoAndBackKey key, int position, int preModifiers) {
        int newDiff;
        int oldDiff = newDiff = this.difference(position, this.getCaretPosition(oper));
        QueueTool qTool = new QueueTool();
        qTool.setOutput(oper.getOutput().createErrorOutput());
        while (key.getDirection() * (position - this.getCaretPosition(oper)) > 0) {
            oldDiff = newDiff;
            this.push(oper, key, preModifiers);
            qTool.waitEmpty();
            newDiff = this.difference(position, this.getCaretPosition(oper));
            if (newDiff != oldDiff) continue;
            return;
        }
        if (newDiff > oldDiff) {
            this.push(oper, key.getBackKey(), preModifiers);
        }
    }

    private final void moveCaret(ComponentOperator oper, OffsetKey key, int position, int preModifiers) {
        if (this.gotToGo(oper, position, key.getExpectedPosition())) {
            this.push(oper, key, preModifiers);
        }
    }

    private boolean gotToGo(ComponentOperator oper, int point, int offset) {
        return this.difference(point, offset) < this.difference(point, this.getCaretPosition(oper));
    }
}

