/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;

public class ObjectBrowser
implements Outputable {
    private Object object;
    private TestOut output;

    public void setOutput(TestOut out) {
        this.output = out;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }

    public Object getObject() {
        return this.object;
    }

    public void printToString() {
        this.output.printLine(this.object.toString());
    }

    public void printFields() {
        Class<?> cl = this.object.getClass();
        this.output.printLine("Class: " + cl.getName());
        this.output.printLine("Fields: ");
        Field[] fields = cl.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.output.printLine(Modifier.toString(fields[i].getModifiers()) + " " + fields[i].getType().getName() + " " + fields[i].getName());
            Object value = "Inaccessible";
            try {
                value = fields[i].get(this.object);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            this.output.printLine("    Value: " + value.toString());
        }
    }

    public void printMethods() {
        Class<?> cl = this.object.getClass();
        this.output.printLine("Class: " + cl.getName());
        this.output.printLine("Methods: ");
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.output.printLine(Modifier.toString(methods[i].getModifiers()) + " " + methods[i].getReturnType().getName() + " " + methods[i].getName());
            Class<?>[] params = methods[i].getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                this.output.printLine("    " + params[j].getName());
            }
        }
    }

    public void printClasses() {
        Class<?> cl = this.object.getClass();
        do {
            this.output.printLine(cl.getName());
        } while ((cl = cl.getSuperclass()) != null);
    }

    public void printFull() {
        this.printFields();
        this.printMethods();
    }
}

