/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.jemmy.BundleManager;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.DefaultCharBindingMap;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.APIDriverInstaller;
import org.netbeans.jemmy.drivers.DefaultDriverInstaller;
import org.netbeans.jemmy.drivers.DriverInstaller;
import org.netbeans.jemmy.drivers.InputDriverInstaller;
import org.netbeans.jemmy.explorer.GUIBrowser;

public class JemmyProperties {
    public static int QUEUE_MODEL_MASK = 1;
    public static int ROBOT_MODEL_MASK = 2;
    public static int SHORTCUT_MODEL_MASK = 4;
    public static int SMOOTH_ROBOT_MODEL_MASK = 8;
    private static final int DEFAULT_DRAG_AND_DROP_STEP_LENGTH = 100;
    private static Stack propStack = null;
    Hashtable properties = new Hashtable();

    protected JemmyProperties() {
        this.setProperty("timeouts", new Timeouts());
        this.setProperty("output", new TestOut());
        this.setProperty("resources", new BundleManager());
        this.setProperty("binding.map", new DefaultCharBindingMap());
        this.setProperty("dispatching.model", new Integer(JemmyProperties.getDefaultDispatchingModel()));
        this.setProperty("drag_and_drop.step_length", new Integer(100));
    }

    public static String getMajorVersion() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-MajorVersion");
    }

    public static String getMinorVersion() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-MinorVersion");
    }

    public static String getBuild() {
        return JemmyProperties.extractValue(JemmyProperties.getProperties().getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/version_info"), "Jemmy-Build");
    }

    public static String getFullVersion() {
        return JemmyProperties.getMajorVersion() + "." + JemmyProperties.getMinorVersion() + "-" + JemmyProperties.getBuild();
    }

    public static String getVersion() {
        return JemmyProperties.getMajorVersion() + "." + JemmyProperties.getMinorVersion();
    }

    public static JemmyProperties push() {
        return JemmyProperties.push(JemmyProperties.getProperties().cloneThis());
    }

    public static JemmyProperties pop() {
        JemmyProperties result = (JemmyProperties)propStack.pop();
        if (propStack.isEmpty()) {
            propStack.push(result);
        }
        return result;
    }

    public static Object getCurrentProperty(String propertyName) {
        return JemmyProperties.getProperties().getProperty(propertyName);
    }

    public static Object setCurrentProperty(String propertyName, Object propertyValue) {
        return JemmyProperties.getProperties().setProperty(propertyName, propertyValue);
    }

    public static Object removeCurrentProperty(String propertyName) {
        return JemmyProperties.getProperties().removeProperty(propertyName);
    }

    public static String[] getCurrentKeys() {
        return JemmyProperties.getProperties().getKeys();
    }

    public static Timeouts getCurrentTimeouts() {
        return JemmyProperties.getProperties().getTimeouts();
    }

    public static Timeouts setCurrentTimeouts(Timeouts to) {
        return JemmyProperties.getProperties().setTimeouts(to);
    }

    public static long setCurrentTimeout(String name, long newValue) {
        return JemmyProperties.getProperties().getTimeouts().setTimeout(name, newValue);
    }

    public static long getCurrentTimeout(String name) {
        return JemmyProperties.getProperties().getTimeouts().getTimeout(name);
    }

    public static long initCurrentTimeout(String name, long newValue) {
        return JemmyProperties.getProperties().getTimeouts().initTimeout(name, newValue);
    }

    public static TestOut getCurrentOutput() {
        return JemmyProperties.getProperties().getOutput();
    }

    public static TestOut setCurrentOutput(TestOut out) {
        return JemmyProperties.getProperties().setOutput(out);
    }

    public static BundleManager getCurrentBundleManager() {
        return JemmyProperties.getProperties().getBundleManager();
    }

    public static BundleManager setCurrentBundleManager(BundleManager resources) {
        return JemmyProperties.getProperties().setBundleManager(resources);
    }

    public static String getCurrentResource(String key) {
        return JemmyProperties.getProperties().getBundleManager().getResource(key);
    }

    public static String getCurrentResource(String bundleID, String key) {
        return JemmyProperties.getProperties().getBundleManager().getResource(bundleID, key);
    }

    public static CharBindingMap getCurrentCharBindingMap() {
        return JemmyProperties.getProperties().getCharBindingMap();
    }

    public static CharBindingMap setCurrentCharBindingMap(CharBindingMap map) {
        return JemmyProperties.getProperties().setCharBindingMap(map);
    }

    public static int getCurrentDispatchingModel() {
        return JemmyProperties.getProperties().getDispatchingModel();
    }

    public static int setCurrentDispatchingModel(int model) {
        return JemmyProperties.getProperties().setDispatchingModel(model);
    }

    public static int getDefaultDispatchingModel() {
        return SHORTCUT_MODEL_MASK | QUEUE_MODEL_MASK;
    }

    public static int getCurrentDragAndDropStepLength() {
        return JemmyProperties.getProperties().getDragAndDropStepLength();
    }

    public static int setCurrentDragAndDropStepLength(int model) {
        return JemmyProperties.getProperties().setDragAndDropStepLength(model);
    }

    public static JemmyProperties getProperties() {
        if (propStack == null) {
            propStack = new Stack();
        }
        if (propStack.empty()) {
            propStack.add(new JemmyProperties());
        }
        return (JemmyProperties)propStack.peek();
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Jemmy version : " + JemmyProperties.getVersion());
        } else if (argv.length == 1 && argv[0].equals("-f")) {
            System.out.println("Jemmy full version : " + JemmyProperties.getFullVersion());
        } else if (argv.length > 0 && argv[0].equals("-e")) {
            String[] newArgv = new String[argv.length - 1];
            for (int i = 1; i < argv.length; ++i) {
                newArgv[i - 1] = argv[i];
            }
            GUIBrowser.main(newArgv);
        } else {
            System.out.println("Parameters: ");
            System.out.println("<no parameters> - report Jemmy version.");
            System.out.println("\"-f\" - report full jemmy version.");
        }
    }

    protected static JemmyProperties push(JemmyProperties props) {
        return propStack.push(props);
    }

    public void initProperties(String prop_file) {
        try {
            this.getOutput().printLine("Loading properties from " + prop_file + " file");
            Properties props = new Properties();
            props.load(new FileInputStream(prop_file));
            if (props.getProperty("TIMEOUTS_FILE") != null && !props.getProperty("TIMEOUTS_FILE").equals("")) {
                this.getOutput().printLine("Loading timeouts from " + props.getProperty("TIMEOUTS_FILE") + " file");
                this.getTimeouts().loadDefaults(props.getProperty("TIMEOUTS_FILE"));
            }
            if (props.getProperty("RESOURCE_FILE") != null && !props.getProperty("RESOURCE_FILE").equals("")) {
                this.getOutput().printLine("Loading resources from " + props.getProperty("RESOURCE_FILE") + " file");
                this.getBundleManager().loadBundleFromFile(props.getProperty("RESOURCE_FILE"), "");
            }
        }
        catch (IOException e) {
            this.getOutput().printStackTrace(e);
        }
    }

    public void initProperties() {
        if (System.getProperty("jemmy.properties") != null && !System.getProperty("jemmy.properties").equals("")) {
            this.initProperties(System.getProperty("jemmy.properties"));
        } else {
            try {
                this.getTimeouts().load();
                this.getBundleManager().load();
            }
            catch (IOException e) {
                this.getOutput().printStackTrace(e);
            }
        }
    }

    public void initDispatchingModel(boolean queue, boolean robot, boolean shortcut) {
        this.initDispatchingModel(queue, robot, shortcut, false);
    }

    public void initDispatchingModel(boolean queue, boolean robot, boolean shortcut, boolean smooth) {
        int model = JemmyProperties.getDefaultDispatchingModel();
        this.getOutput().print("Reproduce user actions ");
        if (queue) {
            model = QUEUE_MODEL_MASK;
            this.getOutput().printLine("through event queue.");
        } else {
            model -= model & QUEUE_MODEL_MASK;
            this.getOutput().printLine("directly.");
        }
        this.getOutput().print("Use ");
        if (robot) {
            model |= ROBOT_MODEL_MASK;
            this.getOutput().print("java.awt.Robot class");
        } else {
            model -= model & ROBOT_MODEL_MASK;
            this.getOutput().print("event dispatching");
        }
        model = smooth ? (model |= SMOOTH_ROBOT_MODEL_MASK) : (model -= model & SMOOTH_ROBOT_MODEL_MASK);
        this.getOutput().printLine(" to reproduce user actions");
        if (shortcut) {
            model |= SHORTCUT_MODEL_MASK;
            this.getOutput().print("Shortcut");
        } else {
            model -= model & SHORTCUT_MODEL_MASK;
            this.getOutput().print("Dispatch");
        }
        this.getOutput().printLine(" test events");
        this.setDispatchingModel(model);
    }

    public void initDispatchingModel(boolean queue, boolean robot) {
        this.initDispatchingModel(queue, robot, false);
    }

    public void initDispatchingModel() {
        boolean smask;
        boolean qmask = (JemmyProperties.getDefaultDispatchingModel() & QUEUE_MODEL_MASK) != 0;
        boolean rmask = (JemmyProperties.getDefaultDispatchingModel() & ROBOT_MODEL_MASK) != 0;
        boolean srmask = (JemmyProperties.getDefaultDispatchingModel() & SMOOTH_ROBOT_MODEL_MASK) != 0;
        boolean bl = smask = (JemmyProperties.getDefaultDispatchingModel() & SHORTCUT_MODEL_MASK) != 0;
        if (System.getProperty("jemmy.queue_dispatching") != null && !System.getProperty("jemmy.queue_dispatching").equals("")) {
            qmask = System.getProperty("jemmy.queue_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.robot_dispatching") != null && !System.getProperty("jemmy.robot_dispatching").equals("")) {
            rmask = System.getProperty("jemmy.robot_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.smooth_robot_dispatching") != null && !System.getProperty("jemmy.smooth_robot_dispatching").equals("")) {
            srmask = System.getProperty("jemmy.smooth_robot_dispatching").equals("on");
        }
        if (System.getProperty("jemmy.shortcut_events") != null && !System.getProperty("jemmy.shortcut_events").equals("")) {
            smask = System.getProperty("jemmy.shortcut_events").equals("on");
        }
        this.initDispatchingModel(qmask, rmask, smask, srmask);
    }

    public void init() {
        this.initProperties();
        this.initDispatchingModel();
    }

    public Timeouts getTimeouts() {
        return (Timeouts)this.getProperty("timeouts");
    }

    public Timeouts setTimeouts(Timeouts to) {
        return (Timeouts)this.setProperty("timeouts", to);
    }

    public long setTimeout(String name, long newValue) {
        return this.getTimeouts().setTimeout(name, newValue);
    }

    public long getTimeout(String name) {
        return this.getTimeouts().getTimeout(name);
    }

    public long initTimeout(String name, long newValue) {
        return this.getTimeouts().initTimeout(name, newValue);
    }

    public TestOut getOutput() {
        return (TestOut)this.getProperty("output");
    }

    public TestOut setOutput(TestOut out) {
        return (TestOut)this.setProperty("output", out);
    }

    public BundleManager getBundleManager() {
        return (BundleManager)this.getProperty("resources");
    }

    public BundleManager setBundleManager(BundleManager resources) {
        return (BundleManager)this.setProperty("resources", resources);
    }

    public String getResource(String key) {
        return this.getBundleManager().getResource(key);
    }

    public String getResource(String bundleID, String key) {
        return this.getBundleManager().getResource(bundleID, key);
    }

    public CharBindingMap getCharBindingMap() {
        return (CharBindingMap)this.getProperty("binding.map");
    }

    public CharBindingMap setCharBindingMap(CharBindingMap map) {
        return (CharBindingMap)this.setProperty("binding.map", map);
    }

    public int getDispatchingModel() {
        return (Integer)this.getProperty("dispatching.model");
    }

    private static DriverInstaller getDriverInstaller(int model) {
        String name = System.getProperty("jemmy.drivers.installer");
        Object installer = null;
        try {
            if (name != null && name.length() != 0) {
                installer = (DriverInstaller)new ClassReference(name).newInstance(null, null);
            }
        }
        catch (ClassNotFoundException e) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
        catch (IllegalAccessException e) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
        catch (InstantiationException e) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
        catch (InvocationTargetException e) {
            JemmyProperties.getCurrentOutput().printLine("Cannot init driver installer:");
            JemmyProperties.getCurrentOutput().printStackTrace(e);
        }
        if (installer == null) {
            installer = System.getProperty("os.name").startsWith("Mac OS X") ? new APIDriverInstaller((model & SHORTCUT_MODEL_MASK) != 0) : new DefaultDriverInstaller((model & SHORTCUT_MODEL_MASK) != 0);
        }
        JemmyProperties.getCurrentOutput().printLine("Using " + installer.getClass().getName() + " driver installer");
        return installer;
    }

    public int setDispatchingModel(int model) {
        new InputDriverInstaller((model & ROBOT_MODEL_MASK) == 0, (model & SMOOTH_ROBOT_MODEL_MASK) != 0).install();
        JemmyProperties.getDriverInstaller(model).install();
        return (Integer)this.setProperty("dispatching.model", new Integer(model));
    }

    public int getDragAndDropStepLength() {
        return (Integer)this.getProperty("drag_and_drop.step_length");
    }

    public int setDragAndDropStepLength(int length) {
        return (Integer)this.setProperty("drag_and_drop.step_length", new Integer(length));
    }

    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public Object setProperty(String name, Object newValue) {
        Object oldValue = null;
        if (this.contains(name)) {
            oldValue = this.properties.get(name);
            this.properties.remove(name);
        }
        this.properties.put(name, newValue);
        return oldValue;
    }

    public Object getProperty(String name) {
        if (this.contains(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    public Object removeProperty(String name) {
        if (this.contains(name)) {
            return this.properties.remove(name);
        }
        return null;
    }

    public String[] getKeys() {
        Enumeration keys = this.properties.keys();
        String[] result = new String[this.properties.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            result[i] = (String)keys.nextElement();
            ++i;
        }
        return result;
    }

    public void copyTo(JemmyProperties properties) {
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            properties.setProperty(keys[i], this.getProperty(keys[i]));
        }
        properties.setTimeouts(this.getTimeouts().cloneThis());
        properties.setBundleManager(this.getBundleManager().cloneThis());
    }

    protected JemmyProperties cloneThis() {
        JemmyProperties result = new JemmyProperties();
        this.copyTo(result);
        return result;
    }

    private static String extractValue(InputStream stream, String varName) {
        try {
            String nextLine;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((nextLine = reader.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(nextLine, ":");
                String nextToken = token.nextToken();
                if (nextToken == null || !nextToken.trim().equals(varName)) continue;
                return token.nextToken().trim();
            }
            return "";
        }
        catch (IOException e) {
            JemmyProperties.getCurrentOutput().printStackTrace(e);
            return "";
        }
    }

    static {
        JemmyProperties.setCurrentDispatchingModel(JemmyProperties.getDefaultDispatchingModel());
    }
}

