/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;

public class DefaultCharBindingMap
implements CharBindingMap {
    private Hashtable chars;
    private ClassReference cl;

    public DefaultCharBindingMap() {
        try {
            this.cl = new ClassReference("java.awt.event.KeyEvent");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.initMap();
    }

    public int getCharKey(char c) {
        return this.getKeyAndModifiers(c)[0];
    }

    public int getCharModifiers(char c) {
        return this.getKeyAndModifiers(c)[1];
    }

    public int[] getKeyAndModifiers(char c) {
        CharKey key = (CharKey)this.chars.get(new Character(c));
        if (key != null) {
            return new int[]{key.key, key.modifiers};
        }
        return new int[]{0, 0};
    }

    public char[] getSupportedChars() {
        char[] charArray = new char[this.chars.size()];
        Enumeration keys = this.chars.keys();
        int index = 0;
        while (keys.hasMoreElements()) {
            charArray[index] = ((Character)keys.nextElement()).charValue();
        }
        return charArray;
    }

    public void removeChar(char c) {
        this.chars.remove(new Character(c));
    }

    public void addChar(char c, int key, int modifiers) {
        this.chars.put(new Character(c), new CharKey(key, modifiers));
    }

    private void initMap() {
        this.chars = new Hashtable();
        Field[] fields = KeyEvent.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if ((fields[i].getModifiers() & 1) == 0 || (fields[i].getModifiers() & 8) == 0 || fields[i].getType() != Integer.TYPE || !name.startsWith("VK_") || name.length() != 4) continue;
            String latter = name.substring(3, 4);
            try {
                int key = fields[i].getInt(null);
                this.addChar(latter.toLowerCase().charAt(0), key, 0);
                if (latter.toUpperCase().equals(latter.toLowerCase())) continue;
                this.addChar(latter.toUpperCase().charAt(0), key, 1);
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        this.addChar('\t', 9, 0);
        this.addChar(' ', 32, 0);
        this.addChar('!', 49, 1);
        this.addChar('\"', 222, 1);
        this.addChar('#', 51, 1);
        this.addChar('$', 52, 1);
        this.addChar('%', 53, 1);
        this.addChar('&', 55, 1);
        this.addChar('\'', 222, 0);
        this.addChar('(', 57, 1);
        this.addChar(')', 48, 1);
        this.addChar('*', 56, 1);
        this.addChar('+', 61, 1);
        this.addChar(',', 44, 0);
        this.addChar('-', 45, 0);
        this.addChar('.', 46, 0);
        this.addChar('/', 47, 0);
        this.addChar(':', 59, 1);
        this.addChar(';', 59, 0);
        this.addChar('<', 44, 1);
        this.addChar('=', 61, 0);
        this.addChar('>', 46, 1);
        this.addChar('?', 47, 1);
        this.addChar('@', 50, 1);
        this.addChar('[', 91, 0);
        this.addChar('\\', 92, 0);
        this.addChar(']', 93, 0);
        this.addChar('^', 54, 1);
        this.addChar('_', 45, 1);
        this.addChar('`', 192, 0);
        this.addChar('{', 91, 1);
        this.addChar('|', 92, 1);
        this.addChar('}', 93, 1);
        this.addChar('~', 192, 1);
        this.addChar('\n', 10, 0);
    }

    private static class CharKey {
        public int key;
        public int modifiers;

        public CharKey(int key, int modifiers) {
            this.key = key;
            this.modifiers = modifiers;
        }
    }
}

