/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public abstract class IOProxy {
    private static final String FILENAME_PREFIX = "debuggerFifo";
    private static final String FILENAME_EXTENSION = ".fifo";
    private InputWriterThread irt = null;
    private final Reader ioReader;
    private OutputReaderThread ort = null;
    private final Writer ioWriter;

    public static IOProxy create(ExecutionEnvironment execEnv, InputOutput io) {
        IOProxy res = execEnv == null || execEnv.isLocal() ? new LocalIOProxy(io.getIn(), (Writer)io.getOut()) : new RemoteIOProxy(execEnv, io.getIn(), (Writer)io.getOut());
        super.start();
        return res;
    }

    private IOProxy(Reader ioReader, Writer ioWriter) {
        this.ioReader = ioReader;
        this.ioWriter = ioWriter;
    }

    private void start() {
        this.irt = new InputWriterThread();
        this.irt.start();
        this.ort = new OutputReaderThread();
        this.ort.start();
    }

    public void stop() {
        if (this.irt != null) {
            this.irt.cancel();
            try {
                this.ioReader.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.ort != null) {
            this.ort.cancel();
            try {
                this.ioWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    public abstract String getInFilename();

    protected abstract OutputStream createInStream() throws IOException;

    public abstract String getOutFilename();

    protected abstract InputStream createOutStream() throws IOException;

    private static class RemoteIOProxy
    extends IOProxy {
        private final String inFilename;
        private final String outFilename;
        private final ExecutionEnvironment execEnv;

        public RemoteIOProxy(ExecutionEnvironment execEnv, Reader ioReader, Writer ioWriter) {
            super(ioReader, ioWriter);
            this.execEnv = execEnv;
            this.inFilename = RemoteIOProxy.createNewFifo(execEnv);
            this.outFilename = RemoteIOProxy.createNewFifo(execEnv);
        }

        @Override
        public String getInFilename() {
            return this.inFilename;
        }

        @Override
        protected OutputStream createInStream() throws IOException {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            npb.setCommandLine("cat > " + this.inFilename);
            return npb.call().getOutputStream();
        }

        @Override
        public String getOutFilename() {
            return this.outFilename;
        }

        @Override
        protected InputStream createOutStream() throws IOException {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            npb.setCommandLine("cat " + this.outFilename);
            return npb.call().getInputStream();
        }

        private static String createNewFifo(ExecutionEnvironment execEnv) {
            String tmpDir;
            try {
                tmpDir = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv).getTempDir();
            }
            catch (Exception iOException) {
                tmpDir = "/tmp";
            }
            String name = tmpDir + '/' + IOProxy.FILENAME_PREFIX + "$$" + IOProxy.FILENAME_EXTENSION;
            CommandProvider cp = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
            if (cp.run(execEnv, "sh -c \"mkfifo " + name + ";echo " + name + "\"", null) == 0) {
                return cp.getOutput().trim();
            }
            return null;
        }

        @Override
        public void stop() {
            super.stop();
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.inFilename, null);
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.outFilename, null);
        }
    }

    private static class LocalIOProxy
    extends IOProxy {
        private final File inFile = LocalIOProxy.createNewFifo();
        private final File outFile;

        public LocalIOProxy(Reader ioReader, Writer ioWriter) {
            super(ioReader, ioWriter);
            this.inFile.deleteOnExit();
            this.outFile = LocalIOProxy.createNewFifo();
            this.outFile.deleteOnExit();
        }

        private static File createNewFifo() {
            try {
                File file = File.createTempFile(IOProxy.FILENAME_PREFIX, IOProxy.FILENAME_EXTENSION);
                file.delete();
                String tool = "mkfifo";
                if (Utilities.isWindows()) {
                    tool = tool + ".exe";
                    File toolFile = new File(CompilerSetUtils.getCygwinBase() + "/bin", tool);
                    if (toolFile.exists()) {
                        tool = toolFile.getAbsolutePath();
                    } else {
                        toolFile = new File(CompilerSetUtils.getCommandFolder(null), tool);
                        if (toolFile.exists()) {
                            tool = toolFile.getAbsolutePath();
                        }
                    }
                }
                ProcessBuilder pb = new ProcessBuilder(tool, file.getAbsolutePath());
                try {
                    Process p = pb.start();
                    p.waitFor();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return file;
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                return null;
            }
        }

        @Override
        protected OutputStream createInStream() throws IOException {
            return new FileOutputStream(this.inFile);
        }

        @Override
        public String getInFilename() {
            return this.inFile.getAbsolutePath();
        }

        @Override
        protected InputStream createOutStream() throws IOException {
            return new FileInputStream(this.outFile);
        }

        @Override
        public String getOutFilename() {
            return this.outFile.getAbsolutePath();
        }

        @Override
        public void stop() {
            super.stop();
            this.inFile.delete();
            this.outFile.delete();
        }
    }

    private class OutputReaderThread
    extends Thread {
        private boolean cancel = false;

        public OutputReaderThread() {
            this.setName("TTY OutputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream in = null;
            try {
                int read;
                in = IOProxy.this.createOutStream();
                while ((read = in.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    if (read == 10) {
                        IOProxy.this.ioWriter.write("\n");
                        continue;
                    }
                    IOProxy.this.ioWriter.write((char)read);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    IOProxy.this.ioWriter.flush();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }

    private class InputWriterThread
    extends Thread {
        private boolean cancel = false;

        public InputWriterThread() {
            this.setName("TTY InputWriterThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OutputStream pout = null;
            try {
                int ch;
                pout = IOProxy.this.createInStream();
                while ((ch = IOProxy.this.ioReader.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    pout.write((char)ch);
                    pout.flush();
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    pout.flush();
                    pout.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

