/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ActionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AddressBreakpointPanel
extends JPanel
implements Controller,
ControllerProvider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private AddressBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel lAddress;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfAddress;

    private static AddressBreakpoint createBreakpoint() {
        return AddressBreakpoint.create("0x000000");
    }

    public AddressBreakpointPanel() {
        this(AddressBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public AddressBreakpointPanel(AddressBreakpoint b) {
        this.breakpoint = b;
        this.initComponents();
        this.tfAddress.setText(b.getAddress());
        this.conditionsPanel = new ConditionsPanel(b);
        this.pConditions.add(this.conditionsPanel);
        this.actionsPanel = new ActionsPanel(b);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lAddress = new JLabel();
        this.tfAddress = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Function_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 80));
        this.pSettings.setLayout(new GridBagLayout());
        this.lAddress.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_AddressBreakpoint").charAt(0));
        this.lAddress.setLabelFor(this.tfAddress);
        this.lAddress.setText(bundle.getString("L_Address_Breakpoint"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lAddress, gridBagConstraints);
        this.lAddress.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Function_Breakpoint_Function_Name"));
        this.tfAddress.setToolTipText(bundle.getString("TTT_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfAddress, gridBagConstraints);
        this.tfAddress.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        this.tfAddress.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    public boolean ok() {
        String msg = this.valiadateMsg();
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return false;
        }
        this.conditionsPanel.ok();
        this.actionsPanel.ok();
        String address = this.tfAddress.getText().trim();
        this.breakpoint.setAddress(address);
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        Breakpoint[] bs = dm.getBreakpoints();
        int k = bs.length;
        for (int i = 0; i < k; ++i) {
            String condition;
            AddressBreakpoint ab;
            if (!(bs[i] instanceof AddressBreakpoint) || !address.equals((ab = (AddressBreakpoint)bs[i]).getAddress()) || ((condition = this.breakpoint.getCondition()) == null ? ab.getCondition() != null : !condition.equals(ab.getCondition()))) continue;
            if (!ab.isEnabled()) {
                bs[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            dm.addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private String valiadateMsg() {
        String function = this.tfAddress.getText().trim();
        if (function.length() == 0) {
            return NbBundle.getBundle(AddressBreakpointPanel.class).getString("MSG_No_Address_Name_Spec");
        }
        return null;
    }

    @Override
    public Controller getController() {
        return this;
    }
}

