/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.nodes;

import java.awt.Point;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.OutlineOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class OutlineNode {
    private OutlineOperator _outline;
    private TreePath _treePath;

    public OutlineNode(OutlineOperator irOutlineOp, TreePath irTreePath) {
        if (irOutlineOp == null) {
            throw new IllegalArgumentException("OutlineOperator argument cannot be null.");
        }
        if (irTreePath == null) {
            throw new IllegalArgumentException("TreePath argument cannot be null.");
        }
        this._outline = irOutlineOp;
        this._treePath = irTreePath;
    }

    public OutlineNode(OutlineNode irParentNode, String isPath) {
        this._outline = irParentNode.getOutline();
        this._treePath = this.getOutline().findPath(irParentNode.getTreePath(), isPath);
    }

    public OutlineNode(OutlineOperator irOutline, String isPath) {
        this._outline = irOutline;
        this._treePath = this.getOutline().findPath(isPath);
    }

    public OutlineOperator getOutline() {
        return this._outline;
    }

    public TreePath getTreePath() {
        return this._treePath;
    }

    public JPopupMenuOperator callPopup() {
        Point lrPopupPoint = this.getOutline().getLocationForPath(this.getTreePath());
        return new JPopupMenuOperator(this.getOutline().callPopupOnCell(lrPopupPoint.y, lrPopupPoint.x));
    }

    public void expand() {
        this.getOutline().expandPath(this.getTreePath());
        this.getOutline().waitExpanded(this.getTreePath());
    }

    public void select() {
        this.getOutline().selectPath(this.getTreePath());
    }

    public boolean isLeaf() {
        Object lrLastElem = this.getTreePath().getLastPathComponent();
        return this.getOutline().getOutline().getOutlineModel().getChildCount(lrLastElem) < 1;
    }

    public void performMenuAction(String menuPath) {
        new Action(menuPath, null).performMenu(this);
    }

    public void performPopupAction(String popupPath) {
        new Action(null, popupPath).performPopup(this);
    }

    public void performAPIAction(String systemActionClass) {
        new Action(null, null, systemActionClass).performAPI(this);
    }

    public void performMenuActionNoBlock(String menuPath) {
        new ActionNoBlock(menuPath, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String popupPath) {
        new ActionNoBlock(null, popupPath).performPopup(this);
    }

    public void performAPIActionNoBlock(String systemActionClass) {
        new ActionNoBlock(null, null, systemActionClass).performAPI(this);
    }
}

