/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private final File zipFile;
    private ZipOutputStream zipOutputStream;
    private int count;

    public Zipper(File zipFile) throws FileNotFoundException {
        this.zipFile = zipFile;
        this.count = 0;
        this.zipOutputStream = null;
    }

    private ZipOutputStream getZipOutputStream() throws FileNotFoundException {
        if (this.zipOutputStream == null) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFile));
        }
        return this.zipOutputStream;
    }

    public void add(File srcDir, FileFilter filter) throws IOException {
        this.add(srcDir, filter, null);
    }

    public void add(File srcDir, FileFilter filter, String base) throws IOException {
        byte[] readBuf = new byte[32768];
        if (srcDir.isDirectory()) {
            File[] srcFiles;
            for (File file : srcFiles = srcDir.listFiles(filter)) {
                this.addImpl(file, readBuf, base, filter);
            }
        } else {
            this.addImpl(srcDir, readBuf, base, filter);
        }
    }

    public void close() throws IOException {
        if (this.zipOutputStream != null) {
            this.zipOutputStream.close();
        }
    }

    public int getFileCount() {
        return this.count;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void addImpl(File file, byte[] readBuf, String base, FileFilter filter) throws IOException, FileNotFoundException {
        int len;
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles(filter)) {
                String newBase = Zipper.isEmpty(base) ? file.getName() : base + "/" + file.getName();
                this.addImpl(child, readBuf, newBase, filter);
            }
            return;
        }
        ++this.count;
        InputStream in = this.getFileInputStream(file);
        String name = Zipper.isEmpty(base) ? file.getName() : base + '/' + file.getName();
        this.getZipOutputStream().putNextEntry(new ZipEntry(name));
        while ((len = in.read(readBuf)) > 0) {
            this.getZipOutputStream().write(readBuf, 0, len);
        }
        this.getZipOutputStream().closeEntry();
        in.close();
    }

    protected InputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

