/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.RemoteBinaryService;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RemoteBinaryServiceImpl
extends RemoteBinaryService {
    private final Map<ExecutionEnvironment, Delegate> impls = new HashMap<ExecutionEnvironment, Delegate>();
    private static int downloadCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(ExecutionEnvironment execEnv, String remotePath) {
        Delegate delegate;
        CndUtils.assertNonUiThread();
        RemoteBinaryServiceImpl remoteBinaryServiceImpl = this;
        synchronized (remoteBinaryServiceImpl) {
            delegate = this.impls.get(execEnv);
            if (delegate == null) {
                delegate = new Delegate(execEnv);
                this.impls.put(execEnv, delegate);
            }
        }
        try {
            return delegate.getRemoteBinaryImpl(remotePath);
        }
        catch (InterruptedException ex) {
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static int getDownloadCount() {
        return downloadCount;
    }

    static void resetDownloadCount() {
        downloadCount = 0;
    }

    private static class Entry {
        private final String remotePath;
        private final ExecutionEnvironment execEnv;
        private RemoteBinaryService.RemoteBinaryResult lastResult;
        private String timeStamp;

        public Entry(ExecutionEnvironment execEnv, String remotePath) {
            this.remotePath = remotePath;
            this.execEnv = execEnv;
        }

        public RemoteBinaryService.RemoteBinaryResult ensureSync() throws InterruptedException, IOException, ExecutionException {
            String localPath = RemotePathMap.getPathMap(this.execEnv).getLocalPath(this.remotePath, false);
            RemoteBinaryService.RemoteBinaryResult result = null;
            if (localPath != null && RemotePathMap.isTheSame(this.execEnv, new File(this.remotePath).getParentFile().getAbsolutePath(), new File(localPath).getParentFile())) {
                if (this.lastResult == null) {
                    this.lastResult = new RemoteBinaryService.RemoteBinaryResult(localPath, new FutureTask<Boolean>(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return true;
                        }
                    }));
                }
            } else {
                result = this.syncImpl();
                if (result != null) {
                    this.lastResult = result;
                }
            }
            return result == null ? this.lastResult : result;
        }

        private String getFullTimeLsCommand() throws IOException {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
            switch (hostInfo.getOSFamily()) {
                case LINUX: {
                    return "/bin/ls --full-time";
                }
                case MACOSX: {
                    return "/bin/ls -lT";
                }
                case SUNOS: {
                    return "/bin/ls -lE";
                }
                case WINDOWS: {
                    throw new IllegalStateException("Windows in unsupported");
                }
            }
            return "/bin/ls -l";
        }

        private synchronized RemoteBinaryService.RemoteBinaryResult syncImpl() throws IOException, InterruptedException, ExecutionException {
            final String newTimestamp = this.getTimestamp();
            if (this.timeStamp != null && this.timeStamp.equals(newTimestamp) && new File(this.lastResult.localFName).exists()) {
                return this.lastResult;
            }
            final File localFile = File.createTempFile("cnd-remote-binary-", ".bin");
            localFile.deleteOnExit();
            FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean call() throws Exception {
                    String remoteCopyPath;
                    block5: {
                        block4: {
                            Boolean bl;
                            remoteCopyPath = null;
                            try {
                                HostInfo hinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)Entry.this.execEnv);
                                String tmpDir = hinfo.getTempDir();
                                remoteCopyPath = tmpDir + "/binary." + newTimestamp.hashCode();
                                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)Entry.this.execEnv);
                                npb.setExecutable("cp").setArguments(new String[]{Entry.this.remotePath, remoteCopyPath});
                                NativeProcess copyProcess = npb.call();
                                int copyProcessResult = copyProcess.waitFor();
                                if (copyProcessResult == 0) break block4;
                                bl = false;
                                if (remoteCopyPath == null) return bl;
                            }
                            catch (Throwable throwable) {
                                if (remoteCopyPath == null) throw throwable;
                                CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, remoteCopyPath, null);
                                throw throwable;
                            }
                            CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                            return bl;
                        }
                        Future task = CommonTasksSupport.downloadFile((String)remoteCopyPath, (ExecutionEnvironment)Entry.this.execEnv, (String)localFile.getAbsolutePath(), null);
                        if ((Integer)task.get() == 0) break block5;
                        Boolean bl = false;
                        if (remoteCopyPath == null) return bl;
                        CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                        return bl;
                    }
                    Entry.this.timeStamp = newTimestamp;
                    downloadCount++;
                    if (remoteCopyPath == null) return true;
                    CommonTasksSupport.rmFile((ExecutionEnvironment)Entry.this.execEnv, (String)remoteCopyPath, null);
                    return true;
                }
            });
            RequestProcessor.getDefault().post(task);
            return new RemoteBinaryService.RemoteBinaryResult(localFile.getAbsolutePath(), task);
        }

        private String getTimestamp() {
            try {
                String command = this.getFullTimeLsCommand() + " \"" + this.remotePath + "\"";
                RemoteCommandSupport rcs = new RemoteCommandSupport(this.execEnv, command);
                if (rcs.run() == 0) {
                    return rcs.getOutput();
                }
                throw new IOException("Cannot run #" + command);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }

    private static class Delegate {
        private final ExecutionEnvironment execEnv;
        private final Map<String, Entry> cache = new HashMap<String, Entry>();

        public Delegate(ExecutionEnvironment execEnv) {
            this.execEnv = execEnv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteBinaryService.RemoteBinaryResult getRemoteBinaryImpl(String remotePath) throws InterruptedException, IOException, ExecutionException {
            Entry entry;
            Delegate delegate = this;
            synchronized (delegate) {
                entry = this.cache.get(remotePath);
                if (entry == null) {
                    entry = new Entry(this.execEnv, remotePath);
                    this.cache.put(remotePath, entry);
                }
            }
            return entry.ensureSync();
        }
    }
}

