/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.client.AppClientMetadata;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public abstract class CommonBeanReader {
    protected String propertyName;
    private static WeakHashMap<String, Method> methodMap = new WeakHashMap();

    protected void addMapString(Map<String, Object> map, String string, String string2) {
        if (Utils.notEmpty(string2)) {
            map.put(string, string2);
        }
    }

    public CommonBeanReader(String string) {
        this.propertyName = string;
    }

    public Map<String, Object> readDescriptor(CommonDDBean commonDDBean) {
        Map<String, Object> map = null;
        try {
            Object object;
            commonDDBean = this.normalizeParent(commonDDBean);
            Object object2 = object = commonDDBean != null ? CommonBeanReader.getChild(commonDDBean, this.propertyName) : null;
            if (object != null && object.getClass().isArray() && object instanceof CommonDDBean[]) {
                map = this.genProperties((CommonDDBean[])object);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return map;
    }

    public Map<String, Object> readAnnotations(DataObject dataObject) {
        Map<String, Object> map = null;
        try {
            J2eeModule j2eeModule;
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            GlassfishConfiguration glassfishConfiguration = GlassfishConfiguration.getConfiguration((File)file);
            if (glassfishConfiguration != null && (j2eeModule = glassfishConfiguration.getJ2eeModule()) != null) {
                if (J2eeModule.Type.WAR == j2eeModule.getType()) {
                    map = this.readWebAppMetadata((MetadataModel<WebAppMetadata>)j2eeModule.getMetadataModel(WebAppMetadata.class));
                } else if (J2eeModule.Type.EJB == j2eeModule.getType()) {
                    map = this.readEjbJarMetadata((MetadataModel<EjbJarMetadata>)j2eeModule.getMetadataModel(EjbJarMetadata.class));
                } else if (J2eeModule.Type.CAR == j2eeModule.getType()) {
                    map = this.readAppClientMetadata((MetadataModel<AppClientMetadata>)j2eeModule.getMetadataModel(AppClientMetadata.class));
                }
            }
        }
        catch (MetadataModelException metadataModelException) {
            ErrorManager.getDefault().notify(1, (Throwable)metadataModelException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return map;
    }

    protected abstract Map<String, Object> genProperties(CommonDDBean[] var1);

    protected CommonDDBean normalizeParent(CommonDDBean commonDDBean) {
        return commonDDBean;
    }

    protected CommonDDBean findEjbByName(EjbJar ejbJar, String string) {
        CommonDDBean commonDDBean = null;
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            commonDDBean = this.findEjbByName((Ejb[])enterpriseBeans.getSession(), string);
            if (commonDDBean == null) {
                commonDDBean = this.findEjbByName((Ejb[])enterpriseBeans.getMessageDriven(), string);
            }
            if (commonDDBean == null) {
                commonDDBean = this.findEjbByName((Ejb[])enterpriseBeans.getEntity(), string);
            }
        }
        return commonDDBean;
    }

    protected CommonDDBean findEjbByName(Ejb[] ejbArray, String string) {
        Ejb ejb = null;
        if (ejbArray != null) {
            for (Ejb ejb2 : ejbArray) {
                if (!string.equals(ejb2.getEjbName())) continue;
                ejb = ejb2;
                break;
            }
        }
        return ejb;
    }

    public Map<String, Object> readWebAppMetadata(MetadataModel<WebAppMetadata> metadataModel) throws MetadataModelException, IOException {
        return (Map)metadataModel.runReadAction((MetadataModelAction)new WebAppCommonReader());
    }

    public Map<String, Object> readAppClientMetadata(MetadataModel<AppClientMetadata> metadataModel) throws MetadataModelException, IOException {
        return (Map)metadataModel.runReadAction((MetadataModelAction)new AppClientCommonReader());
    }

    public Map<String, Object> readEjbJarMetadata(MetadataModel<EjbJarMetadata> metadataModel) throws MetadataModelException, IOException {
        return (Map)metadataModel.runReadAction((MetadataModelAction)new EjbJarCommonReader());
    }

    public Map<String, Object> readWebservicesMetadata(MetadataModel<WebservicesMetadata> metadataModel) throws MetadataModelException, IOException {
        return (Map)metadataModel.runReadAction((MetadataModelAction)new WebservicesCommonReader());
    }

    private static Object getChild(CommonDDBean commonDDBean, String string) {
        Object object = null;
        try {
            String string2 = "get" + string;
            Class<?> clazz = commonDDBean.getClass();
            String string3 = clazz.getName() + string2;
            Method method = methodMap.get(string3);
            if (method == null) {
                method = clazz.getMethod(string2, new Class[0]);
                methodMap.put(string3, method);
            }
            object = method.invoke((Object)commonDDBean, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof UnsupportedOperationException) {
                ErrorManager.getDefault().log(16, "!!!" + commonDDBean.getClass().getName() + ".get" + string + " is not supported by metamodel yet.");
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return object;
    }

    public class CommonReader {
        public Map<String, Object> genCommonProperties(CommonDDBean commonDDBean) {
            Object object;
            Map<String, Object> map = null;
            CommonDDBean commonDDBean2 = CommonBeanReader.this.normalizeParent(commonDDBean);
            if (commonDDBean2 != null && (object = CommonBeanReader.getChild(commonDDBean2, CommonBeanReader.this.propertyName)) != null && object.getClass().isArray() && object instanceof CommonDDBean[]) {
                map = CommonBeanReader.this.genProperties((CommonDDBean[])object);
            }
            return map;
        }
    }

    public class WebservicesCommonReader
    extends CommonReader
    implements MetadataModelAction<WebservicesMetadata, Map<String, Object>> {
        public Map<String, Object> run(WebservicesMetadata webservicesMetadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)webservicesMetadata.getRoot());
        }
    }

    public class EjbJarCommonReader
    extends CommonReader
    implements MetadataModelAction<EjbJarMetadata, Map<String, Object>> {
        public Map<String, Object> run(EjbJarMetadata ejbJarMetadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)ejbJarMetadata.getRoot());
        }
    }

    public class AppClientCommonReader
    extends CommonReader
    implements MetadataModelAction<AppClientMetadata, Map<String, Object>> {
        public Map<String, Object> run(AppClientMetadata appClientMetadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)appClientMetadata.getRoot());
        }
    }

    public class WebAppCommonReader
    extends CommonReader
    implements MetadataModelAction<WebAppMetadata, Map<String, Object>> {
        public Map<String, Object> run(WebAppMetadata webAppMetadata) throws Exception {
            return this.genCommonProperties((CommonDDBean)webAppMetadata.getRoot());
        }
    }
}

