/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.codegen.ui.GetterSetterPanel;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GetterSetterGenerator
implements CodeGenerator {
    private final JTextComponent component;
    private final ElementNode.Description description;
    private final GeneratorUtils.Kind type;
    private final CsmContext contextPath;
    private final boolean isUpperCase;

    private GetterSetterGenerator(JTextComponent component, CsmContext path, ElementNode.Description description, GeneratorUtils.Kind type, boolean isUpperCase) {
        this.component = component;
        this.contextPath = path;
        this.description = description;
        this.type = type;
        this.isUpperCase = isUpperCase;
    }

    public String getDisplayName() {
        if (this.type == GeneratorUtils.Kind.GETTERS_ONLY) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter");
        }
        if (this.type == GeneratorUtils.Kind.SETTERS_ONLY) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_setter");
        }
        return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter_and_setter");
    }

    public void invoke() {
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"GENERATE", "GETTER_SETTER"});
        GetterSetterPanel panel = new GetterSetterPanel(this.description, this.type);
        String title = GeneratorUtils.getGetterSetterDisplayName(this.type);
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, title);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue()) {
            GeneratorUtils.generateGettersAndSetters(this.contextPath, panel.getVariables(), panel.isMethodInline(), this.type, this.isUpperCase);
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        private static final String ERROR = "<error>";

        public List<? extends CodeGenerator> create(Lookup context) {
            List<ElementNode.Description> descriptions;
            ArrayList<GetterSetterGenerator> ret = new ArrayList<GetterSetterGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CsmContext path = (CsmContext)context.lookup(CsmContext.class);
            if (component == null || path == null) {
                return ret;
            }
            CsmClass typeElement = path.getEnclosingClass();
            if (typeElement == null) {
                return ret;
            }
            CsmOffsetable objectUnderOffset = path.getObjectUnderOffset();
            HashMap<String, List<CsmMethod>> methods = new HashMap<String, List<CsmMethod>>();
            LinkedHashMap<CsmClass, List<ElementNode.Description>> gDescriptions = new LinkedHashMap<CsmClass, List<ElementNode.Description>>();
            LinkedHashMap<CsmClass, List<ElementNode.Description>> sDescriptions = new LinkedHashMap<CsmClass, List<ElementNode.Description>>();
            LinkedHashMap<CsmClass, List<ElementNode.Description>> gsDescriptions = new LinkedHashMap<CsmClass, List<ElementNode.Description>>();
            Boolean isUpperCase = null;
            for (CsmMember member : GeneratorUtils.getAllMembers(typeElement)) {
                if (!CsmKindUtilities.isMethod((CsmObject)member)) continue;
                CsmMethod method = (CsmMethod)member;
                String name = ((Object)method.getName()).toString();
                ArrayList<CsmMethod> l = (ArrayList<CsmMethod>)methods.get(name);
                if (l == null) {
                    l = new ArrayList<CsmMethod>();
                    methods.put(((Object)method.getName()).toString(), l);
                }
                l.add(method);
                if (isUpperCase != null) continue;
                isUpperCase = GeneratorUtils.checkStartWithUpperCase(method);
            }
            isUpperCase = isUpperCase != null ? isUpperCase : Boolean.TRUE;
            ElementNode.Description theFirstDescription = null;
            for (CsmMember member : GeneratorUtils.getAllMembers(typeElement)) {
                List<ElementNode.Description> descriptions2;
                boolean hasSetter;
                if (!CsmKindUtilities.isField((CsmObject)member)) continue;
                CsmField variableElement = (CsmField)member;
                ElementNode.Description description = ElementNode.Description.create((CsmObject)variableElement, null, (boolean)true, (boolean)variableElement.equals(objectUnderOffset));
                if (theFirstDescription == null) {
                    theFirstDescription = description;
                }
                boolean hasGetter = GeneratorUtils.hasGetter(variableElement, methods, isUpperCase);
                boolean bl = hasSetter = GeneratorUtils.isConstant((CsmVariable)variableElement) || GeneratorUtils.hasSetter(variableElement, methods, isUpperCase);
                if (!hasGetter) {
                    descriptions2 = (ArrayList<ElementNode.Description>)gDescriptions.get(variableElement.getContainingClass());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList<ElementNode.Description>();
                        gDescriptions.put(variableElement.getContainingClass(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (!hasSetter) {
                    descriptions2 = (List)sDescriptions.get(variableElement.getContainingClass());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList();
                        sDescriptions.put(variableElement.getContainingClass(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (hasGetter || hasSetter) continue;
                descriptions2 = (List)gsDescriptions.get(variableElement.getContainingClass());
                if (descriptions2 == null) {
                    descriptions2 = new ArrayList();
                    gsDescriptions.put(variableElement.getContainingClass(), descriptions2);
                }
                descriptions2.add(description);
            }
            if (!gDescriptions.isEmpty()) {
                descriptions = this.prepareDescriptions(gDescriptions);
                ret.add(new GetterSetterGenerator(component, path, ElementNode.Description.create((CsmObject)typeElement, descriptions, (boolean)false, (boolean)false), GeneratorUtils.Kind.GETTERS_ONLY, isUpperCase));
            }
            if (!sDescriptions.isEmpty()) {
                descriptions = this.prepareDescriptions(sDescriptions);
                ret.add(new GetterSetterGenerator(component, path, ElementNode.Description.create((CsmObject)typeElement, descriptions, (boolean)false, (boolean)false), GeneratorUtils.Kind.SETTERS_ONLY, isUpperCase));
            }
            if (!gsDescriptions.isEmpty()) {
                descriptions = this.prepareDescriptions(gsDescriptions);
                ret.add(new GetterSetterGenerator(component, path, ElementNode.Description.create((CsmObject)typeElement, descriptions, (boolean)false, (boolean)false), GeneratorUtils.Kind.GETTERS_SETTERS, isUpperCase));
            }
            return ret;
        }

        private List<ElementNode.Description> prepareDescriptions(Map<CsmClass, List<ElementNode.Description>> descripti) {
            boolean selectIfOnlyOne = descripti.size() == 1;
            ArrayList<ElementNode.Description> out = new ArrayList<ElementNode.Description>();
            for (Map.Entry<CsmClass, List<ElementNode.Description>> entry : descripti.entrySet()) {
                List<ElementNode.Description> values = entry.getValue();
                if (selectIfOnlyOne && values.size() == 1) {
                    ElementNode.Description orig = values.get(0);
                    values = new ArrayList<ElementNode.Description>(1);
                    values.add(ElementNode.Description.create((CsmObject)orig.getElementHandle(), null, (boolean)true, (boolean)true));
                }
                out.add(ElementNode.Description.create((CsmObject)((CsmObject)entry.getKey()), values, (boolean)false, (boolean)false));
            }
            Collections.reverse(out);
            return out;
        }
    }
}

