/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceFieldPanel
extends JPanel {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private int[] allowInitMethods;
    private Set<String> takenNames;
    private JButton btnOk;
    private ButtonGroup accessGroup;
    private JLabel errLabel;
    private JRadioButton initConstructors;
    private JRadioButton initField;
    private JRadioButton initMethod;
    private ButtonGroup initilizeIn;
    private JLabel lblInitializeIn;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;
    private String fieldNameTest;
    private Integer initializeInTest;
    private Boolean replaceAllTest;

    public IntroduceFieldPanel(String name, int[] allowInitMethods, int numOccurrences, JButton btnOk, Set<String> takenNames) {
        this.btnOk = btnOk;
        this.takenNames = takenNames;
        this.initComponents();
        this.name.setText(name);
        if (name != null && name.trim().length() > 0) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
        this.allowInitMethods = allowInitMethods;
        this.replaceAll.setEnabled(numOccurrences > 1);
        Preferences pref = this.getPreferences();
        if (numOccurrences == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + numOccurrences + ")");
            this.replaceAll.setSelected(pref.getBoolean("replaceAll", true));
        }
        this.replaceAll.setVisible(false);
        boolean allowInitializationLocation = false;
        if (allowInitializationLocation) {
            int init = pref.getInt("initMethod", 1);
            switch (init) {
                case 2: {
                    this.initField.setSelected(true);
                    break;
                }
                case 4: {
                    this.initConstructors.setSelected(true);
                    break;
                }
                case 1: {
                    this.initMethod.setSelected(true);
                }
            }
            this.adjustInitializeIn();
        } else {
            this.lblInitializeIn.setVisible(false);
            this.initMethod.setVisible(false);
            this.initField.setVisible(false);
            this.initConstructors.setVisible(false);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    private void adjustInitializeIn() {
        int allowMethods = this.allowInitMethods[this.replaceAll.isSelected() ? 1 : 0];
        this.initMethod.setEnabled((allowMethods & 1) != 0);
        this.initField.setEnabled((allowMethods & 2) != 0);
        this.initConstructors.setEnabled((allowMethods & 4) != 0);
        if (!this.initMethod.isEnabled() && this.initMethod.isSelected()) {
            if (this.initField.isEnabled()) {
                this.initField.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initField.isEnabled() && this.initField.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initConstructors.setSelected(true);
            }
        } else if (!this.initConstructors.isEnabled() && this.initConstructors.isSelected()) {
            if (this.initMethod.isEnabled()) {
                this.initMethod.setSelected(true);
            } else {
                this.initField.setSelected(true);
            }
        }
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyIdentifier((String)text)) {
                    return IntroduceFieldPanel.this.getDefaultErrorMessage(text);
                }
                if (IntroduceFieldPanel.this.takenNames.contains(text)) {
                    return NbBundle.getMessage(IntroduceFieldPanel.class, (String)"FieldAlreadyExists", (Object)text);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceFieldPanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return NbBundle.getMessage(IntroduceFieldPanel.class, (String)"NotValidIdentifier", (Object)inputText);
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.lblInitializeIn = new JLabel();
        this.initMethod = new JRadioButton();
        this.initField = new JRadioButton();
        this.initConstructors = new JRadioButton();
        this.errLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        this.replaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceFieldPanel.this.replaceAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblInitializeIn, (String)NbBundle.getMessage(IntroduceFieldPanel.class, (String)"IntroduceFieldPanel.lblInitializeIn.text"));
        this.initilizeIn.add(this.initMethod);
        this.initMethod.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.initMethod, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_CurrentMethod"));
        this.initMethod.setMargin(new Insets(0, 0, 0, 0));
        this.initilizeIn.add(this.initField);
        Mnemonics.setLocalizedText((AbstractButton)this.initField, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Field"));
        this.initField.setMargin(new Insets(0, 0, 0, 0));
        this.initilizeIn.add(this.initConstructors);
        Mnemonics.setLocalizedText((AbstractButton)this.initConstructors, (String)NbBundle.getBundle(IntroduceFieldPanel.class).getString("LBL_Constructors"));
        this.initConstructors.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.errLabel, -1, 494, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblName).add(29, 29, 29).add((Component)this.name, -1, 425, Short.MAX_VALUE)).add((Component)this.replaceAll).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblInitializeIn).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.initField).add((Component)this.initMethod).add((Component)this.initConstructors)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.name, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(1).add((Component)this.replaceAll).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lblInitializeIn).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.initMethod).addPreferredGap(0).add((Component)this.initField))).addPreferredGap(0).add((Component)this.initConstructors).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.errLabel).addContainerGap()));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_ReplaceAllOccurences"));
        this.initMethod.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_CurrentMethod"));
        this.initField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Field"));
        this.initConstructors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Constructors"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceFieldPanel.class, (String)"AD_IntrFld_Dialog"));
    }

    private void replaceAllActionPerformed(ActionEvent evt) {
        this.adjustInitializeIn();
    }

    public String getFieldName() {
        if (this.fieldNameTest != null) {
            return this.fieldNameTest;
        }
        return this.name.getText();
    }

    public int getInitializeIn() {
        int ret;
        if (this.initializeInTest != null) {
            return this.initializeInTest;
        }
        if (this.initMethod.isSelected()) {
            ret = 1;
        } else if (this.initField.isSelected()) {
            ret = 2;
        } else if (this.initConstructors.isSelected()) {
            ret = 4;
        } else {
            throw new IllegalStateException();
        }
        this.getPreferences().putInt("initMethod", ret);
        return ret;
    }

    public boolean isReplaceAll() {
        if (this.replaceAllTest != null) {
            return this.replaceAllTest;
        }
        boolean ret = this.replaceAll.isSelected();
        this.getPreferences().putBoolean("replaceAll", ret);
        return ret;
    }

    void setFieldName(String fieldName) {
        this.fieldNameTest = fieldName;
    }

    void setInitializeIn(Integer initializeIn) {
        this.initializeInTest = initializeIn;
    }

    void setReplaceAll(Boolean replaceAll) {
        this.replaceAllTest = replaceAll;
    }
}

