/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.WhenNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.RubyHints;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ColonToThen
extends RubyAstRule {
    private static final int INSERT_THEN = 1;
    private static final int INSERT_NEWLINE = 2;
    private static final int INSERT_SEMICOLON = 3;

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.WHENNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        WhenNode when = (WhenNode)node;
        Node body = when.getBodyNode();
        if (RubyHints.isNullOrInvisible(body)) {
            return;
        }
        BaseDocument doc = context.doc;
        try {
            int astWhenStart = when.getPosition().getStartOffset();
            int astBodyStart = body.getPosition().getStartOffset();
            int lexWhenStart = LexUtilities.getLexerOffset((Parser.Result)info, (int)astWhenStart);
            int lexBodyStart = LexUtilities.getLexerOffset((Parser.Result)info, (int)astBodyStart);
            if (lexWhenStart == -1 || lexBodyStart == -1) {
                return;
            }
            int docLength = doc.getLength();
            if (lexWhenStart > docLength || lexBodyStart > docLength) {
                return;
            }
            if (Utilities.getRowEnd((BaseDocument)doc, (int)lexBodyStart) != Utilities.getRowEnd((BaseDocument)doc, (int)lexWhenStart)) {
                return;
            }
            int offset = -1;
            try {
                doc.readLock();
                TokenSequence ts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, (int)lexBodyStart);
                if (ts == null) {
                    return;
                }
                ts.move(lexBodyStart);
                while (ts.movePrevious()) {
                    Token token = ts.token();
                    TokenId id = token.id();
                    if (id == RubyTokenId.WHITESPACE) continue;
                    if (id == RubyTokenId.NONUNARY_OP) {
                        String s = ((Object)token.text()).toString();
                        if (":".equals(s)) {
                            offset = ts.offset();
                            break;
                        }
                        return;
                    }
                    return;
                }
            }
            finally {
                doc.readUnlock();
            }
            if (offset == -1) {
                return;
            }
            OffsetRange range = new OffsetRange(offset, offset + 1);
            String displayName = NbBundle.getMessage(ColonToThen.class, (String)"ColonToThenGutter");
            ArrayList<ColonFix> fixes = new ArrayList<ColonFix>(3);
            fixes.add(new ColonFix(doc, offset, 1));
            fixes.add(new ColonFix(doc, offset, 3));
            fixes.add(new ColonFix(doc, offset, 2));
            Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 150);
            result.add(desc);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getId() {
        return "ColonToThen";
    }

    public String getDescription() {
        return NbBundle.getMessage(ColonToThen.class, (String)"ColonToThenDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ColonToThen.class, (String)"ColonToThen");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class ColonFix
    implements PreviewableFix {
        private BaseDocument doc;
        private int offset;
        private int mode;

        public ColonFix(BaseDocument doc, int offset, int mode) {
            this.doc = doc;
            this.offset = offset;
            this.mode = mode;
        }

        public String getDescription() {
            switch (this.mode) {
                case 3: {
                    return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFixSemi");
                }
                case 1: {
                    return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFix");
                }
            }
            return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFixNewline");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            EditList list = new EditList(this.doc);
            switch (this.mode) {
                case 2: {
                    list.setFormatAll(false);
                    list.replace(this.offset, 1, "\n", true, 0);
                    break;
                }
                case 1: {
                    String s = this.doc.getText(this.offset, 3);
                    StringBuilder sb = new StringBuilder();
                    if (!Character.isWhitespace(this.doc.getText(this.offset - 1, 1).charAt(0))) {
                        sb.append(' ');
                    }
                    sb.append("then");
                    if (this.offset < this.doc.getLength() - 2 && !Character.isWhitespace(this.doc.getText(this.offset + 1, 1).charAt(0))) {
                        sb.append(' ');
                    }
                    list.replace(this.offset, 1, sb.toString(), false, 0);
                    break;
                }
                case 3: {
                    list.replace(this.offset, 1, ";", false, 0);
                }
            }
            return list;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

