/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class XMLCompletionProvider
implements CompletionProvider {
    private static final boolean ENABLED = true;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        SyntaxSupport support = Utilities.getDocument((JTextComponent)component).getSyntaxSupport();
        if (support == null || !(support instanceof XMLSyntaxSupport)) {
            return 0;
        }
        int type = ((XMLSyntaxSupport)support).checkCompletion(component, typedText, false);
        if (type == 0) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1 || queryType == 9) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        XMLSyntaxSupport sup = (XMLSyntaxSupport)doc.getSyntaxSupport().get(XMLSyntaxSupport.class);
        try {
            TokenItem ti = sup.getTokenChain(caretOffset <= 0 ? 0 : caretOffset - 1, caretOffset);
            if (ti != null && ti.getTokenID() == XMLDefaultTokenContext.TEXT && !ti.getImage().startsWith("<") && !ti.getImage().startsWith("&")) {
                XMLCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
    }

    static class Query
    extends AsyncCompletionQuery {
        private static final XMLCompletionQuery QUERY = new XMLCompletionQuery();
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            XMLSyntaxSupport support;
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.component);
            XMLSyntaxSupport xMLSyntaxSupport = support = syntaxSupport instanceof XMLSyntaxSupport ? (XMLSyntaxSupport)syntaxSupport : null;
            if (support == null) {
                resultSet.finish();
                return;
            }
            List<CompletionItem> items = QUERY.query(this.component, caretOffset, (SyntaxSupport)support);
            if (items != null) {
                resultSet.addAllItems(items);
            }
            resultSet.finish();
        }
    }
}

