/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class DatasourceCustomizer
extends JPanel {
    private static final ResourceBundle bundle = NbBundle.getBundle(DatasourceCustomizer.class);
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private boolean dialogOK = false;
    private HashMap<String, Datasource> datasources;
    private String jndiName;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private JComboBox connCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jndiNameField;

    public DatasourceCustomizer(List<Datasource> list) {
        if (list != null) {
            this.datasources = new HashMap();
            for (Datasource datasource : list) {
                if (datasource.getJndiName() == null) continue;
                this.datasources.put(datasource.getJndiName(), datasource);
            }
        }
        this.initComponents();
        DatabaseExplorerUIs.connect((JComboBox)this.connCombo, (ConnectionManager)ConnectionManager.getDefault());
        this.connCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatasourceCustomizer.this.verify();
            }
        });
        this.jndiNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }
        });
    }

    public boolean showDialog() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DatasourceCustomizer"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(DatasourceCustomizer.class), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (DatasourceCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    boolean bl2;
                    bl = bl2 = DatasourceCustomizer.this.handleConfirmation();
                    DatasourceCustomizer.this.dialogOK = bl2;
                }
                if (bl) {
                    DatasourceCustomizer.this.dialog.dispose();
                }
            }
        });
        this.descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        this.statusLine = this.descriptor.createNotificationLineSupport();
        this.verify();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private boolean handleConfirmation() {
        this.jndiName = this.jndiNameField.getText().trim();
        DatabaseConnection databaseConnection = (DatabaseConnection)this.connCombo.getSelectedItem();
        if (databaseConnection.getPassword() == null) {
            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
        }
        if (databaseConnection.getPassword() == null) {
            this.statusLine.setErrorMessage(bundle.getString("ERR_NoPassword"));
            return false;
        }
        this.url = databaseConnection.getDatabaseURL();
        this.username = databaseConnection.getUser();
        this.password = databaseConnection.getPassword();
        this.driverClassName = databaseConnection.getDriverClass();
        return true;
    }

    private boolean verify() {
        boolean bl = this.verifyJndiName();
        if (bl) {
            bl = this.verifyConnection();
        }
        return bl;
    }

    private boolean verifyJndiName() {
        boolean bl = true;
        String string = this.jndiNameField.getText().trim();
        if (string.length() == 0) {
            this.statusLine.setInformationMessage(bundle.getString("ERR_JNDI_NAME_EMPTY"));
            bl = false;
        } else if (this.datasourceAlreadyExists(string)) {
            this.statusLine.setErrorMessage(bundle.getString("ERR_DS_EXISTS"));
            bl = false;
        } else {
            this.statusLine.clearMessages();
        }
        this.descriptor.setValid(bl);
        return bl;
    }

    private boolean verifyConnection() {
        boolean bl = true;
        if (!(this.connCombo.getSelectedItem() instanceof DatabaseConnection)) {
            this.statusLine.setInformationMessage(bundle.getString("ERR_NO_CONN_SELECTED"));
            bl = false;
        } else {
            this.statusLine.clearMessages();
        }
        this.descriptor.setValid(bl);
        return bl;
    }

    private boolean datasourceAlreadyExists(String string) {
        return this.datasources.containsKey(string);
    }

    String getJndiName() {
        return this.jndiName;
    }

    String getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDriverClassName() {
        return this.driverClassName;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jndiNameField = new JTextField();
        this.connCombo = new JComboBox();
        this.setForeground(new Color(255, 0, 0));
        this.jLabel1.setLabelFor(this.jndiNameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_JndiName"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_DbConn"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jndiNameField, -1, 327, Short.MAX_VALUE).add((Component)this.connCombo, 0, 327, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jndiNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.connCombo, -2, -1, -2).addContainerGap()))));
    }
}

