/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.Component;
import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.AppletXMLRefactoringSupport;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.templates.ClassicAppletDeploymentVisualPanel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClassicAppletDeploymentWizardPanel
implements WizardDescriptor.Panel {
    public static final String PROP_APPLET_NAME = "appletName";
    WizardDescriptor wizard;
    Collection<String> allAppletAIDs;
    private ClassicAppletDeploymentVisualPanel component;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public ClassicAppletDeploymentWizardPanel(WizardDescriptor wizard) {
        ProjectKind kind;
        this.wizard = wizard;
        Project p = Templates.getProject((WizardDescriptor)wizard);
        final JCProject jcProject = (JCProject)p.getLookup().lookup(JCProject.class);
        ProjectKind projectKind = kind = jcProject == null ? null : jcProject.kind();
        if (kind == ProjectKind.CLASSIC_APPLET) {
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    FileObject webObj = jcProject.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
                    AppletXMLRefactoringSupport web = AppletXMLRefactoringSupport.fromFile(FileUtil.toFile((FileObject)webObj));
                    ClassicAppletDeploymentWizardPanel.this.allAppletAIDs = web.getAllAppletAIDs();
                }
            });
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ClassicAppletDeploymentVisualPanel(this);
        }
        return this.component;
    }

    public void setClassName(String className) {
        this.component.setClassName(className);
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        String aid = this.component.getAppletAID();
        if (aid != null && this.allAppletAIDs != null && this.allAppletAIDs.contains(aid)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ClassicAppletDeploymentWizardPanel.class, (String)"ERR_AID_EXISTS"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        String pkg = ClassicAppletDeploymentWizardPanel.findPackageNameFromWizard(wiz);
        String classname = pkg == null ? Templates.getTargetName((WizardDescriptor)wiz) : pkg + '.' + Templates.getTargetName((WizardDescriptor)wiz);
        this.component.setClassName(classname);
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        if (this.component.isAddInfoSelected()) {
            wiz.putProperty(PROP_APPLET_NAME, (Object)this.component.getAppletAID());
        }
        if (this.component.shouldCreateScript()) {
            wiz.putProperty("_createscript_", (Object)"true");
        } else {
            wiz.putProperty("_createscript_", (Object)"false");
        }
        if (this.component.shouldCreateInstance()) {
            wiz.putProperty("_createinstance_", (Object)"true");
        } else {
            wiz.putProperty("_createinstance_", (Object)"false");
        }
    }

    void setProblem(String problem) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)problem);
    }

    static String findPackageNameFromWizard(WizardDescriptor wiz) {
        ClassPathProvider p;
        ClassPath cp;
        FileObject root;
        Object path = wiz.getProperty("folderToDelete");
        FileObject target = path instanceof FileObject ? (FileObject)path : Templates.getTargetFolder((WizardDescriptor)wiz);
        Project project = (Project)wiz.getProperty("project");
        if (target != null && project != null && (root = (cp = (p = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class)).findClassPath(target, "classpath/source")).findOwnerRoot(target)) != null) {
            String relpath = FileUtil.getRelativePath((FileObject)root, (FileObject)target).replace('/', '.');
            return relpath;
        }
        return null;
    }
}

