/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.AbstractTypeProcessor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import org.openide.util.NbBundle;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"netbeans_private_enable_javacard_processor"})
public final class JavaCardErrorProcessor
extends AbstractTypeProcessor {
    static final String JAVACARD_OPTION = "netbeans_private_enable_javacard_processor";
    private static final Set<TypeKind> UNSUPPORTED_PRIMITIVES_CLASSIC_PROJECTS = EnumSet.of(TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.LONG, TypeKind.CHAR);
    private static final Set<TypeKind> UNSUPPORTED_PRIMITIVES_EXTENDED_PROJECTS = EnumSet.of(TypeKind.DOUBLE, TypeKind.FLOAT);
    private static final Set<Tree.Kind> UNSUPPORTED_LITERALS_CLASSIC_PROJECTS = EnumSet.of(Tree.Kind.STRING_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.LONG_LITERAL);
    private static final Set<Tree.Kind> UNSUPPORTED_LITERALS_EXTENDED_PROJECTS = EnumSet.of(Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL);
    private ProcessingEnvironment env;

    public void init(ProcessingEnvironment env) {
        this.env = env;
    }

    public void typeProcess(TypeElement te, TreePath tp) {
        Map<String, String> m = this.env.getOptions();
        boolean containsKey = m.containsKey(JAVACARD_OPTION);
        if (containsKey) {
            boolean classic = Boolean.valueOf(m.get(JAVACARD_OPTION));
            new ScannerImpl(this.env).scan(tp, Boolean.valueOf(classic));
        }
    }

    private static final class ScannerImpl
    extends TreePathScanner<Void, Boolean> {
        private final ProcessingEnvironment env;

        ScannerImpl(ProcessingEnvironment env) {
            this.env = env;
        }

        @Override
        public Void visitPrimitiveType(PrimitiveTypeTree node, Boolean classic) {
            TypeKind kind;
            Set unsupported = classic != false ? UNSUPPORTED_PRIMITIVES_CLASSIC_PROJECTS : UNSUPPORTED_PRIMITIVES_EXTENDED_PROJECTS;
            if (unsupported.contains((Object)(kind = node.getPrimitiveTypeKind()))) {
                String kindName = NbBundle.getMessage(JavaCardErrorProcessor.class, (String)kind.name());
                Trees.instance(this.env).printMessage(Diagnostic.Kind.ERROR, NbBundle.getMessage(JavaCardErrorProcessor.class, (String)(classic != false ? "ERR_CLASSIC" : "ERR_EXT"), (Object)kindName), node, this.getCurrentPath().getCompilationUnit());
            }
            return (Void)super.visitPrimitiveType(node, classic);
        }

        @Override
        public Void visitLiteral(LiteralTree node, Boolean classic) {
            Set unsupported;
            Tree.Kind kind = node.getKind();
            Set set = unsupported = classic != false ? UNSUPPORTED_LITERALS_CLASSIC_PROJECTS : UNSUPPORTED_LITERALS_EXTENDED_PROJECTS;
            if (unsupported.contains((Object)node.getKind())) {
                String kindName = NbBundle.getMessage(JavaCardErrorProcessor.class, (String)kind.name());
                Trees.instance(this.env).printMessage(Diagnostic.Kind.ERROR, NbBundle.getMessage(JavaCardErrorProcessor.class, (String)(classic != false ? "LIT_ERR_CLASSIC" : "LIT_ERR_EXT"), (Object)kindName), node, this.getCurrentPath().getCompilationUnit());
            }
            return (Void)super.visitLiteral(node, classic);
        }

        @Override
        public Void visitMethod(MethodTree node, Boolean p) {
            if (node.getModifiers().getFlags().contains((Object)Modifier.STRICTFP)) {
                Trees.instance(this.env).printMessage(Diagnostic.Kind.ERROR, NbBundle.getMessage(JavaCardErrorProcessor.class, (String)"ERR_STRICTFP"), node, this.getCurrentPath().getCompilationUnit());
            }
            return (Void)super.visitMethod(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, Boolean p) {
            if (node.getModifiers().getFlags().contains((Object)Modifier.STRICTFP)) {
                Trees.instance(this.env).printMessage(Diagnostic.Kind.ERROR, NbBundle.getMessage(JavaCardErrorProcessor.class, (String)"ERR_STRICTFP"), node, this.getCurrentPath().getCompilationUnit());
            }
            return (Void)super.visitClass(node, p);
        }
    }
}

