/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class UninstallationSettingsPanel
extends JPanel {
    private final String ALL = NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"All");
    private ButtonGroup dependencyGroup;
    private JLabel messageLabel;
    private JTextField nameField;
    private JLabel nameLbl;
    private JComboBox versionCombo;
    private JLabel versionLbl;

    public UninstallationSettingsPanel(Gem gem) {
        this.initComponents();
        this.nameField.setText(gem.getName());
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(this.ALL);
        for (String version : gem.getInstalledVersions()) {
            model.addElement(version);
        }
        this.versionCombo.setModel(model);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public boolean getIgnoreDepencies() {
        return true;
    }

    public String getVersion() {
        String s = this.versionCombo.getSelectedItem().toString().trim();
        if (this.ALL.equals(s)) {
            return null;
        }
        return s;
    }

    public String getGemName() {
        return this.nameField.getText().trim();
    }

    private void initComponents() {
        this.dependencyGroup = new ButtonGroup();
        this.nameLbl = new JLabel();
        this.versionLbl = new JLabel();
        this.versionCombo = new JComboBox();
        this.messageLabel = new JLabel();
        this.nameField = new JTextField();
        this.setPreferredSize(new Dimension(285, 111));
        this.nameLbl.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"UninstallationSettingsPanel.nameLbl.text"));
        this.versionLbl.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLbl, (String)NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"UninstallationSettingsPanel.versionLbl.text"));
        this.nameField.setText(NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"UninstallationSettingsPanel.nameField.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.nameLbl).add((Component)this.versionLbl)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.nameField, -1, 69, Short.MAX_VALUE).add((Component)this.versionCombo, -2, -1, -2))).add((Component)this.messageLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLbl).add((Component)this.nameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.versionLbl).add((Component)this.versionCombo, -2, -1, -2)).add(27, 27, 27).add((Component)this.messageLabel)));
        this.nameLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"InstallationSettingsPanel.nameLbl.AccessibleContext.accessibleDescription"));
        this.versionLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"InstallationSettingsPanel.versionLbl.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UninstallationSettingsPanel.class, (String)"InstallationSettingsPanel.versionCombo.AccessibleContext.accessibleDescription"));
    }
}

