/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.api.ruby.platform.RubyPlatformValidator;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RubyPlatform
implements Comparable<RubyPlatform> {
    private static final Logger LOGGER = Logger.getLogger(RubyPlatform.class.getName());
    public static final String DEFAULT_RUBY_RELEASE = "1.8";
    public static final String RUBYSTUBS_VERSION = "1.8.7-p72";
    public static final String RUBYSTUBS = "rubystubs";
    static final String RUBY_DEBUG_IDE_NAME;
    private final Info info;
    private final RubyPlatformValidator validator;
    private final String id;
    private final String interpreter;
    private final PropertyChangeSupport pcs;
    private File home;
    private String homeUrl;
    private FileObject libDirFO;
    private GemManager gemManager;
    private static FileObject stubsFO;
    private String gemTool;
    private String rdoc;
    private String irb;
    private String rake;
    private String rails;
    private String autotest;
    private String autospec;

    RubyPlatform(String id, String interpreterPath, Info info) {
        this.id = id;
        this.interpreter = interpreterPath;
        this.info = info;
        this.validator = new RubyPlatformValidator(this);
        this.pcs = new PropertyChangeSupport(this);
    }

    @CheckForNull
    public static RubyPlatform platformFor(Project project) {
        RubyPlatform result;
        RubyPlatformProvider rpp = (RubyPlatformProvider)project.getLookup().lookup(RubyPlatformProvider.class);
        RubyPlatform rubyPlatform = result = rpp == null ? null : rpp.getPlatform();
        if (result == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not resolve a platform for " + project + ". " + "Platform provider: " + rpp);
        }
        return result;
    }

    @CheckForNull
    public static GemManager gemManagerFor(Project project) {
        RubyPlatform platform = RubyPlatform.platformFor(project);
        return platform == null ? null : platform.getGemManager();
    }

    @CheckForNull
    public static String platformDescriptionFor(Project project) {
        RubyPlatform platform = RubyPlatform.platformFor(project);
        return platform == null ? null : platform.getInfo().getLongDescription();
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean is19() {
        return this.getVersion() != null && this.getVersion().startsWith("1.9");
    }

    public boolean hasValidRake(boolean warn) {
        boolean valid = this.isValid(warn) && this.hasRubyGemsInstalled(warn);
        String rakePath = this.getRake();
        valid = rakePath != null && new File(rakePath).exists();
        this.possiblyNotifyUser(warn, valid, "rake");
        return valid;
    }

    public boolean hasValidRails(boolean warn) {
        String railsPath = this.getRails();
        boolean valid = railsPath != null && new File(railsPath).exists();
        this.possiblyNotifyUser(warn, valid, "rails");
        return valid;
    }

    public boolean hasValidAutoTest(boolean warn) {
        boolean validBinary = this.isValidFile(this.getAutoTest());
        this.possiblyNotifyUser(warn, validBinary, "autotest");
        return validBinary && this.hasZenTest();
    }

    public boolean hasValidAutoSpec(boolean warn) {
        boolean validBinary = this.isValidFile(this.getAutoSpec());
        this.possiblyNotifyUser(warn, validBinary, "autospec");
        return validBinary && this.hasZenTest();
    }

    private boolean hasZenTest() {
        return this.getGemManager() != null && this.getGemManager().isGemInstalled("ZenTest");
    }

    private boolean isValidFile(String path) {
        return path != null && new File(path).exists();
    }

    public static boolean hasValidRake(Project project, boolean warn) {
        RubyPlatform platform = RubyPlatform.platformFor(project);
        if (platform == null) {
            if (warn) {
                RubyPlatform.showWarning(project);
            }
            return false;
        }
        return platform.hasValidRake(warn);
    }

    public synchronized String getRake() {
        if (this.rake == null) {
            this.rake = this.findExecutable("rake");
            if (this.rake != null && !new File(this.rake).exists() && this.getGemManager().getLatestVersion("rake") != null) {
                InstalledFileLocator locator = InstalledFileLocator.getDefault();
                File f = locator.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
                if (f == null) {
                    throw new RuntimeException("Can't find cluster");
                }
                f = new File(f.getParentFile().getParentFile().getAbsolutePath() + File.separator + "rake");
                try {
                    this.rake = f.getCanonicalPath();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.rake;
    }

    public synchronized String getRails() {
        if (this.rails == null) {
            this.rails = this.findExecutable("rails");
        }
        return this.rails;
    }

    public synchronized String getAutoTest() {
        if (this.autotest == null) {
            this.autotest = this.findExecutable("autotest");
        }
        return this.autotest;
    }

    public synchronized String getAutoSpec() {
        if (this.autospec == null) {
            this.autospec = this.findExecutable("autospec");
        }
        return this.autospec;
    }

    public String getID() {
        return this.id;
    }

    public String getInterpreter(boolean cannonical) {
        String result = this.interpreter;
        if (cannonical) {
            try {
                result = new File(this.interpreter).getCanonicalFile().getAbsolutePath();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Cannot get canonical path", e);
            }
        }
        this.updateIndexRoots();
        return result;
    }

    public String getInterpreter() {
        this.updateIndexRoots();
        return this.interpreter;
    }

    public File getInterpreterFile() {
        this.updateIndexRoots();
        return new File(this.interpreter);
    }

    public File getHome() {
        return this.getHome(true);
    }

    public synchronized File getHome(boolean canonical) {
        if (this.home == null) {
            try {
                String rp = this.getInterpreter(canonical);
                if (rp == null) {
                    return null;
                }
                File r = new File(rp);
                File p = r.getParentFile();
                if (p == null) {
                    return null;
                }
                if ((p = p.getParentFile()) == null) {
                    return null;
                }
                this.home = p.getCanonicalFile();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return null;
            }
        }
        return this.home;
    }

    public synchronized String getHomeUrl() {
        if (this.homeUrl == null) {
            try {
                File r = this.getHome();
                if (r != null) {
                    this.homeUrl = r.toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
        }
        return this.homeUrl;
    }

    public String getLibDir() {
        if (this.isRubinius()) {
            return this.getRubiniusLibDir();
        }
        String lib = this.info.getLibDir();
        if (lib == null) {
            LOGGER.log(Level.WARNING, "rubylibdir not found for {0}, was: {1}", new String[]{this.interpreter, lib});
            return null;
        }
        File libDir = new File(lib);
        if (!libDir.isDirectory()) {
            LOGGER.log(Level.WARNING, "rubylibdir not found for {0}, was: {1}", new String[]{this.interpreter, lib});
            return null;
        }
        if ((libDir = libDir.getParentFile()) == null) {
            return null;
        }
        if ((libDir = libDir.getParentFile()) == null) {
            return null;
        }
        return libDir.getAbsolutePath();
    }

    private String getRubiniusLibDir() {
        File lib = new File(this.getHome(), "lib");
        return lib.isDirectory() ? lib.getAbsolutePath() : null;
    }

    public synchronized FileObject getLibDirFO() {
        String lib;
        if (this.libDirFO == null && (lib = this.getLibDir()) != null) {
            this.libDirFO = FileUtil.toFileObject((File)new File(lib));
        }
        return this.libDirFO;
    }

    public String getVersionLibDir() {
        return this.info.getLibDir();
    }

    public String getRubyLibSiteDir() {
        String sitedir = null;
        File _home = this.getHome();
        assert (_home != null) : "home not null";
        File lib = new File(_home, "lib" + File.separator + "ruby" + File.separator + "site_ruby");
        if (!lib.exists()) {
            return null;
        }
        File f = new File(lib, DEFAULT_RUBY_RELEASE);
        if (f.exists()) {
            sitedir = f.getAbsolutePath();
        } else {
            File[] children;
            for (File c : children = lib.listFiles()) {
                String name;
                if (!c.isDirectory() || !(name = c.getName()).matches("\\d+\\.\\d+")) continue;
                sitedir = c.getAbsolutePath();
                break;
            }
            if (sitedir == null && children.length > 0) {
                sitedir = children[0].getAbsolutePath();
            }
        }
        return sitedir;
    }

    public boolean isValid() {
        return this.isValid(false);
    }

    public boolean isValid(boolean warn) {
        String binDir;
        boolean valid;
        boolean bl = valid = new File(this.interpreter).isFile() && this.getLibDir() != null;
        if (valid && (binDir = this.getBinDir()) != null) {
            valid = new File(binDir).isDirectory();
        }
        if (warn && !valid) {
            RubyPlatform.showWarning(this);
        }
        return valid;
    }

    private static void showWarning(RubyPlatform platform) {
        String msg = NbBundle.getMessage(RubyPlatform.class, (String)"InvalidRubyPlatform", (Object)platform.getLabel());
        JButton closeButton = RubyPlatform.getCloseButton();
        Object[] options = new Object[]{closeButton};
        RubyPlatform.showDialog(msg, options);
    }

    private static void showWarning(Project project) {
        String msg = NbBundle.getMessage(RubyPlatform.class, (String)"InvalidRubyPlatformForProject", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        JButton closeButton = RubyPlatform.getCloseButton();
        CustomizerProvider customizer = (CustomizerProvider)project.getLookup().lookup(CustomizerProvider.class);
        JButton propertiesButton = new JButton(NbBundle.getMessage(RubyPlatform.class, (String)"Properties"));
        Object[] options = customizer != null ? new Object[]{propertiesButton, closeButton} : new Object[]{closeButton};
        if (RubyPlatform.showDialog(msg, options) == propertiesButton) {
            customizer.showCustomizer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object showDialog(String msg, Object[] options) {
        DialogDescriptor descriptor = new DialogDescriptor((Object)msg, NbBundle.getMessage(RubyPlatform.class, (String)"MissingRuby"), true, options, options[0], 0, new HelpCtx(RubyPlatform.class), null);
        descriptor.setMessageType(0);
        descriptor.setModal(true);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
        return descriptor.getValue();
    }

    private static JButton getCloseButton() {
        JButton closeButton = new JButton(NbBundle.getMessage(RubyPlatform.class, (String)"CTL_Close"));
        closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatform.class, (String)"AD_Close"));
        return closeButton;
    }

    public String getVersion() {
        return this.info.getVersion();
    }

    public String getLabel() {
        return this.info.getLabel(this.isDefault());
    }

    public boolean isDefault() {
        RubyPlatform defaultPlatform = RubyPlatformManager.getDefaultPlatform();
        return defaultPlatform != null && this.interpreter.equals(defaultPlatform.getInterpreter());
    }

    public boolean isJRuby() {
        return this.info.isJRuby();
    }

    public boolean isRubinius() {
        return this.info.isRubinius();
    }

    public boolean showWarningIfInvalid() {
        boolean valid = this.isValid();
        if (!valid) {
            Util.notifyLocalized(RubyPlatform.class, "RubyPlatform.InvalidInterpreter", 2, new Object[]{this.getInterpreter()});
        }
        return valid;
    }

    @CheckForNull
    public synchronized GemManager getGemManager() {
        if (this.gemManager == null && this.hasRubyGemsInstalled()) {
            this.gemManager = new GemManager(this);
        }
        return this.gemManager;
    }

    public String getBinDir() {
        return this.getBinDir(true);
    }

    public String getBinDir(boolean canonical) {
        String rubybin = null;
        String r = this.getInterpreter(canonical);
        if (r != null) {
            rubybin = new File(r).getParent();
        }
        return rubybin;
    }

    public String findExecutable(String toFind) {
        return this.findExecutable(toFind, true);
    }

    private String findExecutable(String toFind, boolean searchInRubyGems) {
        String exec = null;
        boolean canonical = true;
        do {
            File repo;
            String libGemBinDir;
            String binDir;
            if ((binDir = this.getBinDir()) != null) {
                LOGGER.log(Level.FINER, "Looking for '{0}' executable; used intepreter: '{1}'", new String[]{toFind, this.getInterpreter()});
                exec = RubyPlatform.findExecutable(binDir, toFind);
            } else {
                LOGGER.log(Level.WARNING, "Could not find Ruby interpreter executable when searching for '{0}'", toFind);
            }
            if (exec != null || !searchInRubyGems || !this.hasRubyGemsInstalled()) continue;
            Iterator<? extends File> i$ = this.getGemManager().getRepositories().iterator();
            while (i$.hasNext() && (exec = RubyPlatform.findExecutable(libGemBinDir = (repo = i$.next()).getAbsolutePath() + File.separator + "bin", toFind)) == null) {
            }
        } while (!(canonical ^= true) && exec == null);
        if (exec == null) {
            exec = Util.findOnPath(toFind);
        }
        if (exec == null && !toFind.endsWith(".bat") && Utilities.isWindows()) {
            exec = this.findExecutable(toFind + ".bat", searchInRubyGems);
        }
        if (exec != null) {
            LOGGER.log(Level.FINER, "Found '{0}': '{1}'", new String[]{toFind, exec});
        }
        return exec;
    }

    private String findExecutable(String toFind, boolean searchInRubyGems, boolean withSuffix) {
        String name;
        String exec = this.findExecutable(toFind, searchInRubyGems);
        if (exec == null && withSuffix && !this.isJRuby() && (name = new File(this.getInterpreter(true)).getName()).startsWith("ruby")) {
            String suffix = name.substring(4);
            exec = this.findExecutable(toFind + suffix, searchInRubyGems);
        }
        return exec;
    }

    private static String findExecutable(String dir, String toFind) {
        String exec = dir + File.separator + toFind;
        if (!new File(exec).isFile()) {
            LOGGER.log(Level.FINER, "'{0}' is not a file.", exec);
            exec = null;
        }
        return exec;
    }

    public synchronized String getGemTool() {
        if (this.gemTool == null) {
            this.gemTool = this.findExecutable("gem", false, true);
        }
        return this.gemTool;
    }

    public synchronized String getRDoc() {
        if (this.rdoc == null) {
            this.rdoc = this.findExecutable("rdoc", false, true);
        }
        return this.rdoc;
    }

    public synchronized String getIRB() {
        if (this.irb == null) {
            this.irb = this.findExecutable(this.isJRuby() ? "jirb" : "irb", false, true);
        }
        return this.irb;
    }

    public static synchronized FileObject getRubyStubs() {
        if (stubsFO == null) {
            File clusterFile = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (clusterFile != null) {
                File rubyStubs = new File(clusterFile.getParentFile().getParentFile().getAbsoluteFile(), RUBYSTUBS + File.separator + RUBYSTUBS_VERSION);
                assert (rubyStubs.exists() && rubyStubs.isDirectory());
                stubsFO = FileUtil.toFileObject((File)rubyStubs);
            } else {
                FileObject fo;
                String interpreter;
                RubyPlatform platform = RubyPlatformManager.getDefaultPlatform();
                if (platform != null && (interpreter = platform.getInterpreter()) != null && (fo = FileUtil.toFileObject((File)new File(interpreter))) != null) {
                    stubsFO = fo.getParent().getParent().getParent().getFileObject("rubystubs/1.8.7-p72");
                }
            }
        }
        return stubsFO;
    }

    public boolean hasFastDebuggerInstalled() {
        return this.getGemManager() != null && !this.isRubinius() && this.getFastDebuggerProblemsInHTML() == null;
    }

    public String getFastDebuggerProblemsInHTML() {
        assert (this.getGemManager() != null) : "has gemManager when asking whether Fast Debugger is installed";
        this.getGemManager().resetLocal();
        StringBuilder errors = new StringBuilder();
        if (this.is19() && RUBY_DEBUG_IDE_NAME.equals("ruby-debug-ide") && this.checkGem(RUBY_DEBUG_IDE_NAME + "19", this.getRequiredRDebugIDEVersionPattern())) {
            return null;
        }
        this.checkGemAndReport(RUBY_DEBUG_IDE_NAME, this.getRequiredRDebugIDEVersionPattern(), errors);
        return errors.length() == 0 ? null : errors.toString();
    }

    private Pattern getRequiredRDebugIDEVersionPattern() {
        return Pattern.compile("0\\.4\\..*");
    }

    private boolean checkGem(String gemName, final Pattern gemVersion) {
        GemManager.VersionPredicate predicate = new GemManager.VersionPredicate(){

            @Override
            public boolean isRight(String version) {
                return gemVersion.matcher(version).matches();
            }
        };
        return this.getGemManager().isGemInstalledForPlatform(gemName, predicate);
    }

    private void checkGemAndReport(String gemName, Pattern gemVersion, StringBuilder errors) {
        if (!this.checkGem(gemName, gemVersion)) {
            errors.append(NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatform.GemInVersionMissing", (Object)gemName, (Object)gemVersion.toString()));
            errors.append("<br>");
        }
    }

    public void reportRubyGemsProblem() {
        this.validator.reportRubyGemsProblem();
    }

    public boolean checkAndReportRubyGemsProblems() {
        return this.validator.checkAndReportRubyGemsProblems();
    }

    public String getRubyGemsProblems() {
        return this.validator.getRubyGemsProblems();
    }

    public String getLatestAvailableValidRDebugIDEVersions() {
        String version;
        if (this.is19() && RUBY_DEBUG_IDE_NAME.equals("ruby-debug-ide") && (version = this.getLatestAvailableValidRDebugIDEVersions(RUBY_DEBUG_IDE_NAME + "19")) != null) {
            return version;
        }
        return this.getLatestAvailableValidRDebugIDEVersions(RUBY_DEBUG_IDE_NAME);
    }

    private String getLatestAvailableValidRDebugIDEVersions(String gemName) {
        List<GemInfo> versions = this.getGemManager().getVersions(gemName);
        for (GemInfo getInfo : versions) {
            String version = getInfo.getVersion();
            if (!this.getRequiredRDebugIDEVersionPattern().matcher(version).matches()) continue;
            return version;
        }
        return null;
    }

    public boolean installFastDebugger() {
        assert (this.getGemManager() != null) : "has gemManager when trying to install fast debugger";
        Runnable installer = new Runnable(){

            @Override
            public void run() {
                RubyPlatform.this.getGemManager().installGem(RUBY_DEBUG_IDE_NAME, false, false, "0.4.9");
            }
        };
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(installer);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            installer.run();
        }
        return this.hasFastDebuggerInstalled();
    }

    public FileObject getSystemRoot(FileObject file) {
        FileObject rubyLibFo = this.isRubinius() ? null : this.getLibDirFO();
        FileObject rubyStubs = RubyPlatform.getRubyStubs();
        FileObject gemHome = this.getGemHome();
        while (file != null) {
            if (file.equals(rubyLibFo) || file.equals(rubyStubs) || this.isGemRoot(file) || file.equals(gemHome)) {
                return file;
            }
            file = file.getParent();
        }
        return null;
    }

    private FileObject getGemHome() {
        return this.getGemManager() != null ? this.getGemManager().getGemHomeFO() : null;
    }

    private boolean isGemRoot(FileObject file) {
        for (int i = 0; i < 3 && file != null; file = file.getParent(), ++i) {
        }
        return file != null && file.isFolder() && file.equals(this.getGemHome());
    }

    private void updateIndexRoots() {
    }

    public void recomputeRoots() {
        this.updateIndexRoots();
        this.pcs.firePropertyChange("roots", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setGemHome(File gemHome) {
        assert (this.hasRubyGemsInstalled()) : "has RubyGems installed";
        this.info.setGemHome(gemHome.getAbsolutePath());
        try {
            RubyPlatformManager.storePlatform(this);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
        }
        this.getGemManager().reset();
    }

    public boolean hasRubyGemsInstalled() {
        return this.hasRubyGemsInstalled(false);
    }

    public boolean hasRubyGemsInstalled(boolean warn) {
        return this.validator.hasRubyGemsInstalled(warn);
    }

    public void fireGemsChanged() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("gems", null, null);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyPlatform other = (RubyPlatform)obj;
        return !(this.interpreter == null ? other.interpreter != null : !this.interpreter.equals(other.interpreter));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.interpreter != null ? this.interpreter.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RubyPlatform other) {
        return this.getInterpreter().compareTo(other.getInterpreter());
    }

    public String toString() {
        return "RubyPlatform[id:" + this.getID() + ", label:" + this.getLabel() + ", " + this.getInterpreter() + ", info: " + this.info + "]";
    }

    private void possiblyNotifyUser(boolean warn, boolean valid, String cmd) {
        if (warn && !valid) {
            String msg = NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatform.NotInstalledCmd", (Object)cmd, (Object)this.getLabel());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    static {
        String prop = System.getProperty("rubyDebugIDEName");
        RUBY_DEBUG_IDE_NAME = prop != null ? prop : "ruby-debug-ide";
    }

    public static class Info {
        static final String RUBY_KIND = "ruby_kind";
        static final String RUBY_VERSION = "ruby_version";
        static final String JRUBY_VERSION = "jruby_version";
        static final String RUBY_PATCHLEVEL = "ruby_patchlevel";
        static final String RUBY_RELEASE_DATE = "ruby_release_date";
        static final String RUBY_EXECUTABLE = "ruby_executable";
        static final String RUBY_PLATFORM = "ruby_platform";
        static final String RUBY_LIB_DIR = "ruby_lib_dir";
        static final String GEM_HOME = "gem_home";
        static final String GEM_PATH = "gem_path";
        static final String GEM_VERSION = "gem_version";
        private final String kind;
        private final String version;
        private String jversion;
        private String patchlevel;
        private String releaseDate;
        private String platform;
        private String gemHome;
        private String gemPath;
        private String gemVersion;
        private String libDir;

        Info(Properties props) {
            this.kind = props.getProperty(RUBY_KIND);
            this.version = props.getProperty(RUBY_VERSION);
            this.jversion = props.getProperty(JRUBY_VERSION);
            this.patchlevel = props.getProperty(RUBY_PATCHLEVEL);
            this.releaseDate = props.getProperty(RUBY_RELEASE_DATE);
            this.platform = props.getProperty(RUBY_PLATFORM);
            this.libDir = props.getProperty(RUBY_LIB_DIR);
            this.setGemHome(props.getProperty(GEM_HOME));
            this.gemPath = props.getProperty(GEM_PATH);
            this.gemVersion = props.getProperty(GEM_VERSION);
        }

        Info(String kind, String version) {
            this.kind = kind;
            this.version = version;
        }

        static Info forDefaultPlatform() {
            Info info = new Info("JRuby", "1.8.7");
            info.jversion = "1.5.1";
            info.patchlevel = "249";
            info.releaseDate = "2010-05-12";
            info.platform = "java";
            File jrubyHome = InstalledFileLocator.getDefault().locate("jruby-1.5.1", "org.netbeans.modules.ruby.platform", false);
            assert (jrubyHome != null && jrubyHome.isDirectory()) : "Default platform available";
            FileObject libDirFO = FileUtil.toFileObject((File)jrubyHome).getFileObject("/lib/ruby");
            info.libDir = FileUtil.toFile((FileObject)libDirFO.getFileObject("/1.8")).getAbsolutePath();
            info.gemPath = info.gemHome = FileUtil.toFile((FileObject)libDirFO.getFileObject("/gems/1.8")).getAbsolutePath();
            info.gemVersion = "1.3.6";
            return info;
        }

        public String getLabel(boolean isDefault) {
            String ver = this.isJRuby() ? this.jversion : this.version + (this.patchlevel != null ? "-p" + this.patchlevel : "");
            return (isDefault ? NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatformManager.CTL_BundledJRubyLabel") : this.kind) + ' ' + ver;
        }

        public String getLongDescription() {
            StringBuilder sb = new StringBuilder(this.kind + ' ' + this.version + ' ' + '(' + this.releaseDate);
            if (this.patchlevel != null) {
                sb.append(" patchlevel ").append(this.patchlevel);
            }
            sb.append(") [").append(this.platform).append(']');
            return sb.toString();
        }

        public boolean isJRuby() {
            return "JRuby".equals(this.kind);
        }

        public boolean isRubinius() {
            return "Rubinius".equals(this.kind);
        }

        public final void setGemHome(String gemHome) {
            this.gemHome = gemHome == null ? null : new File(gemHome).getAbsolutePath();
        }

        public String getGemHome() {
            return this.gemHome;
        }

        public void setGemPath(String gemPath) {
            this.gemPath = gemPath;
        }

        public String getGemPath() {
            return this.gemPath;
        }

        public String getGemVersion() {
            return this.gemVersion;
        }

        public void setGemVersion(String gemVersion) {
            this.gemVersion = gemVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public String getPatchlevel() {
            return this.patchlevel;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public String getJVersion() {
            return this.jversion;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformVersion() {
            return this.isJRuby() ? this.getJVersion() : this.getVersion();
        }

        public String getLibDir() {
            return this.libDir;
        }

        public String toString() {
            return "RubyPlatform$Info[GEM_HOME:" + this.getGemHome() + ", GEM_PATH: " + this.getGemPath() + ", gemVersion: " + this.getGemVersion() + ", lib: " + this.getLibDir() + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            if (!(this.kind == other.kind || this.kind != null && this.kind.equals(other.kind))) {
                return false;
            }
            if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
                return false;
            }
            if (!(this.patchlevel == other.patchlevel || this.patchlevel != null && this.patchlevel.equals(other.patchlevel))) {
                return false;
            }
            return this.platform == other.platform || this.platform != null && this.platform.equals(other.platform);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            hash = 83 * hash + (this.version != null ? this.version.hashCode() : 0);
            hash = 83 * hash + (this.patchlevel != null ? this.patchlevel.hashCode() : 0);
            hash = 83 * hash + (this.platform != null ? this.platform.hashCode() : 0);
            return hash;
        }
    }
}

