/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndex;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class LuceneIndexManager {
    private static LuceneIndexManager instance;
    private volatile boolean invalid;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<URL, LuceneIndex> indexes = new HashMap<URL, LuceneIndex>();

    private LuceneIndexManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R writeAccess(Action<R> action) throws IOException {
        assert (action != null);
        this.lock.writeLock().lock();
        try {
            R r = action.run();
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R readAccess(Action<R> action) throws IOException {
        assert (action != null);
        this.lock.readLock().lock();
        try {
            R r = action.run();
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean holdsWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public static synchronized LuceneIndexManager getDefault() {
        if (instance == null) {
            instance = new LuceneIndexManager();
        }
        return instance;
    }

    public synchronized LuceneIndex getIndex(URL root, Mode mode) throws IOException {
        assert (root != null);
        if (this.invalid) {
            return null;
        }
        LuceneIndex li = this.indexes.get(root);
        if (li == null) {
            switch (mode) {
                case CREATE: {
                    li = new LuceneIndex(root);
                    this.indexes.put(root, li);
                    break;
                }
                case IF_EXIST: {
                    FileObject fo = URLMapper.findFileObject((URL)root);
                    if (fo == null || !fo.isFolder() || !fo.getChildren(false).hasMoreElements()) break;
                    li = new LuceneIndex(root);
                    this.indexes.put(root, li);
                }
            }
        }
        return li;
    }

    public static enum Mode {
        OPENED,
        CREATE,
        IF_EXIST;

    }

    public static interface Action<R> {
        public R run() throws IOException;
    }
}

