/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.FutureTask;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.NaiveUserAgent;

public class CssPreviewPanel
extends JPanel
implements CssPreviewComponent {
    private static final Logger LOGGER = Logger.getLogger(CssPreviewPanel.class.getName());
    private static final boolean LOG_FINE = LOGGER.isLoggable(Level.FINE);
    private Handler FS_HANDLER = new FlyingSaucerLoggersHandler();
    private XHTMLPanel xhtmlPanel;
    private Runnable panelCreatedTask;
    private JScrollPane jScrollPane1;

    public CssPreviewPanel() {
        this.initComponents();
        RequestProcessor.getDefault().execute(new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                final PatchedXHTMLPanel panel = new PatchedXHTMLPanel((UserAgentCallback)new PreviewUserAgent());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CssPreviewPanel.this.setXhtmlPanel(panel);
                    }
                });
            }
        }, null));
        this.configureFlyingSaucerLoggers();
    }

    private synchronized void setXhtmlPanel(XHTMLPanel panel) {
        assert (SwingUtilities.isEventDispatchThread());
        this.xhtmlPanel = panel;
        this.jScrollPane1.setViewportView((Component)panel);
        if (this.panelCreatedTask != null) {
            this.panelCreatedTask.run();
            this.panelCreatedTask = null;
        }
    }

    @Override
    public synchronized void setDocument(final InputStream is, final String url) throws Exception {
        if (this.xhtmlPanel == null) {
            this.panelCreatedTask = new Runnable(){

                @Override
                public void run() {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CssPreviewPanel.this.xhtmlPanel.setDocument(is, url);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CssPreviewPanel.this.xhtmlPanel.revalidate();
                                        CssPreviewPanel.this.xhtmlPanel.repaint();
                                    }
                                });
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.INFO, "Error setting the document to be previewed!", ex);
                            }
                        }
                    });
                }
            };
        } else {
            this.xhtmlPanel.setDocument(is, url);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void dispose() {
    }

    private void configureFlyingSaucerLoggers() {
        Logger logger = Logger.getLogger("plumbing.exception");
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.setUseParentHandlers(false);
        logger.addHandler(this.FS_HANDLER);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static class PreviewUserAgent
    extends NaiveUserAgent {
        private PreviewUserAgent() {
        }

        public String resolveURI(String uri) {
            if (uri == null) {
                return null;
            }
            try {
                int doubleSlashIndex = uri.lastIndexOf("//");
                if (doubleSlashIndex != -1) {
                    URL targetURL;
                    FileObject target;
                    String absoluteLink = uri.substring(doubleSlashIndex + 1);
                    FileObject edited = URLMapper.findFileObject((URL)new URL(this.getBaseURL()));
                    if (edited != null && (target = WebUtils.resolve((FileObject)edited, (String)absoluteLink)) != null && (targetURL = URLMapper.findURL((FileObject)target, (int)0)) != null) {
                        return targetURL.toExternalForm();
                    }
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return super.resolveURI(uri);
        }
    }

    private static class PatchedXHTMLPanel
    extends XHTMLPanel {
        public PatchedXHTMLPanel(UserAgentCallback uac) {
            super(uac);
        }

        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
            }
            catch (Throwable e) {
                if (LOG_FINE) {
                    LOGGER.log(Level.FINE, "It seems there is a bug in FlyinSaucer XHTML renderer.", e);
                }
                CssPreviewTopComponent.getDefault().setError();
            }
        }
    }

    private class FlyingSaucerLoggersHandler
    extends Handler {
        private FlyingSaucerLoggersHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            Level level = record.getLevel();
            if (LOG_FINE) {
                record.setLevel(Level.FINE);
                LOGGER.log(record);
            }
            if (level.intValue() >= Level.WARNING.intValue()) {
                LOGGER.log(Level.INFO, record.getMessage());
                StatusDisplayer.getDefault().setStatusText(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

