/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class AppClientBuildScriptExtensionProvider
implements JaxWsBuildScriptExtensionProvider {
    static String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-app-client.xsl";
    private Project project;

    public AppClientBuildScriptExtensionProvider(Project project) {
        this.project = project;
    }

    @Override
    public void addJaxWsExtension(AntBuildExtender antBuildExtender) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE, true);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension == null) {
            extension = antBuildExtender.addExtension("jaxws", fileObject);
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJaxWsExtension(final AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        FileObject fileObject;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    antBuildExtender.removeExtension("jaxws");
                }
            });
            ProjectManager.getDefault().saveProject(this.project);
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml")) != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    @Override
    public void handleJaxWsModelChanges(JaxWsModel jaxWsModel) throws IOException {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (antBuildExtender != null) {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
            if (jaxWsModel.getClients().length == 0) {
                this.removeJaxWsExtension(antBuildExtender);
            } else {
                this.addJaxWsExtension(antBuildExtender);
            }
        }
    }
}

