/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.actions;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.modules.websvc.spi.support.DefaultClientSelectionPanel;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ClientExplorerPanel
extends DefaultClientSelectionPanel {
    private Project[] sourceProjects = OpenProjects.getDefault().getOpenProjects();
    private Children rootChildren = new Children.Array();
    private Node explorerClientRoot = new AbstractNode(this.rootChildren);
    private List<Node> projectNodeList = new ArrayList<Node>();

    public ClientExplorerPanel(FileObject fileObject) {
        super(fileObject);
    }

    public void addNotify() {
        super.addNotify();
        this.getTreeView().expandAll();
    }

    protected Node getRootContext() {
        for (int i = 0; i < this.sourceProjects.length; ++i) {
            LogicalViewProvider logicalViewProvider;
            Project project = FileOwnerQuery.getOwner((FileObject)this.getTargetFile());
            if (project == null || !WSUtils.isProjectReferenceable(this.sourceProjects[i], project) || (logicalViewProvider = (LogicalViewProvider)this.sourceProjects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node node = logicalViewProvider.createLogicalView();
            Node[] nodeArray = this.getClientNodes(this.sourceProjects[i]);
            if (nodeArray.length <= 0) continue;
            Children.Array array = new Children.Array();
            array.add(nodeArray);
            if (array.getNodesCount() <= 0) continue;
            this.projectNodeList.add((Node)new ProjectNode((Children)array, node));
        }
        Node[] nodeArray = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(nodeArray);
        this.rootChildren.add(nodeArray);
        return this.explorerClientRoot;
    }

    protected boolean isClientNode(Node node) {
        return node.getLookup().lookup(WsdlOperation.class) != null;
    }

    private Node[] getClientNodes(Project project) {
        WebServiceData webServiceData = WebServiceData.getWebServiceData((Project)project);
        if (webServiceData != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (WebService webService : webServiceData.getServiceConsumers()) {
                arrayList.add(webService.createNode());
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }
        return new Node[0];
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }
}

