/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.javacard.spi.Cards;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class CardsFactory {
    private Map<String, Reference<Cards>> cache = new HashMap<String, Reference<Cards>>();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cards getCards(FileObject source) {
        Cards result;
        Object object = this.lock;
        synchronized (object) {
            Reference<Cards> r = null;
            HashSet<String> toRemove = null;
            for (Map.Entry<String, Reference<Cards>> e : this.cache.entrySet()) {
                Cards c = e.getValue().get();
                if (c == null) {
                    if (toRemove == null) {
                        toRemove = new HashSet<String>();
                    }
                    toRemove.add(e.getKey());
                    continue;
                }
                if (!source.getPath().equals(e.getKey())) continue;
                r = e.getValue();
            }
            Cards cards = result = r == null ? null : (Cards)r.get();
            if (result == null) {
                try {
                    DataObject dob = DataObject.find((FileObject)source);
                    result = this.createCards((Lookup.Provider)dob);
                    if (result != null) {
                        r = new WeakReference<Cards>(result);
                        this.cache.put(source.getPath(), r);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return result;
    }

    protected abstract Cards createCards(Lookup.Provider var1);

    public static CardsFactory find(String platformKind) {
        Lookup lkp = Lookups.forPath((String)("org-netbeans-modules-javacard-spi/kinds/" + platformKind));
        return (CardsFactory)lkp.lookup(CardsFactory.class);
    }
}

