/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.model.Debug;

public abstract class FlowEdgePresenter
extends FlowPresenter
implements FlowPresenter.FlowUIResolver {
    private FlowPresenter.FlowUIResolver resolver = new FlowPresenter.FlowUIResolver(){

        @Override
        public FlowDescriptor.Decorator getDecorator() {
            return FlowEdgePresenter.this.getDynamicPinDecorator();
        }

        @Override
        public FlowDescriptor.Behaviour getBehaviour() {
            return FlowEdgePresenter.this.getDynamicPinBehaviour();
        }
    };
    private FlowEdgeDescriptor edge = null;
    private FlowEdgeDescriptor newEdge;
    private boolean removeAdd;

    @Override
    public final void resolveRemoveBadge() {
    }

    @Override
    public final void resolveRemoveEdge() {
        this.newEdge = this.isVisible() ? this.getEdgeDescriptor() : null;
        boolean bl = this.removeAdd = !FlowEdgePresenter.equals(this.edge, this.newEdge);
        if (this.removeAdd && this.edge != null) {
            this.removeDettachSourcePin(this.edge);
            this.removeDettachTargetPin(this.edge);
            FlowScene scene = this.getScene();
            scene.removeEdge(this.edge);
            scene.unregisterUI(this.edge, (FlowPresenter.FlowUIResolver)this);
        }
    }

    @Override
    public final void resolveRemovePin() {
    }

    @Override
    public final void resolveRemoveNode() {
    }

    @Override
    public final void resolveAddNode() {
    }

    @Override
    public final void resolveAddPin() {
    }

    @Override
    public final void resolveAddEdge() {
        if (this.removeAdd) {
            this.edge = this.newEdge;
            if (this.edge != null) {
                FlowScene scene = this.getScene();
                scene.registerUI(this.edge, (FlowPresenter.FlowUIResolver)this);
                scene.addEdge(this.edge);
                scene.updateBadges(this.edge);
                this.createAssignSourcePin(this.edge);
                this.createAssignTargetPin(this.edge);
            }
        } else if (this.edge != null && this.newEdge != null) {
            boolean targetChanged;
            boolean sourceChanged = !FlowEdgePresenter.equals(this.edge.getSourcePinDescriptor(), this.newEdge.getSourcePinDescriptor()) || this.edge.isDynamicSourcePin() != this.newEdge.isDynamicSourcePin();
            boolean bl = targetChanged = !FlowEdgePresenter.equals(this.edge.getTargetPinDescriptor(), this.newEdge.getTargetPinDescriptor()) || this.edge.isDynamicTargetPin() != this.newEdge.isDynamicTargetPin();
            if (sourceChanged) {
                this.removeDettachSourcePin(this.edge);
            }
            if (targetChanged) {
                this.removeDettachTargetPin(this.edge);
            }
            this.edge.update(this.newEdge);
            this.createAssignSourcePin(this.edge);
            this.createAssignTargetPin(this.edge);
        }
        this.newEdge = null;
    }

    @Override
    public final void resolveAddBadge() {
    }

    @Override
    public final void resolveUpdate() {
        FlowScene scene = this.getScene();
        if (this.edge != null) {
            scene.getDecorator(this.edge).update(this.edge, scene);
            if (this.edge.isDynamicSourcePin()) {
                FlowPinDescriptor sourcePin = this.edge.getSourcePinDescriptor();
                scene.getDecorator(sourcePin).update(sourcePin, scene);
            }
            if (this.edge.isDynamicTargetPin()) {
                FlowPinDescriptor targetPin = this.edge.getTargetPinDescriptor();
                scene.getDecorator(targetPin).update(targetPin, scene);
            }
        }
    }

    private void createAssignSourcePin(FlowEdgeDescriptor edge) {
        FlowScene scene = this.getScene();
        FlowPinDescriptor pin = edge.getSourcePinDescriptor();
        if (pin != null) {
            if (edge.isDynamicSourcePin()) {
                if (!scene.isObject(pin)) {
                    FlowNodeDescriptor node = this.getSourceNodeDescriptor(pin);
                    assert (node != null);
                    scene.registerUI(pin, this.resolver);
                    scene.addPin(node, pin);
                    scene.updateBadges(pin);
                } else {
                    FlowPinDescriptor original = pin;
                    if ((pin = (FlowPinDescriptor)scene.findStoredObject(pin)) == null) {
                        Debug.warning((Object[])new Object[]{"Source pin not found", edge, original});
                    }
                }
            } else {
                FlowPinDescriptor original = pin;
                if ((pin = (FlowPinDescriptor)scene.findStoredObject(pin)) == null) {
                    Debug.warning((Object[])new Object[]{"Source pin not found", edge, original});
                }
            }
        }
        scene.setEdgeSource(edge, pin);
    }

    private void createAssignTargetPin(FlowEdgeDescriptor edge) {
        FlowScene scene = this.getScene();
        FlowPinDescriptor pin = edge.getTargetPinDescriptor();
        if (pin != null) {
            if (edge.isDynamicTargetPin()) {
                if (!scene.isObject(pin)) {
                    FlowNodeDescriptor node = this.getTargetNodeDescriptor(pin);
                    assert (node != null);
                    scene.registerUI(pin, this.resolver);
                    scene.addPin(node, pin);
                } else {
                    FlowPinDescriptor original = pin;
                    if ((pin = (FlowPinDescriptor)scene.findStoredObject(pin)) == null) {
                        Debug.warning((Object[])new Object[]{"Target pin not found", edge, original});
                    }
                }
            } else {
                FlowPinDescriptor original = pin;
                if ((pin = (FlowPinDescriptor)scene.findStoredObject(pin)) == null) {
                    Debug.warning((Object[])new Object[]{"Target pin not found", edge, original});
                }
            }
        }
        scene.setEdgeTarget(edge, pin);
    }

    private void removeDettachSourcePin(FlowEdgeDescriptor edge) {
        if (!edge.isDynamicSourcePin()) {
            return;
        }
        FlowScene scene = this.getScene();
        FlowPinDescriptor pin = (FlowPinDescriptor)scene.getEdgeSource(edge);
        scene.removePin(pin);
        scene.unregisterUI(pin, this.resolver);
    }

    private void removeDettachTargetPin(FlowEdgeDescriptor edge) {
        if (!edge.isDynamicTargetPin()) {
            return;
        }
        FlowScene scene = this.getScene();
        FlowPinDescriptor pin = (FlowPinDescriptor)scene.getEdgeTarget(edge);
        scene.removePin(pin);
        scene.unregisterUI(pin, this.resolver);
    }

    @Override
    public final Collection<? extends FlowDescriptor> getFlowDescriptors() {
        return this.edge != null ? Collections.singleton(this.edge) : Collections.emptySet();
    }

    protected abstract FlowNodeDescriptor getSourceNodeDescriptor(FlowPinDescriptor var1);

    protected abstract FlowNodeDescriptor getTargetNodeDescriptor(FlowPinDescriptor var1);

    public abstract FlowEdgeDescriptor getEdgeDescriptor();

    @Override
    public abstract FlowEdgeDescriptor.EdgeDecorator getDecorator();

    @Override
    public abstract FlowEdgeDescriptor.EdgeBehaviour getBehaviour();

    public abstract FlowPinDescriptor.PinDecorator getDynamicPinDecorator();

    public abstract FlowPinDescriptor.PinBehaviour getDynamicPinBehaviour();
}

