/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBTable;

public final class DBColumn
extends DBObject<DBTable>
implements Comparable {
    public static final int POSITION_UNKNOWN = Integer.MIN_VALUE;
    private boolean foreignKey;
    private int jdbcType;
    private String typeName;
    private String columnName;
    private boolean nullable;
    private boolean editable = true;
    private int ordinalPosition = Integer.MIN_VALUE;
    private boolean primaryKey;
    private int precision;
    private int scale;
    private boolean generated;
    private int displaySize;
    private String defaultValue;

    public DBColumn(DBTable table, String colName, int sqlJdbcType, String dbTypeName, int colScale, int colPrecision, boolean isNullable, boolean isGenerated) {
        this.setParentObject(table);
        this.columnName = colName;
        this.jdbcType = sqlJdbcType;
        this.typeName = dbTypeName;
        this.precision = colPrecision;
        this.scale = colScale;
        this.nullable = isNullable;
        this.generated = isGenerated;
        this.editable = !table.getName().equals("") && !isGenerated;
    }

    public int compareTo(Object refObj) {
        if (refObj == null) {
            return -1;
        }
        if (refObj == this) {
            return 0;
        }
        String myName = this.getDisplayName();
        myName = myName == null ? this.columnName : myName;
        String refName = null;
        if (!(refObj instanceof DBColumn)) {
            return -1;
        }
        DBColumn refColumn = (DBColumn)refObj;
        refName = refColumn.getName();
        if (this.isPrimaryKey() && !refColumn.isPrimaryKey()) {
            return -1;
        }
        if (!this.isPrimaryKey() && refColumn.isPrimaryKey()) {
            return 1;
        }
        if (this.isForeignKey() && !refColumn.isForeignKey()) {
            return -1;
        }
        if (!this.isForeignKey() && refColumn.isForeignKey()) {
            return 1;
        }
        return myName != null ? myName.compareTo(refName) : (refName != null ? 1 : -1);
    }

    public boolean equals(Object refObj) {
        if (!(refObj instanceof DBColumn)) {
            return false;
        }
        DBColumn refMeta = (DBColumn)refObj;
        boolean result = super.equals(refObj);
        result &= this.columnName != null ? this.columnName.equals(refMeta.getName()) : refMeta.getName() == null;
        return result &= this.jdbcType == refMeta.getJdbcType() && this.primaryKey == refMeta.isPrimaryKey() && this.foreignKey == refMeta.isForeignKey() && this.nullable == refMeta.isNullable() && this.scale == refMeta.getScale() && this.precision == refMeta.getPrecision() && this.ordinalPosition == refMeta.getOrdinalPosition();
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null && this.displayName.trim().length() != 0 ? this.displayName.trim() : this.columnName.trim();
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.columnName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDisplaySize(int displaySize) {
        this.displaySize = displaySize;
    }

    public String getQualifiedName(boolean quoteAlways) {
        StringBuilder buf = new StringBuilder(50);
        DBTable table = (DBTable)this.getParentObject();
        buf.append(quoteAlways ? table.getQuoter().quoteAlways(this.columnName) : table.getQuoter().quoteIfNeeded(this.columnName));
        return buf.toString();
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        int myHash = super.hashCode();
        myHash += this.columnName != null ? this.columnName.hashCode() : 0;
        myHash += this.ordinalPosition;
        myHash += this.jdbcType + 10 * this.scale + 100 * this.precision;
        myHash += this.primaryKey ? 1 : 0;
        myHash += this.foreignKey ? 2 : 0;
        myHash += this.generated ? 4 : 0;
        return myHash += this.nullable ? 8 : 0;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean hasDefault() {
        return this.defaultValue != null && this.defaultValue.trim().length() != 0;
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setForeignKey(boolean newFlag) {
        this.foreignKey = newFlag;
    }

    void setOrdinalPosition(int cardinalPos) {
        this.ordinalPosition = cardinalPos;
    }

    void setPrimaryKey(boolean newFlag) {
        this.primaryKey = newFlag;
    }

    void setEditable(boolean editable) {
        this.editable = editable;
    }
}

