/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

class FileSubmitFormControl
extends FormControl {
    private UploadFileSpec _fileToUpload;

    public String getType() {
        return "file";
    }

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    public FileSubmitFormControl(WebForm form, Node node) {
        super(form, node);
    }

    public boolean isFileParameter() {
        return true;
    }

    public String[] getValues() {
        return new String[]{this.getSelectedName()};
    }

    private String getSelectedName() {
        return this._fileToUpload == null ? "" : this._fileToUpload.getFileName();
    }

    void claimUploadSpecification(List files) {
        if (files.isEmpty()) {
            this._fileToUpload = null;
        } else {
            this._fileToUpload = (UploadFileSpec)files.get(0);
            files.remove(0);
        }
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (!this.isDisabled() && this._fileToUpload != null) {
            processor.addFile(this.getName(), this._fileToUpload);
        }
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(FileSubmitFormControl.this);
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("value")) {
                return FileSubmitFormControl.this.getSelectedName();
            }
            return super.get(propertyName);
        }
    }
}

