/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.FolderCrawler;
import com.sun.javacard.util.FolderCrawlerListener;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.WebModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;

public final class Classes
extends PackageItem
implements FolderCrawlerListener {
    private File folder;
    private Vector<String> names = new Vector();
    private int folderNameLength;
    private SyntheticRepository apiFilesRepository;
    private SyntheticRepository allClassFilesRepository;
    private ZipFile apiJar = null;
    String jcPath;

    public Classes(File file) {
        String string = "";
        try {
            this.jcPath = System.getProperty("jc.home", null);
            if (this.jcPath == null) {
                this.addWarning(ErrorKey.JCHomeNotSet, new Object[0]);
            } else {
                string = this.jcPath + "/lib/api_connected.jar";
                this.apiJar = new ZipFile(string);
                this.apiFilesRepository = SyntheticRepository.getInstance((ClassPath)new ClassPath(string));
            }
        }
        catch (IOException iOException) {
            this.addWarning(ErrorKey.API_JarNotFound, new Object[0]);
            string = "";
        }
        this.folder = file;
        if (file != null) {
            String string2 = file.getAbsolutePath().replace(File.separatorChar, '.');
            if (!string2.endsWith(".")) {
                string2 = string2 + ".";
            }
            this.folderNameLength = string2.length();
            string = string.equals("") ? file.getAbsolutePath() : string + ";" + file.getAbsolutePath();
            this.allClassFilesRepository = SyntheticRepository.getInstance((ClassPath)new ClassPath(string));
        } else {
            this.allClassFilesRepository = this.apiFilesRepository;
        }
    }

    @Override
    public String getItemDisplayName() {
        if (this.folder == null) {
            return "EMPTY";
        }
        String string = "";
        if (this.getParent() != null) {
            string = this.getParent().getItemDisplayName();
        }
        string = string + "/classes:" + this.folder.getName();
        return string;
    }

    @Override
    public void initialize() {
        if (this.folder == null) {
            return;
        }
        if (!this.folder.exists()) {
            this.addError(ErrorKey.DoesNotExists, this.folder);
            return;
        }
        if (!this.folder.isDirectory()) {
            this.addError(ErrorKey.IsNotADirectory, this.folder);
            return;
        }
        FolderCrawler folderCrawler = new FolderCrawler(this.folder, this);
        folderCrawler.crawl();
    }

    public InputStream getClassFileStream(String string) {
        Object object;
        if (this.apiJar != null && (object = this.apiJar.getEntry(string.replace('.', '/') + ".class")) != null) {
            System.err.println("\n\nFound ZipEntry " + string);
            try {
                return this.apiJar.getInputStream((ZipEntry)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if ((object = this.getClassFile(string)) == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return fileInputStream;
    }

    private File getClassFile(String string) {
        if (this.folder == null || !this.getNames().contains(string)) {
            return null;
        }
        return new File(this.folder, string.replace('.', File.separatorChar) + ".class");
    }

    @Override
    public void processInternal() {
        if (this.folder == null) {
            return;
        }
        JavaClass javaClass = null;
        String string = null;
        String string2 = null;
        for (String string3 : this.names) {
            Method[] methodArray;
            try {
                javaClass = this.allClassFilesRepository.loadClass(string3);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnableToParseTheClassFile, string3.replace('.', File.separatorChar) + ".class", exception.getLocalizedMessage());
                continue;
            }
            if (javaClass.getMajor() != 50) {
                // empty if block
            }
            string = javaClass.getPackageName();
            int n = string3.lastIndexOf(46);
            string2 = n == -1 ? "" : string3.substring(0, n);
            if (!string2.equals(string)) {
                this.addWarning(ErrorKey.MismatchedPackageName, string3, string);
            }
            if (this.jcPath == null || !javaClass.isInterface() || !this.isShareable(javaClass)) continue;
            for (Method method : methodArray = javaClass.getMethods()) {
            }
        }
    }

    boolean isShareable(JavaClass javaClass) {
        JavaClass[] javaClassArray = null;
        try {
            javaClassArray = javaClass.getAllInterfaces();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (javaClassArray != null) {
            for (JavaClass javaClass2 : javaClassArray) {
                if (!javaClass2.getClassName().equals("javacard.framework.Shareable")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void fileFound(File file) {
        if (file.isDirectory()) {
            return;
        }
        String string = file.getAbsolutePath().replace(File.separatorChar, '.');
        if (!string.endsWith(".class")) {
            return;
        }
        string = string.substring(this.folderNameLength);
        string = string.substring(0, string.lastIndexOf(".class")).replace(File.separatorChar, '.');
        this.names.addElement(string);
    }

    public File getFolder() {
        return this.folder;
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public boolean isBelongsToModule() {
        return this.getParent() != null && this.getParent() instanceof Module;
    }

    public boolean belongsToWebModule() {
        return this.getParent() != null && this.getParent() instanceof WebModule;
    }

    public boolean belongsToClassicModule() {
        return this.getParent() != null && this.getParent() instanceof ClassicModule;
    }

    public boolean belongsToExtendedModule() {
        return this.getParent() != null && this.getParent() instanceof ExtendedModule;
    }

    public boolean containsInAPI(String string) {
        if (this.apiJar == null) {
            return false;
        }
        return this.apiJar.getEntry(string.replace('.', '/') + ".class") != null;
    }

    public boolean areSIMethodParamsAndReturnValid(Method method) {
        Type[] typeArray;
        for (Type type : typeArray = method.getArgumentTypes()) {
            if (this.isValidParameterOrReturnType(type)) continue;
            this.addError(ErrorKey.invalidParameterForSIMethod, type.toString(), method.toString());
            return false;
        }
        if (!this.isValidParameterOrReturnType(method.getReturnType())) {
            this.addError(ErrorKey.invalidParameterForSIMethod, method.getReturnType().toString(), method.toString());
            return false;
        }
        return true;
    }

    public boolean isValidParameterOrReturnType(Type type) {
        JavaClass javaClass;
        return !(type instanceof ReferenceType) || type instanceof ArrayType || (javaClass = this.getJavaClass(type.toString())) == null || !(!javaClass.isInterface() ? !type.equals((Object)Type.STRING) : !this.isShareable(javaClass));
    }

    public JavaClass getJavaClass(String string) {
        JavaClass javaClass = this.allClassFilesRepository.findClass(string);
        try {
            if (javaClass == null) {
                javaClass = this.allClassFilesRepository.loadClass(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaClass;
    }

    public boolean isAPIImplClass(String string) {
        try {
            JavaClass javaClass = this.apiFilesRepository.loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public Vector<String> getNamesOfClassesInPackage(String string) {
        Vector<String> vector = new Vector<String>();
        JavaClass javaClass = null;
        for (String string2 : this.names) {
            try {
                javaClass = this.allClassFilesRepository.loadClass(string2);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnableToParseTheClassFile, string2.replace('.', File.separatorChar) + ".class", exception.getLocalizedMessage());
                continue;
            }
            String string3 = javaClass.getPackageName();
            if (!string.equals(string3)) continue;
            vector.add(string2);
        }
        return vector;
    }
}

