/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfAttribute;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeConstantValue;
import com.sun.javacard.offcardverifier.exportfile.EfAttributeGeneric;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;

public class EfField
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    int descriptorIndex;
    public EfAttribute[] attributes;
    private boolean sameVersion;
    private String parentClassName;
    private static final int validFlags = 29;
    private static final int staticFinalFlags = 24;
    private static final int publicProtectedFlags = 5;

    EfField(ExportFile exportFile, String string) {
        super(exportFile);
        this.parentClassName = string;
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.nameIndex);
        this.descriptorIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.descriptorIndex);
        int n = this.ef.in.readUnsignedShort();
        this.attributes = new EfAttribute[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.ef.in.readUnsignedShort();
            int n3 = this.ef.in.readInt();
            this.ef.checkUtf8Index(n2);
            String string = ((EfConstant_Utf8)this.ef.constantPool[n2]).contents;
            EfAttribute efAttribute = string.equals("ConstantValue") ? new EfAttributeConstantValue(this.ef) : new EfAttributeGeneric(this.ef);
            efAttribute.attributeNameIndex = n2;
            efAttribute.attributeLength = n3;
            efAttribute.read();
            this.attributes[i] = efAttribute;
        }
    }

    public String name() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    public String sig() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.descriptorIndex]).contents;
    }

    EfAttributeConstantValue constantvalue() {
        for (EfAttribute efAttribute : this.attributes) {
            if (!(efAttribute instanceof EfAttributeConstantValue)) continue;
            return (EfAttributeConstantValue)efAttribute;
        }
        return null;
    }

    public boolean isInlined() {
        String string = this.sig();
        return (this.accessFlag & 0x18) == 24 && (string.equals("B") || string.equals("I") || string.equals("S") || string.equals("Z"));
    }

    public boolean isStatic() {
        return (this.accessFlag & 8) != 0;
    }

    public int wordSize() {
        if (this.sig().equals("I")) {
            return 2;
        }
        return 1;
    }

    void verify(boolean bl, HashSet<EfField> hashSet, BitSet bitSet, BitSet bitSet2) {
        block22: {
            if (!EfNames.validFieldName(this.name())) {
                throw new VerifierError("EfField.5", this.name());
            }
            if (!EfNames.validFieldDescriptor(this.sig())) {
                throw new VerifierError("EfField.6", this.sig());
            }
            try {
                Object object;
                if ((this.accessFlag & 0xFFFFFFE2) != 0) {
                    throw new VerifierError("EfField.1", this.accessFlag);
                }
                if ((this.accessFlag & 5) == 5) {
                    throw new VerifierError("EfField.2");
                }
                if ((this.accessFlag & 5) == 0) {
                    throw new VerifierError("EfField.3");
                }
                if (bl && (this.accessFlag & 0x18) != 24) {
                    throw new VerifierError("EfField.4");
                }
                if (!this.isInlined()) {
                    if (this.attributes.length != 0) {
                        throw new VerifierError("EfField.7");
                    }
                } else {
                    if (this.attributes.length != 1 || !(this.attributes[0] instanceof EfAttributeConstantValue)) {
                        throw new VerifierError("EfField.8");
                    }
                    object = this.constantvalue();
                    ((EfAttributeConstantValue)object).verify(this.sig());
                }
                if (!hashSet.add(this)) {
                    throw new VerifierError("EfField.9");
                }
                if (this.isInlined()) {
                    if (this.token != 255) {
                        throw new VerifierError("EfField.10");
                    }
                    break block22;
                }
                Object object2 = object = this.isStatic() ? bitSet : bitSet2;
                if (((BitSet)object).get(this.token)) {
                    throw new VerifierError("EfField.11", this.token);
                }
                if (!this.isStatic()) {
                    Iterator<EfField> iterator = hashSet.iterator();
                    if (!EfNames.isFieldReferenceType(this.sig())) {
                        if (this.token != 255) {
                            while (iterator.hasNext()) {
                                EfField efField = iterator.next();
                                if (efField.isStatic() || !EfNames.isFieldReferenceType(efField.sig()) || efField.token > this.token) continue;
                                throw new VerifierError("EfField.13");
                            }
                        }
                    } else {
                        while (iterator.hasNext()) {
                            EfField efField = iterator.next();
                            if (efField.isStatic() || EfNames.isFieldReferenceType(efField.sig()) || efField.token == 255 || efField.token < this.token) continue;
                            throw new VerifierError("EfField.13");
                        }
                    }
                }
                ((BitSet)object).set(this.token);
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("EfField.12", (Object)this, (Object)verifierError.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof EfField)) {
            return false;
        }
        EfField efField = (EfField)object;
        return this.name().equals(efField.name()) && this.sig().equals(efField.sig());
    }

    public String toString() {
        return EfNames.prettyField(this.name(), this.sig());
    }

    public void compareTo(EfField efField) {
        this.sameVersion = false;
        this.compareCommon(efField);
        if ((this.accessFlag & 1) > (efField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) < (efField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.29", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) < (efField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void checkEquality(EfField efField) {
        this.sameVersion = true;
        this.compareCommon(efField);
        if ((this.accessFlag & 1) != (efField.accessFlag & 1)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) != (efField.accessFlag & 4)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) != (efField.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.30", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void compareCommon(EfField efField) {
        if (this.token != efField.token) {
            throw new VerifierError("RevisionError.31", (Object)this.name(), (Object)this.parentClassName);
        }
        if (!this.sig().equals(efField.sig())) {
            throw new VerifierError("RevisionError.32", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 8) != (efField.accessFlag & 8)) {
            throw new VerifierError("RevisionError.39", (Object)this.name(), (Object)this.parentClassName);
        }
        EfAttributeConstantValue efAttributeConstantValue = this.constantvalue();
        EfAttributeConstantValue efAttributeConstantValue2 = efField.constantvalue();
        if (efAttributeConstantValue == null && efAttributeConstantValue2 != null) {
            throw new VerifierError("RevisionError.33", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efAttributeConstantValue != null && efAttributeConstantValue2 == null) {
            throw new VerifierError("RevisionError.34", (Object)this.name(), (Object)this.parentClassName);
        }
        if (efAttributeConstantValue != null && efAttributeConstantValue.value() != efAttributeConstantValue2.value()) {
            throw new VerifierError("RevisionError.35", (Object)efField.name(), (Object)this.parentClassName);
        }
    }
}

