/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableEntry;
import com.sun.javacard.jcasm.mask.RomMask;
import java.util.Enumeration;

class PackageTableManager {
    private static final byte TYPE_SIMPLE_OBJECT = 32;
    private static final byte TYPE_BYTE_ARRAY = -128;
    private static final byte TYPE_REFERENCE_ARRAY = -32;
    protected static final byte JCRE_CONTEXT = 0;
    public static final int MAX_AID_SIZE = 16;
    public static final int PACKAGE_MAX = 33;
    public static final int APPLET_PACKAGE_MAX = 16;
    public static final String SINGLE_BYTE_FILLER = "0x00, ";
    public static final int CLASS_COMPONENT = 0;
    public static final int METHOD_COMPONENT = 1;
    public static final int STATIC_FIELD_COMPONENT = 2;
    public static final int EXPORT_COMPONENT = 3;
    private static final int AID_OBJECT_SIZE = 7;
    protected static final int REF_ARRAY_HEADER_SIZE = 10;
    protected static final int REF_SIZE = 2;
    static int byteClassOffset;
    static int refClassOffset;
    static int VMArrayImplementationPkg;
    static int AIDClassOffset;
    static int AIDClassPkgId;
    protected static int packageEntryClassRef;
    static int pkgEntryPkgId;
    protected static int appletEntryClassOffset;
    protected static int appletEntryPkgId;
    static int packageTableReference;
    static int packageContextTableReference;
    RomMask rommask;
    static PackageTableEntry[] packages;
    static byte[] appletPkgContextTable;
    int packageCount = 0;
    int currentPackageEntryCount = 0;
    int packageLocTableAddress;
    private static byte[] targetPackageMgrTable;
    protected static StringBuffer packageTableManagerBuffer;

    PackageTableManager() {
        packageEntryClassRef = 0;
        appletPkgContextTable = new byte[16];
        packages = new PackageTableEntry[33];
        packageTableManagerBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            PackageTableManager.appletPkgContextTable[i] = -1;
        }
    }

    PackageTableEntry addPackage(JCPackage jCPackage) {
        PackageTableEntry packageTableEntry = new PackageTableEntry(jCPackage);
        if (this.packageCount >= 33) {
            Msg.error("cref.5", null);
            Main.printStatus();
        }
        PackageTableManager.packages[this.packageCount] = packageTableEntry;
        ++this.packageCount;
        return packageTableEntry;
    }

    PackageTableEntry getPackageEntry(JCPackage jCPackage) {
        for (int i = 0; i < 33; ++i) {
            if (packages[i] == null || !PackageTableManager.packages[i].packageInfo.equals(jCPackage)) continue;
            return packages[i];
        }
        return null;
    }

    void addAppletPackageContext(int n, boolean bl) {
        int n2;
        if (bl) {
            PackageTableManager.appletPkgContextTable[0] = (byte)n;
            return;
        }
        for (n2 = 1; n2 < 16; ++n2) {
            if (appletPkgContextTable[n2] != -1) continue;
            PackageTableManager.appletPkgContextTable[n2] = (byte)n;
            break;
        }
        if (n2 >= 16) {
            Msg.error("cref.6", null);
            Main.printStatus();
        }
    }

    byte getPkgContextForIndex(int n) {
        for (byte by = 0; by < 16; by = (byte)(by + 1)) {
            if (appletPkgContextTable[by] != n) continue;
            return by;
        }
        return -1;
    }

    static int getCompBaseAddress(JCPackage jCPackage, int n) {
        for (int i = 0; i < 33; ++i) {
            PackageTableEntry packageTableEntry = packages[i];
            if (!packageTableEntry.packageInfo.equals(jCPackage)) continue;
            return packageTableEntry.componentInfoReference[n].compLocation;
        }
        return 0;
    }

    protected static int createAIDObject(byte[] byArray, boolean bl) {
        int n = CrefOutputFormatter.cof.currentRomAddr;
        byte[] byArray2 = PackageTableManager.createByteArrayObject((short)byArray.length, byArray, (byte)0, false);
        int n2 = CrefOutputFormatter.objectManager.addObject(n);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID Array @" + Msg.toAddressString(n) + " */");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray2, ", ") + "," + Msg.eol);
        byte[] byArray3 = new byte[7];
        PackageTableManager.createSimpleObjectHeader(byArray3, AIDClassOffset, (byte)0, bl, AIDClassPkgId);
        byArray3[5] = (byte)(n2 >> 8);
        byArray3[6] = (byte)n2;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID Object @" + Msg.toAddressString(n += byArray2.length) + " */");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(byArray3, ", ") + "," + Msg.eol);
        int n3 = CrefOutputFormatter.objectManager.addObject(n);
        CrefOutputFormatter.cof.currentRomAddr = n += 7;
        return n3;
    }

    void setClassAddrresses() {
        JCClass jCClass = (JCClass)this.rommask.classSymbolTable.get("[B");
        byteClassOffset = jCClass.getRelocAddr();
        VMArrayImplementationPkg = CrefOutputFormatter.cof.packageDirectory.indexOf(jCClass.getParentPackage().getIdentifier());
        JCClass jCClass2 = (JCClass)this.rommask.classSymbolTable.get("[L;");
        refClassOffset = jCClass2.getRelocAddr();
        JCClass jCClass3 = (JCClass)this.rommask.classSymbolTable.get("javacard/framework/AID");
        if (jCClass3 != null) {
            AIDClassOffset = jCClass3.getRelocAddr();
            AIDClassPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(jCClass3.getParentPackage().getIdentifier());
        } else {
            Msg.warn("cref.7", null);
            AIDClassOffset = 0;
        }
        JCClass jCClass4 = (JCClass)this.rommask.classSymbolTable.get("com/sun/javacard/impl/AppletInfo");
        appletEntryClassOffset = jCClass4.getRelocAddr();
        appletEntryPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(jCClass4.getParentPackage().getIdentifier());
        JCClass jCClass5 = (JCClass)this.rommask.classSymbolTable.get("com/sun/javacard/impl/PackageEntry");
        packageEntryClassRef = jCClass5.getRelocAddr();
        pkgEntryPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(jCClass5.getParentPackage().getIdentifier());
    }

    private void createPackageTable() {
        int n = 76;
        targetPackageMgrTable = new byte[n];
        PackageTableManager.createRefArrayObjectHeader(targetPackageMgrTable, 33, (byte)0, packageEntryClassRef, pkgEntryPkgId);
        this.createPackageTableEntries();
        int n2 = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        packageTableManagerBuffer.append("/* Main Package Table @" + Msg.toAddressString(n2) + "*/" + Msg.eol);
        for (int i = 0; i < targetPackageMgrTable.length; ++i) {
            packageTableManagerBuffer.append(Msg.toHexString(targetPackageMgrTable[i]) + ", ");
            if (i % 12 != 11) continue;
            packageTableManagerBuffer.append(Msg.eol);
        }
        packageTableManagerBuffer.append(Msg.eol);
        packageTableReference = CrefOutputFormatter.objectManager.addObject(n2);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(n2 + n);
        CrefOutputFormatter.initializedArrays.append(packageTableManagerBuffer.toString());
    }

    private void createPackageTableEntries() {
        int n = 10;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/*Package Table start*/" + Msg.eol);
        for (int i = 0; i < 33; ++i) {
            if (packages[i] == null) continue;
            int n2 = packages[i].addToMask();
            PackageTableManager.targetPackageMgrTable[n] = (byte)(n2 >> 8);
            PackageTableManager.targetPackageMgrTable[n + 1] = (byte)n2;
            n += 2;
        }
    }

    void createAndAddPackageContextTable() {
        int n = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        byte[] byArray = PackageTableManager.createByteArrayObject((short)16, appletPkgContextTable, (byte)0, false);
        packageTableManagerBuffer.append(Msg.eol + "/* Package Context Table @" + Msg.toAddressString(n) + " */" + Msg.eol);
        for (int i = 0; i < byArray.length; ++i) {
            packageTableManagerBuffer.append(Msg.toHexString(byArray[i]) + ", ");
            if (i % 12 != 11) continue;
            packageTableManagerBuffer.append(Msg.eol);
        }
        packageTableManagerBuffer.append(Msg.eol);
        packageContextTableReference = CrefOutputFormatter.objectManager.addObject(n);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(n + byArray.length);
    }

    void createAndAddPackageTableInfo(RomMask romMask) {
        this.rommask = romMask;
        this.setClassAddrresses();
        for (PackageTableEntry packageTableEntry : packages) {
            if (packageTableEntry == null) continue;
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID for " + packageTableEntry.packageInfo.getName() + " */" + Msg.eol);
            packageTableEntry.pkgAID = PackageTableManager.createAIDObject(packageTableEntry.packageInfo.getIdentifier().getAid().toByteArray(), false);
            Enumeration<AppletDeclarator> enumeration = packageTableEntry.packageInfo.appletElements();
            while (enumeration.hasMoreElements()) {
                packageTableEntry.setAppletInformation(enumeration.nextElement());
            }
        }
        this.createAndAddPackageContextTable();
        this.createPackageTable();
    }

    /*
     * WARNING - void declaration
     */
    int createAndAddPackageLocTable(StringBuffer stringBuffer) {
        int n = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        int n2 = CrefOutputFormatter.cof.currentRomAddr;
        int n3 = n;
        CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable.append("/* Package Location Table @" + Msg.toAddressString(n2) + "*/" + Msg.eol);
        PackageTableEntry[] object = packages;
        int n4 = object.length;
        for (int i = 0; i < n4; ++i) {
            PackageTableEntry packageTableEntry = object[i];
            if (packageTableEntry == null) continue;
            n2 += packageTableEntry.addPackageLocInfoToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, n2);
        }
        CrefOutputFormatter.cof.currentRomAddr = n2;
        stringBuffer.append("/* Package Location Table: Main Table @" + Msg.toAddressString(n) + "*/" + Msg.eol);
        this.packageLocTableAddress = n;
        String string = "0x00, 0x00, ";
        if (Main.FLAG_32_BIT) {
            String string2 = "0x00, 0x00, 0x00, 0x00, ";
        }
        for (n4 = 0; n4 < 33; ++n4) {
            if (packages[n4] != null) {
                if (Main.FLAG_32_BIT) {
                    stringBuffer.append(Msg.to32BitHexString(PackageTableManager.packages[n4].comInfoTableAddress));
                } else {
                    stringBuffer.append(Msg.to16BitHexString(PackageTableManager.packages[n4].comInfoTableAddress));
                }
            } else {
                void var5_8;
                stringBuffer.append((String)var5_8);
            }
            if (n4 % 8 != 7) continue;
            stringBuffer.append(Msg.eol);
        }
        n = Main.FLAG_32_BIT ? (n += 132) : (n += 66);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(n);
        return n - n3;
    }

    protected static void createSimpleObjectHeader(byte[] byArray, int n, byte by, boolean bl, int n2) {
        byArray[0] = bl ? 44 : 32;
        byArray[1] = by;
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
        byArray[4] = (byte)n2;
    }

    public static byte[] createByteArrayObject(short n, byte[] byArray, byte by, boolean bl) {
        int n2 = 7;
        int n3 = n2 + n;
        byte[] byArray2 = new byte[n3];
        byArray2[0] = -128;
        byArray2[1] = by;
        byArray2[2] = (byte)(byteClassOffset >> 8);
        byArray2[3] = (byte)byteClassOffset;
        byArray2[4] = (byte)VMArrayImplementationPkg;
        byArray2[5] = (byte)(n >> 8);
        byArray2[6] = (byte)n;
        for (int i = 0; i < n; ++i) {
            byArray2[n2 + i] = byArray[i];
        }
        return byArray2;
    }

    protected static void createRefArrayObjectHeader(byte[] byArray, int n, byte by, int n2, int n3) {
        byArray[0] = -32;
        byArray[1] = by;
        byArray[2] = (byte)(refClassOffset >> 8);
        byArray[3] = (byte)refClassOffset;
        byArray[4] = (byte)VMArrayImplementationPkg;
        byArray[5] = (byte)(n >> 8);
        byArray[6] = (byte)n;
        byArray[7] = (byte)(n2 >> 8);
        byArray[8] = (byte)n2;
        byArray[9] = (byte)n3;
    }
}

