/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.mask.Main;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Msg {
    protected static final ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/jcasm/MessagesBundle");
    public static final String eol = System.getProperty("line.separator", "\n");
    protected static PrintStream out = System.out;
    protected static PrintStream err = System.err;

    public static void setOut(PrintStream printStream) {
        out = printStream;
    }

    public static void setErr(PrintStream printStream) {
        err = printStream;
    }

    public static void warn(String string) {
        ++Globals.warnings;
        err.print(messages.getString("Msg.warning") + " ");
        err.println(string);
    }

    public static void warn(String string, Object[] objectArray) {
        ++Globals.warnings;
        err.print(messages.getString("Msg.warning") + " ");
        err.println(MessageFormat.format(messages.getString(string), objectArray));
    }

    public static void error(String string) {
        ++Globals.errors;
        err.print(messages.getString("Msg.error") + " ");
        err.println(string);
    }

    public static void error(Exception exception) {
        ++Globals.errors;
        err.print(messages.getString("Msg.error") + " ");
        err.println(exception.getMessage());
    }

    public static void error(String string, Object[] objectArray) {
        ++Globals.errors;
        err.print(messages.getString("Msg.error") + " ");
        err.println(MessageFormat.format(messages.getString(string), objectArray));
    }

    public static void info(String string) {
        out.println(string);
    }

    public static void info(String string, Object[] objectArray) {
        out.println(MessageFormat.format(messages.getString(string), objectArray));
    }

    public static String getMessage(String string) {
        return messages.getString(string);
    }

    public static String getMessage(String string, Object[] objectArray) {
        return MessageFormat.format(messages.getString(string), objectArray);
    }

    public static String toHexString(byte by) {
        int n = by & 0xFF;
        if (n > 15) {
            return "0x" + Integer.toHexString(n);
        }
        return "0x0" + Integer.toHexString(n);
    }

    public static String toHexString(short s) {
        int n = s & 0xFFFF;
        if (n > 4095) {
            return "0x" + Integer.toHexString(n);
        }
        if (n > 255) {
            return "0x0" + Integer.toHexString(n);
        }
        if (n > 15) {
            return "0x00" + Integer.toHexString(n);
        }
        return "0x000" + Integer.toHexString(n);
    }

    public static String toHexString(int n) {
        if (n < 0) {
            return "0x" + Integer.toHexString(n);
        }
        if (n > 0xFFFFFF) {
            return "0x0" + Integer.toHexString(n);
        }
        if (n > 1048575) {
            return "0x00" + Integer.toHexString(n);
        }
        if (n > 65535) {
            return "0x000" + Integer.toHexString(n);
        }
        if (n > 4095) {
            return "0x0000" + Integer.toHexString(n);
        }
        if (n > 255) {
            return "0x00000" + Integer.toHexString(n);
        }
        if (n > 15) {
            return "0x000000" + Integer.toHexString(n);
        }
        return "0x0000000" + Integer.toHexString(n);
    }

    public static String to16BitHexString(int n) {
        if (n < 0) {
            return "0x" + Integer.toHexString(n);
        }
        String string = Msg.toHexString((byte)(n >> 8));
        string = string + ", ";
        string = string + Msg.toHexString((byte)n);
        string = string + ", ";
        return string;
    }

    public static String to24BitHexString(int n) {
        if (n < 0) {
            return "0x" + Integer.toHexString(n);
        }
        String string = Msg.toHexString((byte)(n >> 16));
        string = string + ", ";
        string = string + Msg.toHexString((byte)(n >> 8));
        string = string + ", ";
        string = string + Msg.toHexString((byte)n);
        string = string + ", ";
        return string;
    }

    public static String to32BitHexString(int n) {
        String string = Msg.toHexString((byte)(n >> 24));
        string = string + ", ";
        string = string + Msg.toHexString((byte)(n >> 16));
        string = string + ", ";
        string = string + Msg.toHexString((byte)(n >> 8));
        string = string + ", ";
        string = string + Msg.toHexString((byte)n);
        string = string + ", ";
        return string;
    }

    public static String toAddressString(int n) {
        if (Main.FLAG_32_BIT) {
            return Msg.toHexString(n);
        }
        return Msg.toHexString((short)n);
    }

    public static String toHexString(byte[] byArray) {
        return Msg.toHexString(byArray, ":");
    }

    public static String toHexString(byte[] byArray, String string) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(Msg.toHexString(by) + string);
        }
        stringBuffer.setLength(stringBuffer.length() - string.length());
        return stringBuffer.toString();
    }
}

