/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.javax.smartcard.rmiclient;

import com.sun.javacard.clientlib.CardAccessor;
import com.sun.javacard.javax.smartcard.rmiclient.APDUExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.BioExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CardExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CardRuntimeExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CryptoExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ExternalExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ISOExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.PINExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ServiceExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.SystemExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.TLVExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.TransactionExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.UserExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.UtilExceptionSubclass;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javacard.framework.APDUException;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.framework.service.ServiceException;
import javacard.security.CryptoException;
import javacardx.biometry.BioException;
import javacardx.external.ExternalException;
import javacardx.framework.tlv.TLVException;
import javacardx.framework.util.UtilException;

public abstract class CardObjectFactory {
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/javax/smartcard/rmiclient/MessagesBundle");
    private static final byte NORMAL_TAG = -127;
    private static final byte EXCEPTION_TAG = -126;
    private static final byte EXCEPTION_SUBCLASS_TAG = -125;
    private static final byte ERROR_TAG = -103;
    public static final byte REF_FORMAT_NONE = 0;
    public static final byte REF_FORMAT_CLASS = 1;
    public static final byte REF_FORMAT_INTERFACES = 2;
    private byte invokeINS = 0;
    private static final byte Throwable_Type = 0;
    private static final byte ArithmeticException_Type = 1;
    private static final byte ArrayIndexOutOfBoundsException_Type = 2;
    private static final byte ArrayStoreException_Type = 3;
    private static final byte ClassCastException_Type = 4;
    private static final byte Exception_Type = 5;
    private static final byte IndexOutOfBoundsException_Type = 6;
    private static final byte NegativeArraySizeException_Type = 7;
    private static final byte NullPointerException_Type = 8;
    private static final byte RuntimeException_Type = 9;
    private static final byte SecurityException_Type = 10;
    private static final byte java_io_IOException_Type = 11;
    private static final byte java_rmi_RemoteException_Type = 12;
    private static final byte APDUException_Type = 32;
    private static final byte CardException_Type = 33;
    private static final byte CardRuntimeException_Type = 34;
    private static final byte ISOException_Type = 35;
    private static final byte PINException_Type = 36;
    private static final byte SystemException_Type = 37;
    private static final byte TransactionException_Type = 38;
    private static final byte UserException_Type = 39;
    private static final byte CryptoException_Type = 48;
    private static final byte ServiceException_Type = 64;
    private static final byte BioException_Type = 80;
    private static final byte ExternalException_Type = 96;
    private static final byte TLVException_Type = 112;
    private static final byte UtilException_Type = -128;

    public Object getObject(byte[] byArray, int n, Class clazz, CardAccessor cardAccessor) throws RemoteException, StubNotFoundException, Exception {
        this.throwException(byArray, n);
        try {
            String string = clazz.getName();
            if (string.startsWith("[") || "boolean".equals(string) || "byte".equals(string) || "short".equals(string) || "int".equals(string) || "void".equals(string)) {
                return this.getNonRemoteObject(byArray, n, clazz);
            }
            return this.getRemoteObject(byArray, n, cardAccessor);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
    }

    protected abstract Remote getRemoteObject(byte[] var1, int var2, CardAccessor var3) throws Exception;

    private Object getNonRemoteObject(byte[] byArray, int n, Class clazz) throws RemoteException, Exception {
        this.throwException(byArray, n);
        int n2 = n + 1;
        String string = clazz.getName();
        if ("boolean".equals(string)) {
            return this.readBooleanObject(byArray, n2);
        }
        if ("byte".equals(string)) {
            return this.readByteObject(byArray, n2);
        }
        if ("short".equals(string)) {
            return this.readShortObject(byArray, n2);
        }
        if ("int".equals(string)) {
            return this.readIntegerObject(byArray, n2);
        }
        if ("void".equals(string)) {
            return this.readVoidObject(byArray, n2);
        }
        if ("[Z".equals(string)) {
            return this.readBooleanArray(byArray, n2);
        }
        if ("[B".equals(string)) {
            return this.readByteArray(byArray, n2);
        }
        if ("[S".equals(string)) {
            return this.readShortArray(byArray, n2);
        }
        if ("[I".equals(string)) {
            return this.readIntArray(byArray, n2);
        }
        throw new RemoteException(_messages.getString("other.1"));
    }

    public void setINSByte(byte by) {
        this.invokeINS = by;
    }

    public byte getINSByte() {
        return this.invokeINS;
    }

    public abstract byte getRemoteRefFormat();

    private boolean readBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    private byte readByte(byte[] byArray, int n) {
        return byArray[n];
    }

    private short readShort(byte[] byArray, int n) {
        return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    private int readInt(byte[] byArray, int n) {
        return byArray[n] << 24 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    private Boolean readBooleanObject(byte[] byArray, int n) {
        boolean bl = this.readBoolean(byArray, n);
        return new Boolean(bl);
    }

    private Byte readByteObject(byte[] byArray, int n) {
        byte by = this.readByte(byArray, n);
        return new Byte(by);
    }

    private Short readShortObject(byte[] byArray, int n) {
        short s = this.readShort(byArray, n);
        return new Short(s);
    }

    private Integer readIntegerObject(byte[] byArray, int n) {
        int n2 = this.readInt(byArray, n);
        return new Integer(n2);
    }

    private Void readVoidObject(byte[] byArray, int n) {
        return null;
    }

    private boolean[] readBooleanArray(byte[] byArray, int n) {
        if (byArray[n] == -1) {
            return null;
        }
        int n2 = byArray[n] & 0xFF;
        int n3 = n + 1;
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            blArray[i] = this.readBoolean(byArray, n3);
            ++n3;
        }
        return blArray;
    }

    private byte[] readByteArray(byte[] byArray, int n) {
        if (byArray[n] == -1) {
            return null;
        }
        int n2 = byArray[n] & 0xFF;
        int n3 = n + 1;
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = this.readByte(byArray, n3);
            ++n3;
        }
        return byArray2;
    }

    private short[] readShortArray(byte[] byArray, int n) {
        if (byArray[n] == -1) {
            return null;
        }
        int n2 = byArray[n] & 0xFF;
        int n3 = n + 1;
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = this.readShort(byArray, n3);
            n3 += 2;
        }
        return sArray;
    }

    private int[] readIntArray(byte[] byArray, int n) {
        if (byArray[n] == -1) {
            return null;
        }
        int n2 = byArray[n] & 0xFF;
        int n3 = n + 1;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.readInt(byArray, n3);
            n3 += 4;
        }
        return nArray;
    }

    private void throwException(byte[] byArray, int n) throws Exception {
        byte by;
        try {
            by = byArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
        int n2 = n + 1;
        if (by == -126) {
            this.throwIt(byArray, n2);
        }
        if (by == -125) {
            this.throwSubclass(byArray, n2);
        }
        if (by == -103) {
            this.throwError(byArray, n2);
        }
        if (by != -127) {
            throw new RemoteException(_messages.getString("unsupported.1"));
        }
    }

    private void throwIt(byte[] byArray, int n) throws Exception {
        short s;
        byte by;
        try {
            by = byArray[n];
            s = this.readShort(byArray, n + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
        switch (by) {
            case 0: {
                throw new Exception(_messages.getString("thrown.throwable"));
            }
            case 1: {
                throw new ArithmeticException(_messages.getString("thrown.exact"));
            }
            case 2: {
                throw new ArrayIndexOutOfBoundsException(_messages.getString("thrown.exact"));
            }
            case 3: {
                throw new ArrayStoreException(_messages.getString("thrown.exact"));
            }
            case 4: {
                throw new ClassCastException(_messages.getString("thrown.exact"));
            }
            case 5: {
                throw new Exception(_messages.getString("thrown.exact"));
            }
            case 6: {
                throw new IndexOutOfBoundsException(_messages.getString("thrown.exact"));
            }
            case 7: {
                throw new NegativeArraySizeException(_messages.getString("thrown.exact"));
            }
            case 8: {
                throw new NullPointerException(_messages.getString("thrown.exact"));
            }
            case 9: {
                throw new RuntimeException(_messages.getString("thrown.exact"));
            }
            case 10: {
                throw new SecurityException(_messages.getString("thrown.exact"));
            }
            case 11: {
                throw new IOException(_messages.getString("thrown.exact"));
            }
            case 12: {
                throw new RemoteException(_messages.getString("thrown.exact"));
            }
            case 32: {
                throw new APDUException(s);
            }
            case 33: {
                throw new CardException(s);
            }
            case 34: {
                throw new CardRuntimeException(s);
            }
            case 35: {
                throw new ISOException(s);
            }
            case 36: {
                throw new PINException(s);
            }
            case 37: {
                throw new SystemException(s);
            }
            case 38: {
                throw new TransactionException(s);
            }
            case 39: {
                throw new UserException(s);
            }
            case 48: {
                throw new CryptoException(s);
            }
            case 64: {
                throw new ServiceException(s);
            }
            case 80: {
                throw new BioException(s);
            }
            case 96: {
                throw new ExternalException(s);
            }
            case 112: {
                throw new TLVException(s);
            }
            case -128: {
                throw new UtilException(s);
            }
        }
        throw new RemoteException(_messages.getString("thrown.unknown"));
    }

    private void throwSubclass(byte[] byArray, int n) throws Exception {
        byte by = byArray[n];
        short s = this.readShort(byArray, n + 1);
        switch (by) {
            case 0: {
                throw new Exception(_messages.getString("thrown.throwable_subclass"));
            }
            case 1: {
                throw new ArithmeticException(_messages.getString("thrown.subclass"));
            }
            case 2: {
                throw new ArrayIndexOutOfBoundsException(_messages.getString("thrown.subclass"));
            }
            case 3: {
                throw new ArrayStoreException(_messages.getString("thrown.subclass"));
            }
            case 4: {
                throw new ClassCastException(_messages.getString("thrown.subclass"));
            }
            case 5: {
                throw new Exception(_messages.getString("thrown.subclass"));
            }
            case 6: {
                throw new IndexOutOfBoundsException(_messages.getString("thrown.subclass"));
            }
            case 7: {
                throw new NegativeArraySizeException(_messages.getString("thrown.subclass"));
            }
            case 8: {
                throw new NullPointerException(_messages.getString("thrown.subclass"));
            }
            case 9: {
                throw new RuntimeException(_messages.getString("thrown.subclass"));
            }
            case 10: {
                throw new SecurityException(_messages.getString("thrown.subclass"));
            }
            case 11: {
                throw new IOException(_messages.getString("thrown.subclass"));
            }
            case 12: {
                throw new RemoteException(_messages.getString("thrown.subclass"));
            }
            case 32: {
                throw new APDUExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 33: {
                throw new CardExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 34: {
                throw new CardRuntimeExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 35: {
                throw new ISOExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 36: {
                throw new PINExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 37: {
                throw new SystemExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 38: {
                throw new TransactionExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 39: {
                throw new UserExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 48: {
                throw new CryptoExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 64: {
                throw new ServiceExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 80: {
                throw new BioExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 96: {
                throw new ExternalExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case 112: {
                throw new TLVExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
            case -128: {
                throw new UtilExceptionSubclass(_messages.getString("thrown.subclass"), s);
            }
        }
        throw new RemoteException(_messages.getString("thrown.unknown_subclass"));
    }

    private void throwError(byte[] byArray, int n) throws RemoteException {
        short s = this.readShort(byArray, n);
        switch (s) {
            case 1: {
                throw new RemoteException(_messages.getString("error.1"));
            }
            case 2: {
                throw new RemoteException(_messages.getString("error.2"));
            }
            case 3: {
                throw new RemoteException(_messages.getString("error.3"));
            }
            case 4: {
                throw new RemoteException(_messages.getString("error.4"));
            }
            case 5: {
                throw new RemoteException(_messages.getString("error.5"));
            }
            case 6: {
                throw new RemoteException(_messages.getString("error.6"));
            }
        }
        throw new RemoteException(_messages.getString("error.unsupported"));
    }
}

