/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classparser.constantpoolclasses;

import com.sun.javacard.debugproxy.classparser.constantpoolclasses.ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ConstantFloatInfo
extends ConstantPoolInfo {
    private int bytes;

    public ConstantFloatInfo(DataInputStream dataInputStream) throws IOException {
        this.tag = (byte)4;
        this.bytes = dataInputStream.readInt();
    }

    @Override
    public String toString() {
        if (this.bytes == 2139095040) {
            return "CONSTANT_Float=\tPositive Infinity";
        }
        if (this.bytes == -8388608) {
            return "CONSTANT_Float=\tNegative Infinity";
        }
        if (this.bytes >= 2139095041 && this.bytes <= Integer.MAX_VALUE || this.bytes >= -8388607 && this.bytes <= -1) {
            return "CONSTANT_Float=\tNaN";
        }
        int n = this.bytes >> 31 == 0 ? 1 : -1;
        int n2 = this.bytes >> 23 & 0xFF;
        int n3 = n2 == 0 ? (this.bytes & 0x7FFFFF) << 1 : this.bytes & 0x7FFFFF | 0x800000;
        float f = n * n3 * (2 ^ n2 - 150);
        return "CONSTANT_Float=\t" + f;
    }
}

