/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.debugproxy.CJCREListener;
import com.sun.javacard.debugproxy.JDBListener;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.OptionNames;
import com.sun.javacard.debugproxy.Options;
import com.sun.javacard.debugproxy.classparser.ClassManager;
import com.sun.javacard.debugproxy.classparser.SearchPath;
import org.apache.commons.cli.Option;

public class DebugCommand
extends SubCommand {
    public DebugCommand() {
        super("debug");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("l", "listen"));
        this.addOption(new CommandOption("r", "remote"));
        this.addOption(new CommandOption("v", "verbosity"));
        this.addOption(new CommandOption("c", "classpath"));
    }

    @Override
    public int execute() throws Exception {
        Options options = new Options();
        block6: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case LISTEN: {
                    options.setLocalPort(Integer.parseInt(option.getValue()));
                    continue block6;
                }
                case REMOTE: {
                    String string = option.getValue();
                    int n = string.indexOf(":");
                    if (n == -1) continue block6;
                    options.setRemoteHost(string.substring(0, n));
                    options.setRemotePort(Integer.parseInt(string.substring(n + 1)));
                    continue block6;
                }
                case VERBOSITY: {
                    options.setVerbosity(Integer.parseInt(option.getValue()));
                    continue block6;
                }
                case CLASSPATH: {
                    options.setClasspath(option.getValue());
                    continue block6;
                }
                default: {
                    String string = option.getOpt();
                    String string2 = option.getLongOpt();
                    String string3 = "";
                    if (string != null) {
                        string3 = string3 + string;
                    }
                    if (string != null && string2 != null) {
                        string3 = string3 + " (or) ";
                    }
                    if (string2 != null) {
                        string3 = string3 + string2;
                    }
                    this.toolsLogger.severe("Unknown option:" + string3, new Object[0]);
                    throw new Exception("Unknown option " + string3);
                }
            }
        }
        return this.go(options);
    }

    private int go(Options options) {
        Log.SET_LOG(options.getVerbosity());
        try {
            ClassManager classManager = new ClassManager(new SearchPath(options.getClasspath()));
            System.out.println("Connecting to " + options.getRemoteHost() + " on port " + options.getRemotePort());
            JDBListener jDBListener = new JDBListener(options);
            CJCREListener cJCREListener = new CJCREListener(options);
            jDBListener.set(cJCREListener, classManager);
            cJCREListener.set(jDBListener, classManager);
            jDBListener.verbose(options.getVerbosity());
            cJCREListener.verbose(options.getVerbosity());
            new Thread(jDBListener).start();
            new Thread(cJCREListener).start();
        }
        catch (SecurityException securityException) {
            System.out.println("KVMDebugProxy: " + securityException.getMessage());
        }
        return 0;
    }
}

